/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.rcs.sc.alarm.AlarmHelper;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.bean.MessageResponse;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.remoting.RemotingServerCallback;
import com.xdja.rcs.sc.remoting.protocol.RemotingData;
import com.xdja.rcs.sc.server.exception.MessageProcessException;
import com.xdja.rcs.sc.server.process.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScServerRemotingServerCallback
implements RemotingServerCallback {
    private static final Logger logger = LoggerFactory.getLogger(ScServerRemotingServerCallback.class);

    public RemotingData callWithResponse(RemotingData request) {
        MessageResponse response = new MessageResponse();
        try {
            Message message = (Message)JSONUtil.toJavaBean((byte[])request.getContent(), (TypeReference)new TypeReference<Message>(){});
            MessageProcessor.getInstance().process(message);
            response.setSuccess(true);
            response.setTopicId(message.getTopicId());
            response.setMsgId(message.getMsgId());
        }
        catch (JSONException e) {
            logger.error("\u6d88\u606f\u4ecebyte[]\u8f6c\u6362\u4e3aMessage\u5931\u8d25", (Throwable)e);
            response.setReason("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u5904\u7406\u6d88\u606f\u5931\u8d25\uff08\u6d88\u606f\u4ecebyte[]\u8f6c\u6362\u4e3aMessage\u5931\u8d25\uff09");
        }
        catch (UnrecoverableException e) {
            AlarmHelper.sendAlarmEmail((String)("\u544a\u8b66\u5185\u5bb9\uff1a\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u5904\u7406\u6d88\u606f\u5931\u8d25\uff08" + e.getMessage() + "\uff09"));
            logger.error("\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
            response.setReason("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u5904\u7406\u6d88\u606f\u5931\u8d25\uff08" + e.getMessage() + "\uff09");
        }
        catch (MessageProcessException e) {
            logger.error("\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
            response.setRecoverable(e.isRecoverable());
            response.setReason("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u5904\u7406\u6d88\u606f\u5931\u8d25\uff08" + e.getMessage() + "\uff09");
        }
        try {
            return RemotingData.createResponse((byte[])JSONUtil.toJSONBytes((Object)response));
        }
        catch (JSONException e) {
            logger.error("\u54cd\u5e94\u6570\u636e\u4eceMessageResponse\u8f6c\u6362\u4e3abyte[]\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void callWithoutResponse(RemotingData request) {
    }
}

