/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.config;

import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.server.config.node.ConsumerNode;
import com.xdja.rcs.sc.server.config.node.ProducerNode;
import com.xdja.rcs.sc.server.config.node.ScServerNode;
import com.xdja.rcs.sc.server.config.node.TopicNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

class ScServerConfig {
    private ScServerNode server;
    private QueueNode queue;
    private final Map<String, ProducerNode> producers = new ConcurrentHashMap<String, ProducerNode>(5);
    private final Map<String, ConsumerNode> consumers = new ConcurrentHashMap<String, ConsumerNode>(5);
    private final Map<String, TopicNode> topics = new ConcurrentHashMap<String, TopicNode>(10);

    ScServerConfig() {
    }

    public ScServerNode getScServer() {
        return this.server;
    }

    public QueueNode getQueueConfig() {
        return this.queue;
    }

    public void setQueue(QueueNode queue) {
        this.queue = queue;
    }

    public Map<String, TopicNode> getTopics() {
        return Collections.unmodifiableMap(this.topics);
    }

    public TopicNode getTopic(String topicId) {
        return this.topics.get(topicId);
    }

    public ProducerNode getProducer(String producerId) {
        return this.producers.get(producerId);
    }

    public Collection<ProducerNode> getProducers() {
        return Collections.unmodifiableCollection(this.producers.values());
    }

    public boolean checkProducerId(String producerId) {
        return this.producers.containsKey(producerId);
    }

    public ConsumerNode getConsumer(String consumerId) {
        return this.consumers.get(consumerId);
    }

    public Collection<ConsumerNode> getConsumers() {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    public boolean checkConsumerId(String consumerId) {
        return this.consumers.containsKey(consumerId);
    }

    public void setServer(ScServerNode scServer) {
        this.server = scServer;
    }

    public void setTopics(List<TopicNode> topicList) {
        if (CollectionUtils.isNotEmpty(topicList)) {
            for (TopicNode topicNode : topicList) {
                this.topics.put(topicNode.getTopicId(), topicNode);
            }
        }
    }

    public void setProducers(List<ProducerNode> producerList) {
        if (CollectionUtils.isNotEmpty(producerList)) {
            for (ProducerNode producerNode : producerList) {
                this.producers.put(producerNode.getAppId(), producerNode);
            }
        }
    }

    public void setConsumers(List<ConsumerNode> consumerList) {
        if (CollectionUtils.isNotEmpty(consumerList)) {
            for (ConsumerNode consumerNode : consumerList) {
                this.consumers.put(consumerNode.getAppId(), consumerNode);
            }
        }
    }
}

