/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.config.node;

import com.xdja.rcs.sc.server.config.node.ConsumerNode;
import com.xdja.rcs.sc.server.config.node.ProducerNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class TopicNode {
    private String topicId;
    private String desc;
    private final Map<String, ProducerNode> producers = new ConcurrentHashMap<String, ProducerNode>(5);
    private final Map<String, ConsumerNode> consumers = new ConcurrentHashMap<String, ConsumerNode>(5);
    private String[] tags = null;

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ProducerNode getProducer(String producerId) {
        return this.producers.get(producerId);
    }

    public Collection<ProducerNode> getProducers() {
        return this.producers.values();
    }

    public void setProducers(List<ProducerNode> producerList) {
        if (CollectionUtils.isNotEmpty(producerList)) {
            for (ProducerNode producerNode : producerList) {
                this.producers.put(producerNode.getAppId(), producerNode);
            }
        }
    }

    public ConsumerNode getConsumer(String consumerId) {
        return this.consumers.get(consumerId);
    }

    public Collection<ConsumerNode> getConsumers() {
        return this.consumers.values();
    }

    public void setConsumers(List<ConsumerNode> consumerList) {
        if (CollectionUtils.isNotEmpty(consumerList)) {
            for (ConsumerNode consumerNode : consumerList) {
                this.consumers.put(consumerNode.getAppId(), consumerNode);
            }
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }
}

