/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.process;

import com.xdja.platform.scan.ClassScanUtil;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.server.exception.MessageProcessException;
import com.xdja.rcs.sc.server.process.MessageDispatcher;
import com.xdja.rcs.sc.server.process.MessageVerifier;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessor {
    private static final MessageProcessor instance = new MessageProcessor();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<MessageVerifier> verifiers = new LinkedList<MessageVerifier>();
    private List<MessageDispatcher> dispatchers = new LinkedList<MessageDispatcher>();
    private final CacheManager cacheManager = CacheManager.create((InputStream)this.getClass().getResourceAsStream("/ehcache.xml"));
    private final Ehcache msgIdCache = this.cacheManager.getEhcache("msgIdCache");

    public static final MessageProcessor getInstance() {
        return instance;
    }

    private MessageProcessor() {
    }

    public void init() throws UnrecoverableException {
        String packageName = MessageProcessor.class.getPackage().getName();
        try {
            for (Class clazz : ClassScanUtil.getClasses((String)packageName)) {
                if (ArrayUtils.contains((Object[])clazz.getInterfaces(), MessageVerifier.class)) {
                    this.verifiers.add((MessageVerifier)clazz.newInstance());
                }
                if (!ArrayUtils.contains((Object[])clazz.getInterfaces(), MessageDispatcher.class)) continue;
                this.dispatchers.add((MessageDispatcher)clazz.newInstance());
            }
        }
        catch (Exception e) {
            throw UnrecoverableException.create((String)"\u6d88\u606f\u5904\u7406\u5668\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(this.dispatchers)) {
            throw UnrecoverableException.create((String)"\u6d88\u606f\u5904\u7406\u5668\u521d\u59cb\u5316\u5931\u8d25\uff1a\u672a\u627e\u5230\u5b9e\u73b0\u4e86MessageDispatcher\u63a5\u53e3\u7684\u6d88\u606f\u5206\u53d1\u5668");
        }
        Collections.sort(this.verifiers, new Comparator<MessageVerifier>(){

            @Override
            public int compare(MessageVerifier o1, MessageVerifier o2) {
                if (o1.getOrder() < o2.getOrder()) {
                    return -1;
                }
                if (o1.getOrder() > o2.getOrder()) {
                    return 1;
                }
                return 0;
            }
        });
        Collections.sort(this.dispatchers, new Comparator<MessageDispatcher>(){

            @Override
            public int compare(MessageDispatcher o1, MessageDispatcher o2) {
                if (o1.getOrder() < o2.getOrder()) {
                    return -1;
                }
                if (o1.getOrder() > o2.getOrder()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void process(Message message) throws UnrecoverableException, MessageProcessException {
        for (MessageVerifier verifier : this.verifiers) {
            verifier.verify(message);
        }
        if (null != this.msgIdCache.getQuiet((Serializable)((Object)message.getMsgId()))) {
            this.msgIdCache.flush();
            this.logger.debug("\u4e3b\u9898\u4e3a{}\u7684\u6d88\u606f{}\u5df2\u7ecf\u88ab\u63a5\u6536\u5e76\u5904\u7406\u8fc7", (Object)message.getTopicId(), (Object)message.getMsgId());
            return;
        }
        this.msgIdCache.flush();
        this.msgIdCache.put(new Element((Serializable)((Object)message.getMsgId()), (Serializable)((Object)message.getMsgId())));
        for (MessageDispatcher dispatcher : this.dispatchers) {
            dispatcher.dispatch(message);
        }
    }
}

