/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.process.dispatcher;

import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UninitializedException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.singleton.thread.SingleThreadFactory;
import com.xdja.platform.util.json.JSONException;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.server.config.ScServerConfigProxy;
import com.xdja.rcs.sc.server.config.node.ConsumerNode;
import com.xdja.rcs.sc.server.config.node.TopicNode;
import com.xdja.rcs.sc.server.exception.MessageProcessException;
import com.xdja.rcs.sc.server.process.MessageDispatcher;
import com.xdja.rcs.sc.server.route.MessageRouteThread;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcherImpl
implements MessageDispatcher {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void dispatch(Message message) throws MessageProcessException {
        TopicNode topic = ScServerConfigProxy.getTopic(message.getTopicId());
        String[] tags = null;
        for (ConsumerNode consumer : topic.getConsumers()) {
            if (ArrayUtils.isNotEmpty((Object[])consumer.getTags()) && ArrayUtils.isNotEmpty((Object[])message.getTags())) {
                tags = (String[])ArrayUtils.removeElements((Object[])message.getTags(), (Object[])ArrayUtils.removeElements((Object[])message.getTags(), (Object[])consumer.getTags()));
            }
            if (null != tags && tags.length <= 0) {
                tags = null;
                continue;
            }
            Message msgClone = message.clone();
            if (null != tags) {
                msgClone.setTags(tags);
            }
            msgClone.setOrder(System.currentTimeMillis());
            try {
                CacheableQueue queue = ScMessageQueueFactory.getQueue((String)consumer.getAppId(), (QueueNode)ScServerConfigProxy.getQueueConfig());
                queue.put((Object)msgClone);
            }
            catch (UnknownElementClassException e) {
            }
            catch (UninitializedException e) {
                throw new MessageProcessException("\u6d88\u8d39\u8005\"" + consumer.getAppId() + "\"\u7684\u6d88\u606f\u961f\u5217\u6a21\u5757\u672a\u521d\u59cb\u5316", e);
            }
            catch (JSONException e) {
                throw new MessageProcessException("\u628a\u6d88\u606f\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32\u5931\u8d25", e);
            }
            catch (QueueCacheAccessFailureException e) {
                throw new MessageProcessException("\u8bbf\u95ee\u961f\u5217\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38", e).setRecoverable(true);
            }
            SingleThreadFactory.run(MessageRouteThread.class, (String)consumer.getAppId());
            tags = null;
        }
        this.logger.debug("\u6536\u5230\u751f\u4ea7\u8005\u5e94\u7528\"{}\"\u53d1\u9001\u7684\u4e3b\u9898\u4e3a\"{}\"\u7684\u6d88\u606f\"{}\",\u5e76\u52a0\u5165\u5bf9\u5e94\u7684\u8def\u7531\u961f\u5217\u6210\u529f", new Object[]{message.getProducer(), message.getTopicId(), message.getMsgId()});
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

