/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.route;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.rcs.sc.alarm.AlarmHelper;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.bean.MessageResponse;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.remoting.api.RemotingAPI;
import com.xdja.rcs.sc.remoting.protocol.RemotingData;
import com.xdja.rcs.sc.server.config.ScServerConfigProxy;
import com.xdja.rcs.sc.server.config.node.ConsumerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageRouteThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int retryInterval = 5000;
    private final int retryCount = 24;
    protected int retryTimes = 0;
    private CacheableQueue<Message> queue;
    private String tag = null;

    public void setTag(String tag) {
        this.tag = tag;
        try {
            this.queue = ScMessageQueueFactory.getQueue((String)tag, (QueueNode)ScServerConfigProxy.getQueueConfig());
        }
        catch (UnknownElementClassException e) {
        }
        catch (QueueCacheAccessFailureException queueCacheAccessFailureException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Message message = null;
        while (true) {
            try {
                while (true) {
                    if (null != (message = (Message)this.queue.take())) {
                        ConsumerNode consumer = ScServerConfigProxy.getConsumer(this.tag);
                        RemotingData response = RemotingAPI.sendData((String)consumer.getAddr(), (int)consumer.getPort(), (byte[])JSONUtil.toJSONBytes((Object)message));
                        if (null == response) continue;
                        MessageResponse msgResp = (MessageResponse)JSONUtil.toJavaBean((byte[])response.getContent(), (TypeReference)new TypeReference<MessageResponse>(){});
                        if (msgResp.isSuccess()) {
                            this.retryTimes = 0;
                            continue;
                        }
                        this.logger.error("\u53d1\u9001\u6d88\u606f\u5230\u6d88\u8d39\u8005\"" + this.tag + "\"\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a" + msgResp.getReason());
                        this.retry(message);
                        continue;
                    }
                    this.retryTimes = 0;
                }
            }
            catch (JSONException e) {
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5230\u6d88\u8d39\u8005\"" + this.tag + "\"\u5931\u8d25", (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                if (null == message) continue;
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5230\u6d88\u8d39\u8005\"" + this.tag + "\"\u5931\u8d25\uff1a\u5c1d\u8bd5\u91cd\u65b0\u53d1\u9001", t);
                this.retry(message);
                continue;
            }
            break;
        }
    }

    private void retry(Message message) {
        try {
            this.queue.put4FirstTaking((Object)message);
            if (this.retryTimes++ >= 24) {
                AlarmHelper.sendAlarmEmail((String)("\u544a\u8b66\u5185\u5bb9\uff1a\u8ba2\u9605\u4e2d\u5fc3\u53d1\u9001\u6d88\u606f\u5230\u6d88\u8d39\u8005\"" + this.tag + "\"\u5931\u8d25"));
                this.retryTimes = 0;
            }
        }
        catch (Throwable t1) {
            this.logger.error("\u4e3b\u9898\u4e3a\"" + message.getTopicId() + "\"\u7684\u6d88\u606f\"" + message.getMsgId() + "\"\u91cd\u65b0\u653e\u56de\u8def\u7531\u961f\u5217\u5931\u8d25", t1);
        }
        try {
            this.getClass();
            Thread.sleep(5000L);
        }
        catch (Throwable t1) {
            this.logger.warn("\u8def\u7531\u6d88\u606f\u91cd\u8bd5\u65f6\u7ebf\u7a0b\u4f11\u7720\u5931\u8d25");
        }
    }
}

