/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.route;

import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.singleton.thread.SingleThreadFactory;
import com.xdja.platform.util.json.JSONException;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.server.config.ScServerConfigProxy;
import com.xdja.rcs.sc.server.config.node.ConsumerNode;
import com.xdja.rcs.sc.server.route.MessageRouteThread;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRouter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final MessageRouter instance = new MessageRouter();
    private final List<String> initedConsumerList = new ArrayList<String>();

    public static final MessageRouter getInstance() {
        return instance;
    }

    public void init() throws UnrecoverableException {
        QueueNode queueConfig = ScServerConfigProxy.getQueueConfig();
        if (null == queueConfig) {
            throw UnrecoverableException.create((String)"\u6d88\u606f\u8def\u7531\u5668\u521d\u59cb\u5316\u5931\u8d25\uff1a\u672a\u627e\u5230\u6d88\u606f\u961f\u5217\u7f13\u5b58\u914d\u7f6e\u4fe1\u606f");
        }
        for (ConsumerNode consumerNode : ScServerConfigProxy.getConsumers()) {
            if (this.initedConsumerList.contains(consumerNode.getAppId())) continue;
            try {
                CacheableQueue queue = ScMessageQueueFactory.getQueue((String)consumerNode.getAppId(), (QueueNode)queueConfig);
                queue.recover();
            }
            catch (UnknownElementClassException e) {
            }
            catch (QueueCacheAccessFailureException e) {
                throw UnrecoverableException.create((String)"\u6d88\u606f\u8def\u7531\u5668\u521d\u59cb\u5316\u5931\u8d25\uff1a\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
            }
            catch (JSONException e) {
                throw UnrecoverableException.create((String)("\u6d88\u606f\u8def\u7531\u5668\u521d\u59cb\u5316\u5931\u8d25\uff1a\u6062\u590d/\u521b\u5efa\u6d88\u8d39\u8005\"" + consumerNode.getAppId() + "\"\u7684\u961f\u5217\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
            SingleThreadFactory.run(MessageRouteThread.class, (String)consumerNode.getAppId());
            this.logger.info("\u521d\u59cb\u5316\u6d88\u8d39\u8005{}\u7684\u961f\u5217\u5e76\u542f\u52a8\u5bf9\u5e94\u7684\u6d88\u606f\u8def\u7531\u7ebf\u7a0b\u6210\u529f", (Object)consumerNode.getAppId());
            this.initedConsumerList.add(consumerNode.getAppId());
        }
        for (String string : this.initedConsumerList) {
            if (ScServerConfigProxy.checkConsumerExists(string)) continue;
        }
    }
}

