/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server.starter;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import com.xdja.rcs.sc.server.ScServer;
import com.xdja.rcs.sc.server.starter.ScClassLoader;
import com.xdja.server.jetty.JettyConfiguration;
import com.xdja.server.jetty.JettyServer;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScServerStarter {
    private Logger logger;

    public static void main(String[] args) {
        new ScServerStarter().start();
    }

    private void start() {
        System.out.println("\u6b63\u5728\u542f\u52a8\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1...");
        try {
            String scHome = System.getProperty("scHome");
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(new File(scHome, "/conf/logback.xml"));
            this.logger = LoggerFactory.getLogger(this.getClass());
            ClassLoader parent = this.findParentClassLoader();
            ScClassLoader loader = new ScClassLoader(parent, new File("../lib"));
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerClass = loader.loadClass("com.xdja.rcs.sc.server.ScServer");
            ScServer scServer = (ScServer)containerClass.newInstance();
            scServer.init(scHome + "/conf/");
            System.out.println("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u542f\u52a8\u6210\u529f!");
            String adminPort = System.getProperty("port");
            if (!StringUtils.isNumeric((CharSequence)adminPort)) {
                adminPort = "8081";
            }
            JettyConfiguration configuration = new JettyConfiguration(scHome + "/webapp", "/", Integer.parseInt(adminPort));
            JettyServer.configurate(configuration).start();
        }
        catch (Throwable e) {
            if (this.logger != null) {
                this.logger.error("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u542f\u52a8\u5931\u8d25", e);
            } else {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null && (parent = this.getClass().getClassLoader()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

