/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.webapp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String filePath;

    protected void responseJson(HttpServletResponse response, Object object) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("application/json;charset=UTF-8");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(this.toJsonString(object));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.filePath = config.getServletContext().getInitParameter("filePath");
        if (StringUtils.isBlank((CharSequence)this.filePath)) {
            this.filePath = System.getProperty("scHome") + "/conf/sc_server_config.json";
        }
        this.logger.debug("\u7ba1\u7406\u7684\u914d\u7f6e\u6587\u4ef6\u4e3a\uff1a{}", (Object)this.filePath);
    }

    private String toJsonString(Object obj) {
        try {
            return JSONUtil.toJSONString((Object)obj);
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String prettyJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(mapper.readValue(json, Object.class));
    }
}

