/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.webapp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static String DEFAULT_ENCODING = "UTF-8";

    public static String read(File file) {
        return FileUtils.read(file, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file, String encoding) {
        String string;
        if (file == null) {
            throw new IllegalArgumentException("\u53c2\u6570\"file\"\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!file.exists()) {
            logger.error(String.format("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef:\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
            throw new IllegalArgumentException(String.format("\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
        }
        FileInputStream in = null;
        BufferedInputStream buffer = null;
        ByteArrayOutputStream byteOut = null;
        try {
            in = new FileInputStream(file);
            byteOut = new ByteArrayOutputStream();
            buffer = new BufferedInputStream(in);
            int length = -1;
            byte[] bytes = new byte[1024];
            while ((length = buffer.read(bytes)) != -1) {
                byteOut.write(bytes, 0, length);
            }
            string = byteOut.toString(StringUtils.isBlank((CharSequence)encoding) ? DEFAULT_ENCODING : encoding);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(String.format("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef:\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
                throw new RuntimeException(String.format("\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
                catch (IOException e2) {
                    logger.error(String.format("\u8bfb\u53d6\u6587\u4ef6\"%s\"\u9519\u8bef:%s", file.getAbsoluteFile(), e2.getLocalizedMessage()));
                    throw new RuntimeException(String.format("\u8bfb\u53d6\u6587\u4ef6\"%s\"\u9519\u8bef:%s", file.getAbsoluteFile(), e2.getLocalizedMessage()));
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                FileUtils.close(buffer);
                FileUtils.close(byteOut);
                throw throwable;
            }
        }
        FileUtils.close(in);
        FileUtils.close(buffer);
        FileUtils.close(byteOut);
        return string;
    }

    public static void write(File file, String content) {
        FileUtils.write(file, content, DEFAULT_ENCODING, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(File file, String content, String encoding, boolean append) {
        if (file == null) {
            throw new IllegalArgumentException("\u53c2\u6570\"file\"\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileOutputStream out = null;
        BufferedOutputStream buffer = null;
        try {
            out = new FileOutputStream(file, append);
            buffer = new BufferedOutputStream(out);
            buffer.write(content.getBytes(encoding));
            buffer.flush();
        }
        catch (FileNotFoundException e) {
            try {
                logger.error(String.format("\u5199\u5165\u6587\u4ef6\u9519\u8bef:\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
                throw new RuntimeException(String.format("\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
                catch (UnsupportedEncodingException e2) {
                    logger.error(String.format("\u5199\u5165\u6587\u4ef6\"%s\"\u9519\u8bef:\u4e0d\u652f\u6301\u7f16\u7801\"%s\"", file.getAbsoluteFile(), encoding));
                    throw new RuntimeException(String.format("\u6587\u4ef6\"%s\"\u4e0d\u5b58\u5728", file.getAbsoluteFile()));
                }
                catch (IOException e3) {
                    logger.error(String.format("\u5199\u5165\u6587\u4ef6\"%s\"\u9519\u8bef:%s", file.getAbsoluteFile(), e3.getLocalizedMessage()));
                    throw new RuntimeException(String.format("\u5199\u5165\u6587\u4ef6\"%s\"\u9519\u8bef:%s", file.getAbsoluteFile(), e3.getLocalizedMessage()));
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                FileUtils.close(buffer);
                throw throwable;
            }
        }
        FileUtils.close(out);
        FileUtils.close(buffer);
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.warn(String.format("\u5173\u95ed\u8d44\u6e90\u53d1\u751f\u9519\u8bef:%s", e.getLocalizedMessage()));
        }
    }
}

