/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.webapp.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEncodingFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAMETER_ENCODING = "encoding";
    private static final String PARAMETER_FORCEENCODING = "forceEncoding";
    private String encoding = "UTF-8";
    private boolean forceEncoding = true;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setForceEncoding(boolean forceEncoding) {
        this.forceEncoding = forceEncoding;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String value = filterConfig.getInitParameter(PARAMETER_ENCODING);
        this.logger.debug("\u83b7\u53d6\u7f16\u7801\u8fc7\u6ee4\u5668\u53c2\u6570-->encoding:{}", (Object)value);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.encoding = value;
        }
        try {
            value = filterConfig.getInitParameter(PARAMETER_FORCEENCODING);
            this.logger.debug("\u83b7\u53d6\u7f16\u7801\u8fc7\u6ee4\u5668\u53c2\u6570-->forceEncoding:{}", (Object)value);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.forceEncoding = Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            this.logger.warn("\u914d\u7f6e\u53c2\u6570\"forceEncoding\"\u7c7b\u578b\u9519\u8bef");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.forceEncoding || request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.encoding);
            if (this.forceEncoding) {
                response.setCharacterEncoding(this.encoding);
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

