/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.server;

import com.xdja.server.Configuration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConfiguration
implements Configuration {
    public static final int DEFAULT_PORT = 888;
    private String contextPath = "/";
    private String webXmlPath = "/WEB-INF/web.xml";
    private int port = 888;
    private String webapp = "./";
    private String war;
    private String serverXml;
    private Map<String, Object> options = new HashMap<String, Object>();

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getWebXml() {
        return this.webXmlPath;
    }

    public AbstractConfiguration setContextPath(String contextPath) {
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            this.contextPath = contextPath.startsWith("/") ? contextPath : "/" + contextPath;
        }
        return this;
    }

    public AbstractConfiguration setWebXml(String webXmlPath) {
        if (StringUtils.isNotBlank((CharSequence)webXmlPath)) {
            this.webXmlPath = webXmlPath;
        }
        return this;
    }

    public AbstractConfiguration setPort(int port) {
        if (port > 0 && port < 65535) {
            this.port = port;
        }
        return this;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public String getWebapp() {
        return this.webapp;
    }

    public AbstractConfiguration setWebapp(String webapp) {
        if (StringUtils.isNotBlank((CharSequence)webapp)) {
            this.webapp = webapp;
        }
        return this;
    }

    @Override
    public String getWar() {
        return this.war;
    }

    public AbstractConfiguration setWar(String war) {
        this.war = war;
        return this;
    }

    @Override
    public String getServerXml() {
        return this.serverXml;
    }

    public AbstractConfiguration setServerXml(String serverXml) {
        this.serverXml = serverXml;
        return this;
    }
}

