/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.server.jetty;

import com.xdja.server.AbstractConfiguration;
import com.xdja.server.IServerException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class JettyConfiguration
extends AbstractConfiguration {
    private String defaultServlet = "/";
    private ClassLoader classLoader;

    public JettyConfiguration(String webapp, String contextPath, int port) {
        this.setPort(port);
        this.setContextPath(contextPath);
        if (new File(webapp).isDirectory()) {
            this.setWebapp(webapp);
        } else {
            this.setWar(webapp);
        }
    }

    public JettyConfiguration(String webapp, int port) {
        File file = new File(webapp);
        if (!file.exists()) {
            throw IServerException.get("\u6587\u4ef6\"{0}\"\u4e0d\u5b58\u5728,\u65e0\u6cd5\u542f\u52a8Jetty", webapp);
        }
        if (file.isDirectory()) {
            this.setWebapp(webapp);
            this.setContextPath('/' + file.getName());
        } else {
            this.setWar(webapp);
            this.setContextPath('/' + file.getName().substring(0, file.getName().lastIndexOf(".")));
        }
        this.setPort(port);
    }

    public JettyConfiguration(String webapp) {
        this(webapp, 888);
    }

    public JettyConfiguration(String webapp, String contextPath) {
        this(webapp, contextPath, 888);
    }

    public JettyConfiguration setDefaultServlet(String defaultServlet) {
        if (StringUtils.isNotBlank((CharSequence)defaultServlet)) {
            this.defaultServlet = defaultServlet;
            this.getOptions().put("org.mortbay.jetty.servlet.DefaultServlet", defaultServlet);
        }
        return this;
    }

    public String getDefaultServlet() {
        return this.defaultServlet;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JettyConfiguration setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        this.getOptions().put("classLoader", classLoader);
        return this;
    }
}

