/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.server.jetty;

import com.xdja.server.Configuration;
import com.xdja.server.IServer;
import com.xdja.server.IServerException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements IServer {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Server server;
    private final Configuration configuration;

    public JettyServer(Configuration configuration) {
        this.configuration = configuration;
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(configuration.getPort());
        ContextHandler webContext = this.buildContextHandler();
        this.server = new Server();
        this.server.setConnectors(new Connector[]{connector});
        this.server.setHandler((Handler)webContext);
        this.server.setStopAtShutdown(true);
    }

    private ContextHandler buildContextHandler() {
        ClassLoader classLoader;
        WebAppContext context = new WebAppContext();
        context.setContextPath(this.configuration.getContextPath());
        if (StringUtils.isNotBlank((CharSequence)this.configuration.getServerXml())) {
            context.setDefaultsDescriptor(this.configuration.getServerXml());
        }
        this.logger.debug("Jetty\u914d\u7f6e\u6587\u4ef6:{}", (Object)context.getDefaultsDescriptor());
        String defaultServlet = (String)this.configuration.getOptions().get("org.mortbay.jetty.servlet.DefaultServlet");
        if (defaultServlet != null) {
            ServletHandler servlet = new ServletHandler();
            servlet.addServletWithMapping("org.mortbay.jetty.servlet.DefaultServlet", defaultServlet);
            context.setHandler((Handler)servlet);
            this.logger.debug("\u8bbe\u7f6eorg.mortbay.jetty.servlet.DefaultServlet:{}", (Object)defaultServlet);
        }
        if ((classLoader = (ClassLoader)this.configuration.getOptions().get("classLoader")) != null) {
            context.setClassLoader(classLoader);
            this.logger.debug("\u8bbe\u7f6eClassLoader:{}", (Object)classLoader);
        }
        if (StringUtils.isBlank((CharSequence)this.configuration.getWar())) {
            this.logger.debug("\u8bbe\u7f6e\u666e\u901a\u6587\u4ef6\u5de5\u7a0b:{}", (Object)this.configuration.getWebapp());
            ResourceCollection resource = new ResourceCollection(this.configuration.getWebapp());
            context.setBaseResource((Resource)resource);
            if (new File(this.configuration.getWebXml()).isAbsolute()) {
                context.setDescriptor(this.configuration.getWebXml());
            } else {
                context.setDescriptor(this.configuration.getWebapp() + this.configuration.getWebXml());
            }
        } else {
            this.logger.debug("\u90e8\u7f72War\u5de5\u7a0b:{}", (Object)this.configuration.getWar());
            context.setWar(this.configuration.getWar());
        }
        return context;
    }

    public static JettyServer configurate(Configuration configuration) {
        if (configuration == null) {
            throw IServerException.get("configuration\u4e0d\u80fd\u4e3anull");
        }
        return new JettyServer(configuration);
    }

    @Override
    public void start() {
        try {
            this.server.start();
            this.logger.info("\u6210\u529f\u542f\u52a8Jetty\u670d\u52a1\u5668:{}", (Object)this.server);
            this.server.join();
        }
        catch (Exception e) {
            throw IServerException.get("\u542f\u52a8Jetty\u670d\u52a1\u5668\u9519\u8bef{0}", e, e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
            this.server.destroy();
        }
        catch (Exception e) {
            throw IServerException.get("\u505c\u6b62Jetty\u670d\u52a1\u5668\u9519\u8bef{0}", e, e.getMessage());
        }
    }
}

