/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.kdc.service.impl;

import com.xdja.cssp.acs.ICertService;
import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2CipherImpl;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.safecenter.kdc.service.IKdcService;
import com.xdja.safecenter.kdc.service.constants.ALG_TYPE;
import com.xdja.safecenter.kdc.service.constants.KEY_TYPE;
import com.xdja.safecenter.kdc.service.util.CertUtil;
import com.xdja.safecenter.kdc.service.util.Sm4;
import com.xdja.safecenter.oauth.service.IAuthService;
import com.xdja.safecenter.oauth.service.pojo.AppInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KdcServiceImpl
implements IKdcService {
    Logger logger = LoggerFactory.getLogger(KdcServiceImpl.class);
    private IAuthService authService = (IAuthService)DefaultServiceRefer.getServiceRefer(IAuthService.class);
    private ICertService certService = (ICertService)DefaultServiceRefer.getServiceRefer(ICertService.class);

    public boolean verifySign(String appId, String sourceData, String signData) {
        return this.authService.verifySign(appId, sourceData, signData);
    }

    public int verifyPackage(String appId, String pkgName, String pkgSign) {
        Map map = this.authService.getAppInfoBatch(new String[]{appId});
        AppInfo info = (AppInfo)map.get(appId);
        if (null == info) {
            return -2;
        }
        if (!pkgName.equals(info.getPkgName()) || !pkgSign.equals(info.getPkgSign())) {
            return -1;
        }
        return 0;
    }

    public Map<String, byte[]> generateKey(int keyType, int length, Map<String, String> param) {
        byte[] key = this.createKey(length);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        if (keyType == KEY_TYPE.uKey.value) {
            ArrayList<String> sns = new ArrayList<String>();
            sns.add(param.get("sn"));
            List certs = this.certService.queryCertBySnList(sns, ALG_TYPE.sm2.value);
            if (null == certs || certs.isEmpty()) {
                return null;
            }
            String cert = ((Cert)certs.get(0)).getCert();
            X509Certificate x509Certificate = CertUtil.getCertFromStr((String)cert);
            PublicKey publicKey = x509Certificate.getPublicKey();
            byte[] encryptKey = Base64.encode((byte[])this.encryptWithSM2(new String(Base64.encode((byte[])publicKey.getEncoded())), key));
            byte[] hash = this.hashBySM3(key);
            map.put("key", encryptKey);
            map.put("hash", hash);
            map.put("plainKey", Base64.encode((byte[])key));
            return map;
        }
        if (keyType == KEY_TYPE.sKey.value) {
            byte[] userKey = Base64.decode((byte[])param.get("userKey").getBytes());
            byte[] encryptKey = Sm4.sm4_encrypt_ecb((byte[])userKey, (byte[])key);
            byte[] hash = this.hashBySM3(key);
            map.put("key", encryptKey);
            map.put("hash", hash);
            return map;
        }
        return null;
    }

    public String decryptUserCode(String sn, byte[] key, byte[] data) {
        byte[] decryptKey = Base64.decode((byte[])key);
        byte[] plainByte = this.decrypt(ALG_TYPE.sm4.value, decryptKey, data);
        return new String(plainByte);
    }

    public byte[] encrypt(int algType, byte[] key, byte[] data) {
        if (algType == ALG_TYPE.sm4.value) {
            return Sm4.sm4_encrypt_ecb((byte[])key, (byte[])data);
        }
        if (algType == ALG_TYPE.sm2.value) {
            return this.encryptWithSM2(new String(key), data);
        }
        return new byte[0];
    }

    public byte[] decrypt(int algType, byte[] key, byte[] data) {
        if (algType == ALG_TYPE.sm4.value) {
            return Sm4.sm4_decrypt_ecb((byte[])key, (byte[])data);
        }
        if (algType == ALG_TYPE.sm2.value) {
            return this.decryptWithSM2(new String(key), data);
        }
        return new byte[0];
    }

    private byte[] decryptUserKey(String sn, byte[] userKey) {
        byte[] decodeKey = Base64.decode((byte[])userKey);
        ArrayList<String> sns = new ArrayList<String>();
        sns.add(sn);
        List certs = this.certService.queryCertBySnList(sns, ALG_TYPE.sm2.value);
        if (null == certs || certs.isEmpty()) {
            return null;
        }
        String cert = ((Cert)certs.get(0)).getCert();
        X509Certificate x509Certificate = CertUtil.getCertFromStr((String)cert);
        PublicKey publicKey = x509Certificate.getPublicKey();
        byte[] decryptKey = this.decryptWithSM2(new String(Base64.encode((byte[])publicKey.getEncoded())), decodeKey);
        return decryptKey;
    }

    private byte[] encryptWithSM2(String key, byte[] data) {
        SM2CipherImpl cipher = new SM2CipherImpl();
        return cipher.encrypt(key, data);
    }

    private byte[] decryptWithSM2(String key, byte[] data) {
        SM2CipherImpl cipher = new SM2CipherImpl();
        return cipher.decrypt(key, data);
    }

    private byte[] createKey(int length) {
        byte[] randomByte = new byte[length];
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(randomByte);
            return randomByte;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private byte[] hashBySHA1(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] sh1Byte = md.digest(data);
        return sh1Byte;
    }

    private byte[] hashBySM3(byte[] data) {
        SM3Digest digest = new SM3Digest();
        digest.update(data);
        byte[] hashData = digest.doFinal();
        return Base64.encode((byte[])hashData);
    }
}

