/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.bean.BackupData;
import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.model.TBackupCard;
import com.xdja.safecenter.secret.provider.backup.bean.BackupCardStatus;
import com.xdja.safecenter.secret.provider.backup.bean.BackupType;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BackupCardDao
extends BaseDao<TBackupCard> {
    public List<String> querySnList(String chipSn, int status) {
        String sql = "SELECT c_sn FROM t_backup_card WHERE c_chip_sn = :chipSn AND n_status = :status";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("chipSn", (Object)chipSn);
        params.addValue("status", (Object)status);
        return this.queryColumnForList(sql, (SqlParameterSource)params, "c_sn");
    }

    public TBackupCard getBackupCard(String bSn) {
        return this.getBackupCard(bSn, BackupType.CARD.value);
    }

    public TBackupCard getBackupCard(String bSn, int type) {
        return (TBackupCard)this.fetch((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)bSn).and("n_type", "=", (Object)type));
    }

    public List<String> queryDeviceAppIds(String chipSn) {
        String sql = "SELECT c_app_id FROM t_device WHERE c_sn = :chipSn GROUP BY c_app_id";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("chipSn", (Object)chipSn);
        return this.queryColumnForList(sql, (SqlParameterSource)params, "c_app_id");
    }

    public List<String> queryExistBackupKey(List<String> bKeySnList) {
        String sql = "SELECT c_sn FROM t_backup_card WHERE c_sn IN (:bKeySnList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("bKeySnList", bKeySnList);
        return this.queryColumnForList(sql, (SqlParameterSource)params, "c_sn");
    }

    public void saveBackupCardBatch(List<BackupData> datas) {
        String cardSql = "INSERT INTO t_backup_card(n_id,c_sn,c_chip_sn,n_type,n_status,n_time) VALUES(:id,:sn,:chipSn,:type,:status,:time)";
        String dataSql = "INSERT INTO t_backup_data(n_id,c_data) VALUES(:id,:data)";
        long nowTime = System.currentTimeMillis();
        MapSqlParameterSource[] cardParams = new MapSqlParameterSource[datas.size()];
        MapSqlParameterSource[] dataParams = new MapSqlParameterSource[datas.size()];
        MapSqlParameterSource cardItem = null;
        MapSqlParameterSource dataItem = null;
        BackupData data = null;
        for (int i = 0; i < datas.size(); ++i) {
            data = datas.get(i);
            long id = RedisUtil.incr((String)"back");
            cardItem = new MapSqlParameterSource();
            cardItem.addValue("id", (Object)id);
            cardItem.addValue("sn", (Object)data.getbKeySn().toLowerCase());
            cardItem.addValue("chipSn", (Object)data.getSn().toLowerCase());
            cardItem.addValue("type", (Object)BackupType.KEY.value);
            cardItem.addValue("status", (Object)BackupCardStatus.USED.value);
            cardItem.addValue("time", (Object)nowTime);
            cardParams[i] = cardItem;
            dataItem = new MapSqlParameterSource();
            dataItem.addValue("id", (Object)id);
            dataItem.addValue("data", (Object)data.getbKek().toString());
            dataParams[i] = dataItem;
        }
        this.batch(cardSql, (SqlParameterSource[])cardParams);
        this.batch(dataSql, (SqlParameterSource[])dataParams);
    }
}

