/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TDevice;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CellgroupDao
extends BaseDao<TCellGroup> {
    private static final String APPID = "appid";
    private static final String CHIPID = "chipid";
    private static final String ENTITY_ID = "entityID";
    private static final String SELECT_CELLGROUP_ID = "SELECT n_cellgroup_id FROM t_sync_pair WHERE c_chip_id=:chipid AND c_app_id=:appid";
    private static final String SELECT_APP_ID = "SELECT cg.c_app_id appID FROM t_cellgroup cg WHERE cg.c_entity_id = :entityID";

    public Long getCellGroupIDByChipIDAndAppID(String appID, String chipID) throws EmptyResultDataAccessException {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(APPID, (Object)appID);
        params.addValue(CHIPID, (Object)chipID);
        return this.queryForLong(SELECT_CELLGROUP_ID, (SqlParameterSource)params);
    }

    public boolean existEntity(String appID, String entityId) {
        return this.count((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_entity_id", "=", (Object)entityId)) > 0;
    }

    public Map<String, Long> queryCgIDsByEntityIds(String appID, List<String> entityIDs) {
        final HashMap<String, Long> result = new HashMap<String, Long>();
        String sql = "SELECT c_entity_id, n_id FROM t_cellgroup WHERE c_app_id = :appID AND c_entity_id IN(:ids)";
        if (entityIDs != null && !entityIDs.isEmpty()) {
            this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("appID", (Object)appID).addValue("ids", entityIDs), (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    result.put(rs.getString("c_entity_id"), rs.getLong("n_id"));
                    return null;
                }
            });
        }
        return result;
    }

    public List<String> getCellGroupDatasByEntityIDs(String appID, String ... entityIDs) {
        String sql = "SELECT cgd.c_data FROM t_cellgroup cg INNER JOIN t_cellgroup_data cgd ON cg.n_cellgroup_data_id = cgd.n_id AND cg.c_app_id =:appID AND cg.c_entity_id IN(:ids) ";
        return this.queryColumnForList(sql, (SqlParameterSource)new MapSqlParameterSource("appID", (Object)appID).addValue("ids", Arrays.asList(entityIDs)), "c_data");
    }

    public List<String> queryEntityIDs(String appID, String sn) {
        String sql = " SELECT cg.c_entity_id FROM t_cellgroup cg INNER JOIN t_sync_pair pair  ON cg.n_id = pair.n_cellgroup_id WHERE pair.c_sn=:sn AND pair.c_app_id=:appid";
        final ArrayList<String> ids = new ArrayList<String>();
        this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("sn", (Object)sn).addValue(APPID, (Object)appID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ids.add(rs.getString("c_entity_id"));
                return null;
            }
        });
        return ids;
    }

    public Map<String, Long> queryCgIDsEntityIds(String appID, List<String> entityIDs) {
        final HashMap<String, Long> result = new HashMap<String, Long>();
        String sql = "SELECT c_entity_id, n_id FROM t_cellgroup WHERE c_app_id = :appID AND c_entity_id IN(:ids)";
        this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("appID", (Object)appID).addValue("ids", entityIDs), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getString("c_entity_id"), rs.getLong("n_id"));
                return null;
            }
        });
        return result;
    }

    public String queryAppIDByEntityID(String entityID) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTITY_ID, (Object)entityID);
        return this.queryForString(SELECT_APP_ID, (SqlParameterSource)params);
    }

    public Map<TDevice, Map<TCellGroup, String>> queryCellGroupAndDeviceBySn(String sn) {
        final HashMap<TDevice, Map<TCellGroup, String>> result = new HashMap<TDevice, Map<TCellGroup, String>>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT dev.n_id dId, dev.c_sn sn, dev.n_cellgroup_id cgId, dev.c_chip_id chipId, dev.n_add_time addTime, dev.n_add_type addType,");
        sql.append(" dev.c_confirm_dev confirmDev, dev.n_start start, dev.n_end end, dev.n_start_time startTime, dev.n_end_time endTime, dev.c_entity_id entityId, dev.c_app_id appId,");
        sql.append(" cel.n_id cId, cel.n_version ver, cel.n_wrapkey_version wVer, cel.n_wrapkey_id wId, cel.n_cellgroup_data_id cdId, celd.c_data data");
        sql.append(" FROM t_device dev");
        sql.append(" JOIN t_cellgroup cel ON dev.n_cellgroup_id = cel.n_id");
        sql.append(" JOIN t_cellgroup_data celd ON cel.n_id = celd.n_id");
        sql.append(" WHERE dev.c_sn = :sn");
        MapSqlParameterSource params = new MapSqlParameterSource("sn", (Object)sn);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Map<TDevice, Map<TCellGroup, String>>>(){

            public Map<TDevice, Map<TCellGroup, String>> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<TCellGroup, String> item = null;
                TDevice device = null;
                TCellGroup cellGroup = null;
                rs.beforeFirst();
                while (rs.next()) {
                    device = new TDevice();
                    device.setId(rs.getLong("dId"));
                    device.setSn(rs.getString("sn"));
                    device.setCellGroupID(rs.getLong("cgId"));
                    device.setChipID(rs.getString("chipId"));
                    device.setAddTime(rs.getLong("addTime"));
                    device.setAddType(rs.getInt("addType"));
                    device.setConfirmDev(rs.getString("confirmDev"));
                    device.setStart(rs.getLong("start"));
                    device.setEnd(rs.getLong("end"));
                    device.setStartTime(rs.getLong("startTime"));
                    device.setEndTime(rs.getLong("endTime"));
                    device.setEntityID(rs.getString("entityId"));
                    device.setAppID(rs.getString("appId"));
                    cellGroup = new TCellGroup();
                    cellGroup.setId(rs.getLong("cId"));
                    cellGroup.setAppID(rs.getString("appId"));
                    cellGroup.setVersion(rs.getLong("ver"));
                    cellGroup.setWrapKeyVersion(rs.getLong("wVer"));
                    cellGroup.setWrapKeyID(rs.getLong("wId"));
                    cellGroup.setCellGroupDataID(rs.getLong("cdId"));
                    cellGroup.setEntityID(rs.getString("entityId"));
                    item = new HashMap<TCellGroup, String>();
                    item.put(cellGroup, rs.getString("data"));
                    result.put(device, item);
                }
                return null;
            }
        });
        return result;
    }

    public List<String> queryAllAppId() {
        String sql = " select distinct c_app_id from t_cellgroup";
        final ArrayList<String> list = new ArrayList<String>();
        super.queryForList(sql, null, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                list.add(rs.getString("c_app_id"));
                return null;
            }
        });
        return list;
    }

    public List<Long> queryIdsByAppId(String appId) {
        String sql = "select n_id from t_cellgroup where c_app_id=:appid";
        return super.queryColumnLongForList(sql, (SqlParameterSource)new MapSqlParameterSource(APPID, (Object)appId), "n_id");
    }
}

