/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.model.TDevice;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class DeviceDao
extends BaseDao<TDevice> {
    public TDevice findByEntityIdAndSN(String entityID, String sn, String appID) {
        return (TDevice)this.fetch((Condition)Cnd.where((String)"c_entity_id", (String)"=", (Object)entityID).and("c_app_id", "=", (Object)appID).and("c_sn", "=", (Object)sn));
    }

    public List<TDevice> getDevices(String entityId, String appId) {
        return this.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appId).and("c_entity_id", "=", (Object)entityId));
    }

    public List<TDevice> getDevicesBySnList(List<String> snList, String appID) {
        return this.query((Condition)Cnd.where((String)"c_sn", (String)"in", snList).and("c_app_id", "=", (Object)appID));
    }

    public List<TDevice> getDevicesByEntityList(List<String> entityIDs, String appID) {
        return this.query((Condition)Cnd.where((String)"c_entity_id", (String)"in", entityIDs).and("c_app_id", "=", (Object)appID));
    }

    public boolean existDevice(String appID, String sn, String entityID) {
        return this.count((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_sn", "=", (Object)sn).and("c_entity_id", "=", (Object)entityID)) > 0;
    }

    public List<String> getDeviceSNByCgID(Long cellGroupId) {
        String selectSnSql = "SELECT c_sn FROM t_device WHERE n_cellgroup_id = :cid";
        return this.queryColumnForList(selectSnSql, (SqlParameterSource)new MapSqlParameterSource("cid", (Object)cellGroupId), "c_sn");
    }

    public boolean checkDeviceExist(String sn) {
        return this.count((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn)) > 0;
    }

    public void updateDeviceStatus(String sn, int status) {
        String sql = "UPDATE t_device SET n_status = :status WHERE c_sn = :sn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("status", (Object)status);
        params.addValue("sn", (Object)sn);
        this.update(sql, (SqlParameterSource)params);
    }

    public boolean checkDeviceStatus(String sn) {
        return this.count((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("n_status", "=", (Object)2)) > 0;
    }
}

