/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.model.TMission;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MissionDao
extends BaseDao<TMission> {
    private static int DEFAULT_PAGE_SIZE = 1;

    public List<TMission> getMissionsBySns(String sn, String appID) {
        if (StringUtils.isEmpty((Object)appID)) {
            return this.query((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).limit(DEFAULT_PAGE_SIZE).asc("n_create_time"));
        }
        return this.query((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("c_app_id", "=", (Object)appID).limit(DEFAULT_PAGE_SIZE).asc("n_create_time"));
    }

    public void deleteByMids(List<String> mids) {
        String queryMissionsByMids = "SELECT n_id FROM t_mission WHERE n_mid IN (:mids)";
        MapSqlParameterSource parameter = new MapSqlParameterSource("mids", mids);
        List missions = this.queryColumnLongForList(queryMissionsByMids, (SqlParameterSource)parameter, "n_id");
        if (missions != null && missions.size() > 0) {
            String delMissions = "DELETE FROM t_mission WHERE n_id IN (:mids)";
            this.deleteBySql(delMissions, (SqlParameterSource)new MapSqlParameterSource("mids", (Object)missions));
        }
        if (mids != null && !mids.isEmpty()) {
            String delMissionDatas = "DELETE FROM t_mission_data WHERE n_id IN (:ids)";
            this.deleteBySql(delMissionDatas, (SqlParameterSource)new MapSqlParameterSource("ids", mids));
            for (String mid : mids) {
                RedisUtil.del((String[])new String[]{"mdata_" + mid});
            }
        }
    }

    public List<TMission> getMissionsByGetEntity(String sn, String appID, String entityID, boolean wrapPgkFlag) {
        SqlExpressionGroup createWrapKeyEx = Cnd.exps((String)"c_sn", (String)"=", (Object)sn).and("c_app_id", "=", (Object)appID).and("c_entity_id", "=", (Object)entityID).and((SqlExpression)Cnd.exps((String)"n_type", (String)"=", (Object)0).or("n_type", "=", (Object)4).or("n_type", "=", (Object)6));
        SqlExpressionGroup wrapPgkEx = Cnd.exps((String)"c_sn", (String)"=", (Object)sn).and("c_app_id", "=", (Object)appID).and("c_entity_id", "=", (Object)entityID).and((SqlExpression)Cnd.exps((String)"n_type", (String)"=", (Object)5).or("n_type", "=", (Object)4).or("n_type", "=", (Object)7).or("n_type", "=", (Object)6));
        return wrapPgkFlag ? this.query((Condition)Cnd.where((SqlExpression)createWrapKeyEx).or((SqlExpression)wrapPgkEx).limit(DEFAULT_PAGE_SIZE).asc("n_create_time")) : this.query((Condition)Cnd.where((SqlExpression)createWrapKeyEx).limit(DEFAULT_PAGE_SIZE).asc("n_create_time"));
    }

    public List<TMission> getMissionsByEntityAndType(String sn, String appID, String entityId, String type) {
        return this.query((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("c_app_id", "=", (Object)appID).and("c_entity_id", "=", (Object)entityId).and("n_type", "=", (Object)type).limit(DEFAULT_PAGE_SIZE).asc("n_create_time"));
    }

    public void deleteMissions(List<Long> Ids) {
        String deleteMissionSql = "DELETE FROM t_mission WHERE n_id in (:mid)";
        this.deleteBySql(deleteMissionSql, (SqlParameterSource)new MapSqlParameterSource("mid", Ids));
    }

    public List<TMission> getMissionsBySn(String sn) {
        return this.query((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).asc("n_create_time"));
    }
}

