/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TPartyGroup;
import com.xdja.safecenter.secret.model.TPartyGroupData;
import com.xdja.safecenter.secret.model.TPgkData;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PartyGroupDao
extends BaseDao {
    private static final int ORGIN_INDEX = 0;
    private static final String N_ID = "n_id";
    private static final String IDS = "ids";
    private static final String N_VERSION = "n_version";
    private static final String N_PGK_VERSION = "n_pgk_version";
    private static final String PG_ID = "pgId";
    private static final String VERSION = "version";
    private static final String PG_DATA_ID = "pgDataID";
    private static final String N_ID1 = "n_id";
    private static final String ID = "id";
    private static final String PGK_DATA_ID = "pgkDataID";
    private static final String PGK_VERSION = "pgkVersion";
    private static final String UPDATE_PARTYGROUP = "UPDATE t_partygroup SET n_partygroup_data_id=:pgDataID, n_version=:version WHERE c_partygroup_id=:pgId";
    private static final String GET_LATEST_VERSION = "SELECT n_version, n_pgk_version FROM t_partygroup WHERE c_partygroup_id=:pgId";
    private static final String GET_PGK_VERSION = "SELECT n_pgk_version FROM t_wrap_pgk WHERE c_partygroup_id=:pgId";
    private static final String DELETE_PGK_DATA = "DELETE FROM t_pgk_data WHERE n_id IN(:ids)";
    private static final String SELECT_PGK_DATA = "SELECT n_id FROM t_pgk_data WHERE c_partygroup_id = :pgId";
    private static final String DELETE_PARTYGROUP_DATA = "DELETE FROM t_partygroup_data WHERE n_id IN(:ids)";
    private static final String SELECT_PARTYGROUP_DATA = "SELECT n_id FROM t_partygroup_data WHERE c_partygroup_id = :pgId";
    private static final String DELETE_PARTYGROUP = "DELETE FROM t_partygroup WHERE n_id = :id";
    private static final String SELECT_PARTYGROUP = "SELECT n_id FROM t_partygroup WHERE c_partygroup_id = :pgId";
    private static final String UPDATE_PARTYGROUP_AND_DATA = "UPDATE t_partygroup SET n_partygroup_data_id=:pgDataID, n_version=:version, n_pgk_data_id=:pgkDataID, n_pgk_version=:pgkVersion WHERE c_partygroup_id=:pgId";
    private static final String UPDATE_PARTYGROUP_KEY_VERSION = "UPDATE t_partygroup SET n_pgk_data_id=:pgkDataID, n_pgk_version=:pgkVersion WHERE c_partygroup_id=:pgId";

    public Map<Long, Long> getLaestVerAndPgkVer(String partyGroupID) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        List list = this.daoTemplate.queryForList(GET_LATEST_VERSION, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID));
        if (list != null && !list.isEmpty()) {
            result.put((Long)((Map)list.get(0)).get(N_PGK_VERSION), (Long)((Map)list.get(0)).get(N_VERSION));
        }
        return result;
    }

    public void savePartyGroup(TPartyGroup partyGroup, String partyGroupSData, PartyGroupKey partyGroupKey, String partyGroupKeySData) {
        TPgkData pgkData = this.save(partyGroup.getPartyGroupID(), Long.valueOf(partyGroupKey.getPgkVer()), partyGroupKeySData);
        long pgDataID = this.save(partyGroup.getPartyGroupID(), partyGroupSData);
        partyGroup.setPartyGroupDataID(pgDataID);
        partyGroup.setPgkDataID(pgkData.getId());
        partyGroup.setPgkVersion(pgkData.getPgkVersion());
        this.daoTemplate.insert((Object)partyGroup);
    }

    public void updatePartyGroup(TPartyGroup partyGroup, String partyGroupSData) {
        long pgDataID = this.save(partyGroup.getPartyGroupID(), partyGroupSData);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroup.getPartyGroupID());
        params.addValue(VERSION, (Object)partyGroup.getVersion());
        params.addValue(PG_DATA_ID, (Object)pgDataID);
        this.daoTemplate.update(UPDATE_PARTYGROUP, (SqlParameterSource)params);
    }

    public void updatePartyGroup(TPartyGroup partyGroup, String partyGroupSData, PartyGroupKey partyGroupKey, String partyGroupKeySData) {
        TPgkData pgkData = this.save(partyGroup.getPartyGroupID(), Long.valueOf(partyGroupKey.getPgkVer()), partyGroupKeySData);
        long pgDataID = this.save(partyGroup.getPartyGroupID(), partyGroupSData);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroup.getPartyGroupID());
        params.addValue(VERSION, (Object)partyGroup.getVersion());
        params.addValue(PG_DATA_ID, (Object)pgDataID);
        params.addValue(PGK_DATA_ID, (Object)pgkData.getId());
        params.addValue(PGK_VERSION, (Object)pgkData.getPgkVersion());
        this.daoTemplate.update(UPDATE_PARTYGROUP_AND_DATA, (SqlParameterSource)params);
    }

    public void updatePartyGroup(PartyGroupKey partyGroupKey, String partyGroupKeySData) {
        TPgkData pgkData = this.save(partyGroupKey.getPgID(), Long.valueOf(partyGroupKey.getPgkVer()), partyGroupKeySData);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupKey.getPgID());
        params.addValue(PGK_DATA_ID, (Object)pgkData.getId());
        params.addValue(PGK_VERSION, (Object)pgkData.getPgkVersion());
        this.daoTemplate.update(UPDATE_PARTYGROUP_KEY_VERSION, (SqlParameterSource)params);
    }

    private long save(String partyGroupID, String partyGroupSData) {
        TPartyGroupData pgData = new TPartyGroupData();
        pgData.setId(RedisUtil.incr((String)"pgdk"));
        pgData.setPartyGroupID(partyGroupID);
        pgData.setData(partyGroupSData);
        this.daoTemplate.insert((Object)pgData);
        return pgData.getId();
    }

    private TPgkData save(String partyGroupID, long pgkVersion, String partyGroupKeySData) {
        TPgkData pgkData = new TPgkData();
        pgkData.setId(RedisUtil.incr((String)"pdk"));
        pgkData.setPartyGroupID(partyGroupID);
        pgkData.setPgkVersion(pgkVersion);
        pgkData.setData(partyGroupKeySData);
        this.daoTemplate.insert((Object)pgkData);
        return pgkData;
    }

    public void clear(String partyGroupID) {
        this.clearPartyGroup(partyGroupID);
        this.clearPartyGroupData(partyGroupID);
        this.clearPGKData(partyGroupID);
    }

    private void clearPartyGroup(String partyGroupID) {
        Long id = this.queryForLong(SELECT_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID));
        if (id != null) {
            this.deleteBySql(DELETE_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(ID, (Object)id));
        }
    }

    private void clearPartyGroupData(String partyGroupID) {
        List ids = this.queryColumnLongForList(SELECT_PARTYGROUP_DATA, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), "n_id");
        if (ids != null && !ids.isEmpty()) {
            this.deleteBySql(DELETE_PARTYGROUP_DATA, (SqlParameterSource)new MapSqlParameterSource(IDS, (Object)ids));
        }
    }

    private void clearPGKData(String partyGroupID) {
        List ids = this.queryColumnLongForList(SELECT_PGK_DATA, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), "n_id");
        if (ids != null && !ids.isEmpty()) {
            String sql_del_partyGroup = DELETE_PGK_DATA;
            this.deleteBySql(sql_del_partyGroup, (SqlParameterSource)new MapSqlParameterSource(IDS, (Object)ids));
        }
    }

    public List<Long> getAllVerAndPgkVer(String partyGroupID) throws EmptyResultDataAccessException {
        return this.queryColumnLongForList(GET_PGK_VERSION, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), N_PGK_VERSION);
    }

    public boolean existPartyGroup(String partyGroupID) {
        List ids = this.queryColumnLongForList(SELECT_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), "n_id");
        return ids != null && !ids.isEmpty();
    }

    public TPartyGroup queryByPartyGroupId(String partyGroupId) {
        return (TPartyGroup)this.daoTemplate.fetch(TPartyGroup.class, (Condition)Cnd.where((String)"c_partygroup_id", (String)"=", (Object)partyGroupId));
    }

    public Long getPgDataId(String partyGroupId) {
        Long pgDataID = null;
        MapSqlParameterSource params = new MapSqlParameterSource("pgID", (Object)partyGroupId);
        try {
            pgDataID = this.daoTemplate.queryForLong("SELECT n_partygroup_data_id FROM t_partygroup WHERE c_partygroup_id=:pgID", (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        if (pgDataID == null) {
            return null;
        }
        return pgDataID;
    }

    public String queryPgkCountsByPgIds(List<String> pgIds) {
        String sql = "select count(1) from t_pgk_data where c_partygroup_id in(:pgIds)";
        MapSqlParameterSource params = new MapSqlParameterSource("pgIds", pgIds);
        return super.queryForString(sql, (SqlParameterSource)params);
    }
}

