/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TRegion;
import com.xdja.safecenter.secret.provider.region.bean.RegionBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RegionDao
extends BaseDao {
    public TRegion getRegion(String pkName) {
        return (TRegion)this.daoTemplate.fetch(TRegion.class, (Condition)Cnd.where((String)"c_package_name", (String)"=", (Object)pkName));
    }

    public List<TRegion> queryRegions(List<Long> ids) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_name, c_app_name, c_package_name, c_interface_id, c_desc, n_time");
        sql.append(" FROM t_region WHERE n_id IN (:ids)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("ids", ids);
        return this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<TRegion>(){

            public TRegion mapRow(ResultSet rs, int rowNum) throws SQLException {
                TRegion bean = new TRegion();
                bean.setId(rs.getLong("n_id"));
                bean.setName(rs.getString("c_name"));
                bean.setAppName(rs.getString("c_app_name"));
                bean.setPkName(rs.getString("c_package_name"));
                bean.setInterfaceId(rs.getString("c_interface_id"));
                bean.setDesc(rs.getString("c_desc"));
                bean.setTime(rs.getLong("n_time"));
                return bean;
            }
        });
    }

    public Map<Long, TRegion> queryRegions(Set<Long> ids) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_name, c_app_name, c_package_name, c_interface_id, c_desc, n_time");
        sql.append(" FROM t_region WHERE n_id IN (:ids)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("ids", ids);
        final HashMap<Long, TRegion> result = new HashMap<Long, TRegion>();
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<TRegion>(){

            public TRegion mapRow(ResultSet rs, int rowNum) throws SQLException {
                TRegion bean = null;
                do {
                    bean = new TRegion();
                    bean.setId(rs.getLong("n_id"));
                    bean.setName(rs.getString("c_name"));
                    bean.setAppName(rs.getString("c_app_name"));
                    bean.setPkName(rs.getString("c_package_name"));
                    bean.setInterfaceId(rs.getString("c_interface_id"));
                    bean.setDesc(rs.getString("c_desc"));
                    bean.setTime(rs.getLong("n_time"));
                    result.put(bean.getId(), bean);
                } while (rs.next());
                return bean;
            }
        });
        return result;
    }

    public TRegion saveRegion(RegionBean region) {
        TRegion bean = new TRegion();
        bean.setId(RedisUtil.incr((String)"regk"));
        bean.setName(region.getName());
        bean.setAppName(region.getAppName());
        bean.setPkName(region.getPkName());
        bean.setInterfaceId(region.getInterfaceId());
        bean.setDesc(region.getDesc());
        bean.setTime(System.currentTimeMillis());
        return this.insert(bean);
    }

    public TRegion updateRegion(RegionBean region) {
        TRegion bean = new TRegion();
        bean.setId(region.getId());
        bean.setName(region.getName());
        bean.setAppName(region.getAppName());
        bean.setPkName(region.getPkName());
        bean.setInterfaceId(region.getInterfaceId());
        bean.setDesc(region.getDesc());
        bean.setTime(System.currentTimeMillis());
        this.update(bean);
        return bean;
    }
}

