/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TRegionDevice;
import java.util.List;
import java.util.Set;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RegionDeviceDao
extends BaseDao {
    public boolean isRegionDeviceExist(String sn, long regionId) {
        return this.daoTemplate.count(TRegionDevice.class, (Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("n_region_id", "=", (Object)regionId)) > 0;
    }

    public TRegionDevice saveRegionDevice(String sn, long regionId) {
        TRegionDevice bean = new TRegionDevice();
        bean.setId(RedisUtil.incr((String)"regdk"));
        bean.setSn(sn);
        bean.setRegionId(regionId);
        return this.insert(bean);
    }

    public void saveRegionDeviceBatch(String sn, Set<Long> regionIds) {
        String sql = "INSERT INTO t_region_device(n_id, c_sn, n_region_id) VALUES(:id, :sn, :regionId)";
        MapSqlParameterSource[] params = new MapSqlParameterSource[regionIds.size()];
        MapSqlParameterSource data = null;
        int count = 0;
        for (Long regionId : regionIds) {
            data = new MapSqlParameterSource();
            data.addValue("id", (Object)RedisUtil.incr((String)"regdk"));
            data.addValue("sn", (Object)sn);
            data.addValue("regionId", (Object)regionId);
            params[count++] = data;
        }
        this.batch(sql, (SqlParameterSource[])params);
    }

    public List<Long> queryRegionIdBySn(String sn) {
        String sql = "SELECT n_region_id FROM t_region_device WHERE c_sn = :sn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("sn", (Object)sn);
        return this.queryColumnLongForList(sql, (SqlParameterSource)params, "n_region_id");
    }
}

