/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TRegionRestoreRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RegionRestoreRecordDao
extends BaseDao {
    public void saveRestoreRecord(TRegionRestoreRecord record, List<Long> regionIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_region_restore_record(n_id, c_back_no, c_restore_chip_no, c_restore_sn,");
        sql.append(" c_back_chip_no, c_back_sn, n_region_id, n_status, n_time) VALUES(:id, :backNo, :restoreChipNo,");
        sql.append(" :restoreSn, :backChipNo, :backSn, :regionId, :status, :time)");
        MapSqlParameterSource[] params = this.buildParams(record, regionIds);
        this.batch(sql.toString(), (SqlParameterSource[])params);
    }

    public List<Long> queryStaryRestoreRegionIds(String backNo, String sn) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_region_id FROM t_region_restore_record");
        sql.append(" WHERE c_back_no = :backNo AND c_restore_sn = :restoreSn AND n_status = :status");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("backNo", (Object)backNo);
        params.addValue("restoreSn", (Object)sn);
        params.addValue("status", (Object)1);
        return this.queryColumnLongForList(sql.toString(), (SqlParameterSource)params, "n_region_id");
    }

    public Map<String, Map<Long, Integer>> queryRecordRegionIds(String backNo, String rSn) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c_back_sn, n_region_id, n_status FROM t_region_restore_record");
        sql.append(" WHERE c_back_no = :backNo AND c_restore_sn = :restoreSn");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("backNo", (Object)backNo);
        params.addValue("restoreSn", (Object)rSn);
        final HashMap<String, Map<Long, Integer>> result = new HashMap<String, Map<Long, Integer>>();
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<Long, Integer> item = null;
                do {
                    String backSn = rs.getString("c_back_sn");
                    long regionid = rs.getLong("n_region_id");
                    item = (HashMap<Long, Integer>)result.get(backSn);
                    if (null == item) {
                        item = new HashMap<Long, Integer>();
                        result.put(backSn, item);
                    }
                    if (regionid == -1L) continue;
                    item.put(regionid, rs.getInt("n_status"));
                } while (rs.next());
                return null;
            }
        });
        return result;
    }

    public Object[] queryRestoreRecord(String sn) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_back_no, c_restore_chip_no, c_restore_sn, c_back_chip_no, c_back_sn,");
        sql.append(" n_region_id, n_status, n_time FROM t_region_restore_record");
        sql.append(" WHERE c_restore_sn = :rSn");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("rSn", (Object)sn);
        final HashMap records = new HashMap();
        final HashSet regionIds = new HashSet();
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ArrayList<TRegionRestoreRecord> recordList = null;
                TRegionRestoreRecord record = null;
                do {
                    String backNo;
                    if (null == (recordList = (ArrayList<TRegionRestoreRecord>)records.get(backNo = rs.getString("c_back_no")))) {
                        recordList = new ArrayList<TRegionRestoreRecord>();
                        records.put(backNo, recordList);
                    }
                    record = new TRegionRestoreRecord();
                    record.setId(rs.getLong("n_id"));
                    record.setBackNo(backNo);
                    record.setRestoreChipNo(rs.getString("c_restore_chip_no"));
                    record.setRestoreSn(rs.getString("c_restore_sn"));
                    record.setBackChipNo(rs.getString("c_back_chip_no"));
                    record.setBackSn(rs.getString("c_back_sn"));
                    record.setRegionId(rs.getLong("n_region_id"));
                    record.setStatus(rs.getInt("n_status"));
                    record.setTime(rs.getLong("n_time"));
                    recordList.add(record);
                    regionIds.add(record.getRegionId());
                } while (rs.next());
                return null;
            }
        });
        return new Object[]{records, regionIds};
    }

    public void updateRecordStatusBatch(Map<String, List<Long>> regionIds, String sn, int size) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_region_restore_record SET n_status = :status, n_time = :time");
        sql.append(" WHERE c_back_no = :backNo AND c_restore_sn = :restoreSn AND n_region_id = :regionId");
        MapSqlParameterSource[] params = new MapSqlParameterSource[size];
        MapSqlParameterSource data = null;
        long time = System.currentTimeMillis();
        int count = 0;
        for (Map.Entry<String, List<Long>> item : regionIds.entrySet()) {
            for (Long regionId : item.getValue()) {
                data = new MapSqlParameterSource();
                data.addValue("status", (Object)2);
                data.addValue("time", (Object)time);
                data.addValue("backNo", (Object)item.getKey());
                data.addValue("restoreSn", (Object)sn);
                data.addValue("regionId", (Object)regionId);
                params[count++] = data;
            }
        }
        this.batch(sql.toString(), (SqlParameterSource[])params);
    }

    private MapSqlParameterSource[] buildParams(TRegionRestoreRecord record, List<Long> regionIds) {
        MapSqlParameterSource[] params = null;
        if (null == regionIds || regionIds.isEmpty()) {
            params = new MapSqlParameterSource[]{this.buildData(record, -1L, 2)};
        } else {
            params = new MapSqlParameterSource[regionIds.size()];
            for (int i = 0; i < regionIds.size(); ++i) {
                params[i] = this.buildData(record, regionIds.get(i), 1);
            }
        }
        return params;
    }

    private MapSqlParameterSource buildData(TRegionRestoreRecord record, long regionId, int status) {
        MapSqlParameterSource item = new MapSqlParameterSource();
        item.addValue("id", (Object)RedisUtil.incr((String)"regrrk"));
        item.addValue("backNo", (Object)record.getBackNo());
        item.addValue("restoreChipNo", (Object)record.getRestoreChipNo());
        item.addValue("restoreSn", (Object)record.getRestoreSn());
        item.addValue("backChipNo", (Object)record.getBackChipNo());
        item.addValue("backSn", (Object)record.getBackSn());
        item.addValue("regionId", (Object)regionId);
        item.addValue("status", (Object)status);
        item.addValue("time", (Object)record.getTime());
        return item;
    }
}

