/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TSyncPgk;
import com.xdja.safecenter.secret.model.TSyncPgkData;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.SyncPGKComplex;
import com.xdja.safecenter.secret.struct.Constants;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.SyncedPgKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SyncedPgkDao
extends BaseDao {
    private static final String PG_ID = "pgId";
    private static final String CG_I_DS = "cgIDs";
    private static final String N_ID = "n_id";
    private static final String SK_ID = "skId";
    private static final String IDS = "ids";
    private static final String CG_ID = "cgID";
    private static final String VERSION = "version";
    private static final String N_SYNC_PGK_DATA_ID = "n_sync_pgk_data_id";
    private static final String SELECT_SYNC_PGK_BY_PARTYGROUP_ID = "SELECT n_id, n_sync_pgk_data_id FROM t_sync_pgk WHERE c_partygroup_id = :pgId";
    private static final String SELECT_SYNC_PGK_BY_SYNC_PAIR_ID = "SELECT n_id, n_sync_pgk_data_id FROM t_sync_pgk WHERE n_sync_pair_id = :skId";
    private static final String DELETE_SYNC_PGK_DATA = "DELETE FROM t_sync_pgk_data WHERE n_id IN (:ids)";
    private static final String DELETE__SYNC_PGK = "DELETE FROM t_sync_pgk WHERE n_id IN (:ids)";
    private static final String SELECT_SYNC_PGK_DATA_ID_BY_PARTYGROUP_ID = "SELECT n_id, n_sync_pgk_data_id FROM t_sync_pgk WHERE c_partygroup_id = :pgId AND n_cellgroup_id IN (:cgIDs)";
    private static final String SELECT_SYNC_PGK_DATA_ID_BY_PARTYGROUP_ID_AND_CELLGROUP_ID_CG_ID_AND_PGK_VERSION = "SELECT n_id, n_sync_pgk_data_id FROM t_sync_pgk WHERE c_partygroup_id = :pgId AND n_cellgroup_id =:cgID AND n_pgk_version = :version";

    public void save(long gid, SyncedPgKey syncedPgKey, String data, long cellGroupID) {
        TSyncPgkData syncPgkData = new TSyncPgkData();
        syncPgkData.setData(data);
        syncPgkData.setId(gid);
        this.daoTemplate.insert((Object)syncPgkData);
        TSyncPgk syncPgk = new TSyncPgk();
        syncPgk.setCellGroupID(cellGroupID);
        syncPgk.setPartyGroupID(syncedPgKey.getPgID());
        syncPgk.setPgkVersion(Long.parseLong(syncedPgKey.getPgkVer()));
        syncPgk.setSyncPairID(syncedPgKey.getSkID());
        syncPgk.setSyncPgkDataID(syncPgkData.getId());
        this.daoTemplate.insert((Object)syncPgk);
    }

    public void clear(String partyGroupID) {
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(SELECT_SYNC_PGK_BY_PARTYGROUP_ID, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong(SyncedPgkDao.N_SYNC_PGK_DATA_ID));
                pgkIDs.add(resultSet.getLong(SyncedPgkDao.N_ID));
                return null;
            }
        });
        this.clearPgkByIds(pgkIDs, syncDataIDs);
    }

    public void clearBySkID(String SkID) {
        String sql = SELECT_SYNC_PGK_BY_SYNC_PAIR_ID;
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource(SK_ID, (Object)SkID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong(SyncedPgkDao.N_SYNC_PGK_DATA_ID));
                pgkIDs.add(resultSet.getLong(SyncedPgkDao.N_ID));
                return null;
            }
        });
        this.clearPgkByIds(pgkIDs, syncDataIDs);
    }

    private void clearPgkByIds(List<Long> pgkIDs, List<Long> syncDataIDs) {
        if (!syncDataIDs.isEmpty()) {
            this.deleteBySql(DELETE_SYNC_PGK_DATA, (SqlParameterSource)new MapSqlParameterSource(IDS, syncDataIDs));
        }
        if (!pgkIDs.isEmpty()) {
            this.deleteBySql(DELETE__SYNC_PGK, (SqlParameterSource)new MapSqlParameterSource(IDS, pgkIDs));
        }
    }

    public void clearByCellGroupIdsAndPgId(String partyGroupId, List<Long> cellGroupIDs) {
        String sql = SELECT_SYNC_PGK_DATA_ID_BY_PARTYGROUP_ID;
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupId).addValue(CG_I_DS, cellGroupIDs), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong(SyncedPgkDao.N_SYNC_PGK_DATA_ID));
                pgkIDs.add(resultSet.getLong(SyncedPgkDao.N_ID));
                return null;
            }
        });
        this.clearPgkByIds(pgkIDs, syncDataIDs);
    }

    public void clearByCgIDAndPgkeyVerion(String partyGroupId, Long cellGroupID, Long version) {
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(SELECT_SYNC_PGK_DATA_ID_BY_PARTYGROUP_ID_AND_CELLGROUP_ID_CG_ID_AND_PGK_VERSION, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupId).addValue(CG_ID, (Object)cellGroupID).addValue(VERSION, (Object)version), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong(SyncedPgkDao.N_SYNC_PGK_DATA_ID));
                pgkIDs.add(resultSet.getLong(SyncedPgkDao.N_ID));
                return null;
            }
        });
        this.clearPgkByIds(pgkIDs, syncDataIDs);
    }

    public List<SyncPGKComplex> getUnwrapedPGK(String appID, String sn, Long cellGroupId, String partyGroupID, Long partyGroupKeyVersion) {
        final ArrayList<SyncPGKComplex> syncedPgKeyList = new ArrayList<SyncPGKComplex>();
        StringBuffer sql = new StringBuffer("SELECT pgk.c_partygroup_id AS pgID, spdata.c_data AS spdata, pdata.c_data AS pdata  FROM t_sync_pair pair, t_sync_pgk pgk, t_sync_pgk_data spdata, t_pgk_data pdata  WHERE pair.c_app_id=:appID AND pair.c_sn=:sn AND pgk.n_sync_pair_id=pair.n_id  AND pgk.n_cellgroup_id=:cgID AND pgk.c_partygroup_id=:pgID  AND pgk.n_sync_pgk_data_id=spdata.n_id AND pdata.n_pgk_version=pgk.n_pgk_version AND pdata.c_partygroup_id=pgk.c_partygroup_id");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("appID", (Object)appID);
        params.addValue("sn", (Object)sn);
        params.addValue(CG_ID, (Object)cellGroupId);
        params.addValue("pgID", (Object)partyGroupID);
        if (!Objects.equals(partyGroupKeyVersion, Constants.TYPE_NEW_WRAPPGKEY_VERSION) && !Objects.equals(partyGroupKeyVersion, Constants.TYPE_ALL_WRAPPGKEY_VERSION)) {
            sql.append(" AND pgk.n_pgk_version = :pgkVer");
            params.addValue("pgkVer", (Object)partyGroupKeyVersion);
        }
        this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                String spdata = rs.getString("spdata");
                String pdata = rs.getString("pdata");
                SyncPGKComplex syncPGKComplex = new SyncPGKComplex();
                try {
                    syncPGKComplex.setSyncedPgKey((SyncedPgKey)JsonMapper.alwaysMapper().fromJson(spdata, SyncedPgKey.class));
                }
                catch (JSONException e) {
                    throw new RuntimeException(String.format("\u8f6c\u6362\u3010%s\u3011\u4e3aSyncedPgKey\u5931\u8d25", spdata), e);
                }
                try {
                    syncPGKComplex.setPartyGroupKey((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(pdata, SourceDataStruct.class));
                }
                catch (JSONException e) {
                    throw new RuntimeException(String.format("\u8f6c\u6362\u3010%s\u3011\u4e3aPartyGroupKey\u5931\u8d25", pdata), e);
                }
                syncedPgKeyList.add(syncPGKComplex);
                return null;
            }
        });
        return syncedPgKeyList;
    }
}

