/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.DataCorruptionException;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TWrapPgk;
import com.xdja.safecenter.secret.model.TWrapPgkData;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WrapPgkDao
extends BaseDao {
    private static final String PG_ID = "pgId";
    private static final String CG_ID = "cgId";
    private static final String IDS = "ids";
    private static final String C_DATA = "c_data";
    private static final String N_ID = "n_id";
    private static final String VERSION = "version";
    private static final String N_WRAP_PGK_DATA_ID = "n_wrap_pgk_data_id";
    private static final String MAP_WRAPED_PG_KEY_ERROR = "\u89e3\u6790\u6570\u636e\u4e3aWrapedPgKey\u5931\u8d25";
    private static final String N_PGK_VERSION = "n_pgk_version";
    private static final String PGK_VER = "pgkVer";
    private static final String C_ID = "cId";
    private static final String N_WRAP_PGK_DATA_ID2 = "n_wrap_pgk_data_id";
    private static final String C_IDS = "cIDs";
    private static final String N_WRAP_PGK_DATA_ID3 = "n_wrap_pgk_data_id";
    private static final String SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID = "SELECT n_id, n_wrap_pgk_data_id FROM t_wrap_pgk WHERE c_partygroup_id = :pgId";
    private static final String SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID_AND_N_CELLGROUP_ID_IN_C_IDS = "SELECT n_id, n_wrap_pgk_data_id FROM t_wrap_pgk WHERE c_partygroup_id = :pgId AND n_cellgroup_id IN (:cIDs)";
    private static final String sql_del_t_wrap_pgk = "DELETE FROM t_wrap_pgk WHERE c_partygroup_id = :pgId and n_cellgroup_id = :cgId";
    private static final String sql_del_t_wrap_pgk_data = "DELETE FROM t_wrap_pgk_data WHERE n_id in (:ids)";
    private static final String sql_wrap_pgk_data = "SELECT pgkdata.c_data FROM t_wrap_pgk pgk, t_wrap_pgk_data pgkdata WHERE pgk.c_partygroup_id=:pgId AND pgk.n_cellgroup_id=:cgId AND pgk.n_pgk_version=:version AND pgk.n_wrap_pgk_data_id=pgkdata.n_id";
    private static final String sql_wrap_pgk_data_version = "SELECT pgk.n_pgk_version, pgkdata.c_data FROM t_wrap_pgk pgk, t_wrap_pgk_data pgkdata WHERE pgk.c_partygroup_id=:pgId AND pgk.n_cellgroup_id=:cgId AND pgk.n_wrap_pgk_data_id=pgkdata.n_id ORDER BY pgk.n_id";
    private static final String sql_wrap_pgk_version = "SELECT pgk.n_pgk_version FROM t_wrap_pgk pgk WHERE pgk.c_partygroup_id=:pgId AND pgk.n_cellgroup_id=:cgId AND pgk.n_pgk_version=:pgkVer";
    private static final String SELECT_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID_AND_N_CELLGROUP_ID_CG_ID = "SELECT n_wrap_pgk_data_id FROM t_wrap_pgk WHERE c_partygroup_id = :pgId and n_cellgroup_id = :cgId";
    private static final String SELECT_WRAP_DATA = "SELECT wrap.c_data FROM t_partygroup pg  INNER JOIN t_wrap_pgk wrapPgk ON  pg.c_partygroup_id = wrapPgk.c_partygroup_id  INNER JOIN t_wrap_pgk_data wrap ON wrapPgk.n_wrap_pgk_data_id = wrap.n_id  WHERE pg.c_partygroup_id=:pgId AND wrapPgk.n_cellgroup_id=:cgId  AND pg.n_pgk_version = wrapPgk.n_pgk_version";
    private static final String SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_N_CELLGROUP_ID_C_ID = "SELECT n_id, n_wrap_pgk_data_id FROM t_wrap_pgk WHERE n_cellgroup_id = :cId";
    private static final String N_WRAP_PGK_DATA_ID1 = "n_wrap_pgk_data_id";
    private static final String DELETE_FROM_T_WRAP_PGK_DATA_WHERE_N_ID_IN_IDS = "DELETE FROM t_wrap_pgk_data WHERE n_id IN (:ids)";
    private static final String DELETE_FROM_T_WRAP_PGK_WHERE_N_ID_IN_IDS = "DELETE FROM t_wrap_pgk WHERE n_id IN (:ids)";

    public void delete(String partyGroupID, Long cellGroupID) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue(CG_ID, (Object)cellGroupID);
        List pgkDataIDs = this.queryColumnLongForList(SELECT_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID_AND_N_CELLGROUP_ID_CG_ID, (SqlParameterSource)params, "n_wrap_pgk_data_id");
        this.deleteBySql(sql_del_t_wrap_pgk, (SqlParameterSource)params);
        if (!pgkDataIDs.isEmpty()) {
            this.deleteBySql(sql_del_t_wrap_pgk_data, (SqlParameterSource)new MapSqlParameterSource(IDS, (Object)pgkDataIDs));
        }
    }

    public void save(WrapedPgKey wrapedPgKey, String data, long cellGroupID) {
        TWrapPgkData wrapPgkData = new TWrapPgkData(RedisUtil.incr((String)"swpdk"), data);
        this.daoTemplate.insert((Object)wrapPgkData);
        TWrapPgk wrapPgk = new TWrapPgk();
        wrapPgk.setWrapKeyVersion(Long.parseLong(wrapedPgKey.getWkVer()));
        wrapPgk.setCellGroupID(cellGroupID);
        wrapPgk.setPgkVersion(Long.parseLong(wrapedPgKey.getPgkVer()));
        wrapPgk.setWrapPgkDataID(wrapPgkData.getId());
        wrapPgk.setPartyGroupID(wrapedPgKey.getPgID());
        this.daoTemplate.insert((Object)wrapPgk);
    }

    public WrapedPgKey getWrapedPGKData(String partyGroupID, Long cellGroupID, Long partyGroupKeyVersion) throws EmptyResultDataAccessException {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue(CG_ID, (Object)cellGroupID);
        params.addValue(VERSION, (Object)partyGroupKeyVersion);
        return (WrapedPgKey)this.daoTemplate.queryForObject(sql_wrap_pgk_data, (SqlParameterSource)params, (RowMapper)new RowMapper<WrapedPgKey>(){

            public WrapedPgKey mapRow(ResultSet rs, int rowNum) throws SQLException {
                try {
                    return (WrapedPgKey)JsonMapper.alwaysMapper().fromJson(rs.getString(WrapPgkDao.C_DATA), WrapedPgKey.class);
                }
                catch (JSONException e) {
                    throw new DataCorruptionException(WrapPgkDao.MAP_WRAPED_PG_KEY_ERROR, (Throwable)e);
                }
            }
        });
    }

    public Map<Long, WrapedPgKey> getWrapedPGKData(String partyGroupID, Long cellGroupID) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue(CG_ID, (Object)cellGroupID);
        final HashMap<Long, WrapedPgKey> wrapedPgkDataMap = new HashMap<Long, WrapedPgKey>();
        this.daoTemplate.queryForList(sql_wrap_pgk_data_version, (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                try {
                    wrapedPgkDataMap.put(rs.getLong(WrapPgkDao.N_PGK_VERSION), JsonMapper.alwaysMapper().fromJson(rs.getString(WrapPgkDao.C_DATA), WrapedPgKey.class));
                }
                catch (JSONException e) {
                    throw new DataCorruptionException(WrapPgkDao.MAP_WRAPED_PG_KEY_ERROR, (Throwable)e);
                }
                return null;
            }
        });
        return wrapedPgkDataMap;
    }

    public WrapedPgKey getLatestWrapedPGKData(String partyGroupID, Long cellGroupID) throws EmptyResultDataAccessException {
        String sql = SELECT_WRAP_DATA;
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue(CG_ID, (Object)cellGroupID);
        return (WrapedPgKey)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<WrapedPgKey>(){

            public WrapedPgKey mapRow(ResultSet rs, int rowNum) throws SQLException {
                try {
                    return (WrapedPgKey)JsonMapper.alwaysMapper().fromJson(rs.getString(WrapPgkDao.C_DATA), WrapedPgKey.class);
                }
                catch (JSONException e) {
                    throw new DataCorruptionException(WrapPgkDao.MAP_WRAPED_PG_KEY_ERROR, (Throwable)e);
                }
            }
        });
    }

    public Long getWrapPgkVersion(String partyGroupID, Long cellGroupID, Long pgkVersion) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue(CG_ID, (Object)cellGroupID);
        params.addValue(PGK_VER, (Object)pgkVersion);
        return this.daoTemplate.queryForLong(sql_wrap_pgk_version, (SqlParameterSource)params);
    }

    public void clearByCellGroup(Long cellGroupID) {
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_N_CELLGROUP_ID_C_ID, (SqlParameterSource)new MapSqlParameterSource(C_ID, (Object)cellGroupID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong("n_wrap_pgk_data_id"));
                pgkIDs.add(resultSet.getLong(WrapPgkDao.N_ID));
                return null;
            }
        });
        this.clearByIds(syncDataIDs, pgkIDs);
    }

    private void clearByIds(List<Long> syncDataIDs, List<Long> pgkIDs) {
        if (!syncDataIDs.isEmpty()) {
            this.deleteBySql(DELETE_FROM_T_WRAP_PGK_DATA_WHERE_N_ID_IN_IDS, (SqlParameterSource)new MapSqlParameterSource(IDS, syncDataIDs));
        }
        if (!pgkIDs.isEmpty()) {
            this.deleteBySql(DELETE_FROM_T_WRAP_PGK_WHERE_N_ID_IN_IDS, (SqlParameterSource)new MapSqlParameterSource(IDS, pgkIDs));
        }
    }

    public void clearBypartyGroupID(String partyGroupID) {
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong("n_wrap_pgk_data_id"));
                pgkIDs.add(resultSet.getLong(WrapPgkDao.N_ID));
                return null;
            }
        });
        this.clearByIds(syncDataIDs, pgkIDs);
    }

    public void delete(String partyGroupID, List<Long> cellGroupIDs) {
        final ArrayList<Long> syncDataIDs = new ArrayList<Long>();
        final ArrayList<Long> pgkIDs = new ArrayList<Long>();
        this.queryForList(SELECT_N_ID_N_WRAP_PGK_DATA_ID_FROM_T_WRAP_PGK_WHERE_C_PARTYGROUP_ID_PG_ID_AND_N_CELLGROUP_ID_IN_C_IDS, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID).addValue(C_IDS, cellGroupIDs), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                syncDataIDs.add(resultSet.getLong("n_wrap_pgk_data_id"));
                pgkIDs.add(resultSet.getLong(WrapPgkDao.N_ID));
                return null;
            }
        });
        this.clearByIds(syncDataIDs, pgkIDs);
    }
}

