/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.bean.BackupData;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TKek;
import com.xdja.safecenter.secret.model.TKekWrapKey;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class kekKeyDao
extends BaseDao {
    public TKek queryBySN(String sn) {
        return (TKek)this.daoTemplate.fetch(TKek.class, (Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn));
    }

    public List<TKekWrapKey> queryKekWrapKey(List<Long> wrapKeyids, String kekId) {
        return this.daoTemplate.query(TKekWrapKey.class, (Condition)Cnd.where((String)"n_wrapkey_id", (String)"in", wrapKeyids).and("c_kek_id", "=", (Object)kekId));
    }

    public TKekWrapKey queryKekWrapKeyByKeKid(Long wrapKeyid, String kekId) {
        return (TKekWrapKey)this.daoTemplate.fetch(TKekWrapKey.class, (Condition)Cnd.where((String)"n_wrapkey_id", (String)"=", (Object)wrapKeyid).and("c_kek_id", "=", (Object)kekId));
    }

    public List<TKekWrapKey> queryKekWrapKeyID(String kekId) {
        return this.daoTemplate.query(TKekWrapKey.class, (Condition)Cnd.where((String)"c_kek_id", (String)"=", (Object)kekId));
    }

    public List<String> queryExistSn(List<String> snList) {
        String sql = "SELECT c_sn FROM t_kek WHERE c_sn IN (:snList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        return this.queryColumnForList(sql, (SqlParameterSource)params, "c_sn");
    }

    public void saveKekBatch(List<BackupData> datas) {
        String sql = "INSERT INTO t_kek(n_id,c_chip_id,c_sn,c_data) VALUES(:id,:chipId,:sn,:data)";
        MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
        MapSqlParameterSource item = null;
        BackupData data = null;
        for (int i = 0; i < datas.size(); ++i) {
            data = datas.get(i);
            item = new MapSqlParameterSource();
            item.addValue("id", (Object)data.getKekId());
            item.addValue("chipId", (Object)data.getChipNo().toLowerCase());
            item.addValue("sn", (Object)data.getSn().toLowerCase());
            item.addValue("data", (Object)data.getKek().toString());
            params[i] = item;
        }
        this.batch(sql, (SqlParameterSource[])params);
    }
}

