/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.backup;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BackupCardDao;
import com.xdja.safecenter.secret.dao.BackupDataDao;
import com.xdja.safecenter.secret.model.TBackupCard;
import com.xdja.safecenter.secret.model.TBackupData;
import com.xdja.safecenter.secret.provider.backup.BackupCardInfo;
import com.xdja.safecenter.secret.provider.backup.BackupProvider;
import com.xdja.safecenter.secret.provider.backup.BaseProvider;
import com.xdja.safecenter.secret.provider.backup.bean.BackupCardStatus;
import com.xdja.safecenter.secret.provider.backup.bean.BackupType;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.BackupKek;
import com.xdja.safecenter.secret.struct.v2.UNBindInfo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupProviderImpl
extends BaseProvider
implements BackupProvider {
    @Autowired
    private BackupCardDao backupCardDao;
    @Autowired
    private BackupDataDao backupDataDao;

    public String querySnByChipSn(String chipSn) {
        List<String> snList = this.backupCardDao.querySnList(chipSn, BackupCardStatus.USED.value);
        if (null != snList && !snList.isEmpty()) {
            return snList.get(0);
        }
        return null;
    }

    public ResultBean checkBackupCardStatus(String bSn, String bCode) {
        ResultBean result = new ResultBean();
        result.setCode(1);
        BackupCardInfo card = this.getCardInfo(bSn);
        TBackupCard cardInfo = this.backupCardDao.getBackupCard(bSn);
        int resultCode = this.checkBackupCard(cardInfo, card);
        if (resultCode != 1) {
            result.setCode(resultCode);
            return result;
        }
        if (!bCode.equalsIgnoreCase(card.getbCode())) {
            result.setCode(5);
            return result;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("pubKey", card.getPubKey());
        info.put("baAlg", String.valueOf(card.getBaAlg()));
        result.setInfo(info);
        return result;
    }

    public int doUploadKek(SourceDataStruct baKek) throws JSONException {
        BackupKek backKek = (BackupKek)JsonMapper.alwaysMapper().fromJson(baKek.getInfo(), BackupKek.class);
        BackupCardInfo remoteCard = this.getCardInfo(backKek.getBackupSn());
        TBackupCard localCard = this.backupCardDao.getBackupCard(backKek.getBackupSn());
        int result = this.checkBackupCard(localCard, remoteCard);
        if (result != 1) {
            return result;
        }
        TBackupCard tmpCardInfo = new TBackupCard();
        tmpCardInfo.setId(RedisUtil.incr((String)"back"));
        tmpCardInfo.setSn(backKek.getBackupSn());
        tmpCardInfo.setChipSn(backKek.getSn());
        tmpCardInfo.setType(BackupType.CARD.value);
        tmpCardInfo.setStatus(BackupCardStatus.USED.value);
        tmpCardInfo.setTime(System.currentTimeMillis());
        this.backupCardDao.insert(tmpCardInfo);
        TBackupData data = new TBackupData();
        data.setId(tmpCardInfo.getId());
        data.setData(JsonMapper.alwaysMapper().toJson((Object)baKek));
        this.backupDataDao.insert(data);
        this.sendUpdateBackupCardStatusMsg(backKek.getBackupSn(), BackupCardStatus.USED);
        return result;
    }

    public int unbindBackupCard(SourceDataStruct unbind) throws JSONException {
        UNBindInfo info = (UNBindInfo)JsonMapper.alwaysMapper().fromJson(unbind.getInfo(), UNBindInfo.class);
        BackupCardInfo remoteCard = this.getCardInfo(info.getBackupSn());
        TBackupCard localCard = this.backupCardDao.getBackupCard(info.getBackupSn());
        if (null == remoteCard) {
            return 2;
        }
        if (null == localCard) {
            return 6;
        }
        if (!localCard.getChipSn().equals(info.getSn())) {
            return 7;
        }
        TBackupCard tmp = new TBackupCard();
        tmp.setId(localCard.getId());
        tmp.setStatus(BackupCardStatus.UNBIND.value);
        this.backupCardDao.updateIgnoreNull(tmp);
        this.sendUpdateBackupCardStatusMsg(info.getBackupSn(), BackupCardStatus.UNBIND);
        return 1;
    }
}

