/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.backup;

import com.xdja.cssp.acs.IAssetService;
import com.xdja.cssp.acs.IBackupCardService;
import com.xdja.cssp.acs.bean.asset.BackupCard;
import com.xdja.cssp.acs.bean.cert.Cert;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.rabbit.RabbitUtil;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.CellGroupDataDao;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.dao.MissionDao;
import com.xdja.safecenter.secret.dao.MissionDataDao;
import com.xdja.safecenter.secret.dao.SyncPairDao;
import com.xdja.safecenter.secret.dao.WrapkeyDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TBackupCard;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TCellGroupData;
import com.xdja.safecenter.secret.model.TDevice;
import com.xdja.safecenter.secret.model.TKekWrapKey;
import com.xdja.safecenter.secret.model.TMission;
import com.xdja.safecenter.secret.model.TMissionData;
import com.xdja.safecenter.secret.model.TSyncPair;
import com.xdja.safecenter.secret.model.TSyncPrivateKeyData;
import com.xdja.safecenter.secret.model.TSyncPublicKey;
import com.xdja.safecenter.secret.model.TSyncPublicKeyData;
import com.xdja.safecenter.secret.model.TWrapKey;
import com.xdja.safecenter.secret.provider.backup.BackupCardInfo;
import com.xdja.safecenter.secret.provider.backup.bean.BackupCardStatus;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.SyncedWrapKeyInfo;
import com.xdja.safecenter.secret.provider.restore.bean.EntityInfo;
import com.xdja.safecenter.secret.provider.todo.bean.struct.RestoreWrapKeyData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.RestoreWrapPgkData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.WrapPgkData;
import com.xdja.safecenter.secret.struct.Constants;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.CellGroupStruct;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.SyncPubKey;
import java.util.HashMap;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;

public class BaseProvider
extends AbstractProvider {
    private IBackupCardService service = (IBackupCardService)DefaultServiceRefer.getServiceRefer(IBackupCardService.class);
    private IAssetService assetService = (IAssetService)DefaultServiceRefer.getServiceRefer(IAssetService.class);
    @Autowired
    private CellgroupDao cellgroupDao;
    @Autowired
    private CellGroupDataDao cellGroupDataDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private kekKeyDao kekKeyDao;
    @Autowired
    private WrapkeyDao wrapkeyDao;
    @Autowired
    private SyncPairDao syncPairDao;
    @Autowired
    private MissionDao missionDao;
    @Autowired
    private MissionDataDao missionDataDao;

    protected BackupCardInfo getCardInfo(final String bSn) {
        return (BackupCardInfo)RedisUtil.execute((RedisCallback)new RedisCallback<BackupCardInfo>(){

            public BackupCardInfo doInRedis(RedisConnection con) throws DataAccessException {
                BackupCardInfo cardInfo = null;
                HashMap<byte[], byte[]> data = null;
                String key = "backupCard:" + bSn;
                if (!con.exists(key.getBytes()).booleanValue()) {
                    List result = BaseProvider.this.service.queryBakCards(new String[]{bSn});
                    if (null == result || result.isEmpty()) {
                        return cardInfo;
                    }
                    BackupCard card = (BackupCard)result.get(0);
                    data = new HashMap<byte[], byte[]>();
                    data.put("sn".getBytes(), card.getBakCardSn().getBytes());
                    data.put("pubKey".getBytes(), card.getPublicKey().getBytes());
                    data.put("priKey".getBytes(), card.getPrivateKey().getBytes());
                    data.put("baAlg".getBytes(), String.valueOf(card.getbKeyPairAlg()).getBytes());
                    data.put("prAlg".getBytes(), String.valueOf(card.getEncBkeyPairAlg()).getBytes());
                    data.put("bCode".getBytes(), card.getVerifyCode().getBytes());
                    data.put("rCode".getBytes(), card.getRecoveryCode().getBytes());
                    con.hMSet(key.getBytes(), data);
                    cardInfo = new BackupCardInfo();
                    cardInfo.setSn(card.getBakCardSn());
                    cardInfo.setPubKey(card.getPublicKey());
                    cardInfo.setPriKey(card.getPrivateKey());
                    cardInfo.setBaAlg(card.getbKeyPairAlg());
                    cardInfo.setPrAlg(card.getEncBkeyPairAlg());
                    cardInfo.setbCode(card.getVerifyCode());
                    cardInfo.setrCode(card.getRecoveryCode());
                    return cardInfo;
                }
                data = con.hGetAll(key.getBytes());
                cardInfo = new BackupCardInfo();
                cardInfo.setSn(new String((byte[])data.get("sn".getBytes())));
                cardInfo.setPubKey(new String((byte[])data.get("pubKey".getBytes())));
                cardInfo.setPriKey(new String((byte[])data.get("priKey".getBytes())));
                cardInfo.setBaAlg(Integer.parseInt(new String((byte[])data.get("baAlg".getBytes()))));
                cardInfo.setPrAlg(Integer.parseInt(new String((byte[])data.get("prAlg".getBytes()))));
                cardInfo.setbCode(new String((byte[])data.get("bCode".getBytes())));
                cardInfo.setrCode(new String((byte[])data.get("rCode".getBytes())));
                return cardInfo;
            }
        });
    }

    protected boolean isBackupKey(String bKeySn) {
        return this.assetService.queryUsbkeyIsBC(bKeySn, Integer.valueOf(Cert.CaAlg.SM2.value));
    }

    protected int checkBackupCard(TBackupCard localCard, BackupCardInfo remoteCard) {
        if (null == remoteCard) {
            return 2;
        }
        if (null != localCard) {
            if (localCard.getStatus() == BackupCardStatus.USED.value) {
                return 4;
            }
            if (localCard.getStatus() == BackupCardStatus.INVALID.value || localCard.getStatus() == BackupCardStatus.UNBIND.value) {
                return 3;
            }
        }
        return 1;
    }

    protected void sendUpdateBackupCardStatusMsg(String bSn, BackupCardStatus status) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("sn", bSn);
        item.put("status", status.value);
        RabbitUtil.send((String)Constants.SC_APP_ID, (String)"updateBackupCardStatus", (Object)new Object[]{item});
    }

    protected void saveEntityInfo(EntityInfo info, String restoreSN, String chipSN) throws JSONException {
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(info.getCellGroup().getInfo(), CellGroupStruct.class);
        TCellGroup tCellGroup = this.getCellGroup(cellGroupStruct.getAppID(), cellGroupStruct.getCgID());
        TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
        tCellGroupData.setData(info.getCellGroup().toString());
        this.cellGroupDataDao.update(tCellGroupData);
        List list = info.getKekWrapKey();
        TDevice backupDevice = this.deviceDao.findByEntityIdAndSN(tCellGroup.getEntityID(), chipSN, tCellGroup.getAppID());
        if (info.getIn() == 0) {
            tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
            for (KekWrapKey kekWrapKey : list) {
                TWrapKey wk = this.wrapkeyDao.getByCgIdAndVersion(tCellGroup.getId(), Long.parseLong(kekWrapKey.getWkVer()));
                if (wk == null) continue;
                this.kekKeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kekWrapKey.getKekID(), wk.getId(), kekWrapKey.toString()));
            }
            SyncPubKey pubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(info.getSyncPubKey().getInfo(), SyncPubKey.class);
            TSyncPublicKeyData TSyncPublicKeyData2 = this.syncPairDao.insert(new TSyncPublicKeyData(RedisUtil.incr((String)"spukdk"), info.getSyncPubKey().toString()));
            TSyncPrivateKeyData TSyncPrivateKeyData2 = this.syncPairDao.insert(new TSyncPrivateKeyData(RedisUtil.incr((String)"sprkdk"), info.getSyncPriKey().toString()));
            this.syncPairDao.insert(new TSyncPair(pubKey.getSkID(), pubKey.getCiD(), tCellGroup.getAppID(), tCellGroup.getId(), System.currentTimeMillis(), pubKey.getSkPub(), TSyncPublicKeyData2.getId(), TSyncPrivateKeyData2.getId(), pubKey.getSn()));
            this.syncPairDao.insert(new TSyncPublicKey(pubKey.getSkID(), TSyncPublicKeyData2.getId()));
            this.deviceDao.insert(new TDevice(RedisUtil.incr((String)"devidk"), pubKey.getSn(), tCellGroup.getId(), pubKey.getCiD(), System.currentTimeMillis(), 2, pubKey.getSn(), backupDevice.getStart(), -1L, backupDevice.getStartTime(), -1L, tCellGroup.getEntityID(), tCellGroup.getAppID()));
        } else {
            TDevice restoreDevice = this.deviceDao.findByEntityIdAndSN(tCellGroup.getEntityID(), restoreSN, tCellGroup.getAppID());
            for (KekWrapKey kekWrapKey : list) {
                TWrapKey wk = this.wrapkeyDao.getByCgIdAndVersion(tCellGroup.getId(), Long.parseLong(kekWrapKey.getWkVer()));
                if (wk == null || wk.getVersion() >= restoreDevice.getStart()) continue;
                this.kekKeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kekWrapKey.getKekID(), wk.getId(), kekWrapKey.toString()));
            }
            if (restoreDevice.getStart() > backupDevice.getStart()) {
                restoreDevice.setStart(backupDevice.getStart());
                restoreDevice.setStartTime(backupDevice.getStartTime());
                this.deviceDao.update(restoreDevice);
                tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
            }
        }
        this.cellgroupDao.update(tCellGroup);
    }

    private TCellGroup getCellGroup(String appID, String entityID) {
        return (TCellGroup)this.cellgroupDao.fetch((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_entity_id", "=", (Object)entityID));
    }

    protected void copyTodos2RestoreDevice(String chipSN, String sn, String kekId, String encKek) throws JSONException {
        List<TMission> missions = this.missionDao.getMissionsBySn(chipSN);
        if (!missions.isEmpty()) {
            for (TMission m : missions) {
                this.convertByType(m.getType(), sn, m, kekId, encKek);
            }
        }
    }

    private void convertByType(int type, String sn, TMission m, String kekId, String encKek) throws JSONException {
        try {
            TMission mission = new TMission();
            mission.setAppID(m.getAppID());
            mission.setEntityId(m.getEntityId());
            mission.setCreateTime(System.currentTimeMillis());
            mission.setPartyGroupId(m.getPartyGroupId());
            mission.setSn(sn);
            mission.setType(type);
            TMissionData newData = null;
            switch (type) {
                case 0: {
                    mission.setMid(m.getMid());
                    this.missionDao.insert(mission);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    mission.setMid(m.getMid());
                    this.missionDao.insert(mission);
                    break;
                }
                case 3: {
                    mission.setMid(RedisUtil.incr((String)"todo:i:"));
                    this.missionDao.insert(mission);
                    TMissionData data = this.missionDataDao.query(TMissionData.class, m.getMid());
                    if (data == null) break;
                    newData = new TMissionData();
                    newData.setId(mission.getMid());
                    newData.setData(data.getData());
                    this.missionDataDao.insert(newData);
                    break;
                }
                case 4: {
                    mission.setType(6);
                    mission.setMid(RedisUtil.incr((String)"todo:i:"));
                    this.missionDao.insert(mission);
                    TMissionData dataWrapkey = this.missionDataDao.query(TMissionData.class, m.getMid());
                    SyncedWrapKeyInfo wrapKeyInfo = (SyncedWrapKeyInfo)JsonMapper.alwaysMapper().fromJson(dataWrapkey.getData(), SyncedWrapKeyInfo.class);
                    RestoreWrapKeyData restoreWrapKeyData = new RestoreWrapKeyData(wrapKeyInfo.getWrapKey(), wrapKeyInfo.getSyncedWrapKey(), (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(this.syncPairDao.query(TSyncPrivateKeyData.class, this.syncPairDao.getPairBySkID(wrapKeyInfo.getSyncedWrapKey().getSkID()).getPrivateKeyDataID()).getData(), SourceDataStruct.class), encKek, kekId);
                    newData = new TMissionData();
                    newData.setId(mission.getMid());
                    newData.setData(JsonMapper.alwaysMapper().toJson((Object)restoreWrapKeyData));
                    this.missionDataDao.insert(newData);
                    break;
                }
                case 5: {
                    mission.setType(7);
                    mission.setMid(RedisUtil.incr((String)"todo:i:"));
                    this.missionDao.insert(mission);
                    TMissionData dataWrapPgk = this.missionDataDao.query(TMissionData.class, m.getMid());
                    WrapPgkData wrapPgkData = (WrapPgkData)JsonMapper.alwaysMapper().fromJson(dataWrapPgk.getData(), WrapPgkData.class);
                    RestoreWrapPgkData restoreWrapPgkData = new RestoreWrapPgkData(wrapPgkData.getPartyGroupKey(), wrapPgkData.getSyncedPgKey(), (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(this.syncPairDao.query(TSyncPrivateKeyData.class, this.syncPairDao.getPairBySkID(wrapPgkData.getSyncedPgKey().getSkID()).getPrivateKeyDataID()).getData(), SourceDataStruct.class), encKek, kekId);
                    newData = new TMissionData();
                    newData.setId(mission.getMid());
                    newData.setData(JsonMapper.alwaysMapper().toJson((Object)restoreWrapPgkData));
                    this.missionDataDao.insert(newData);
                    break;
                }
            }
        }
        catch (JSONException e) {
            this.logger.error("\u590d\u5236\u5907\u4efd\u8bbe\u5907\u4ee3\u529e\u4e8b\u9879\u65f6 json\u8f6c\u5316\u5f02\u5e38 \u5907\u4efd\u8bbe\u5907SN:{},\u6062\u590d\u8bbe\u5907SN:{}", new Object[]{m.getSn(), sn, e});
            throw e;
        }
    }
}

