/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.cellgroup;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.CellGroupDataDao;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.ChipAddRequestDao;
import com.xdja.safecenter.secret.dao.ChipAddRequestDataDao;
import com.xdja.safecenter.secret.dao.DestroyInfoDao;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.dao.SyncPairDao;
import com.xdja.safecenter.secret.dao.SyncWkRequestDao;
import com.xdja.safecenter.secret.dao.SyncWrapKeyDao;
import com.xdja.safecenter.secret.dao.SyncedPgkDao;
import com.xdja.safecenter.secret.dao.TQuitInfoDao;
import com.xdja.safecenter.secret.dao.WrapPgkDao;
import com.xdja.safecenter.secret.dao.WrapkeyDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TCellGroupData;
import com.xdja.safecenter.secret.model.TChipAddRequest;
import com.xdja.safecenter.secret.model.TChipAddRequestData;
import com.xdja.safecenter.secret.model.TChipSyncWKRequest;
import com.xdja.safecenter.secret.model.TChipSyncWKRequestData;
import com.xdja.safecenter.secret.model.TDestroyInfoData;
import com.xdja.safecenter.secret.model.TDevice;
import com.xdja.safecenter.secret.model.TKek;
import com.xdja.safecenter.secret.model.TKekWrapKey;
import com.xdja.safecenter.secret.model.TQuitInfoData;
import com.xdja.safecenter.secret.model.TSyncPair;
import com.xdja.safecenter.secret.model.TSyncPrivateKeyData;
import com.xdja.safecenter.secret.model.TSyncPublicKey;
import com.xdja.safecenter.secret.model.TSyncPublicKeyData;
import com.xdja.safecenter.secret.model.TSyncWrapKey;
import com.xdja.safecenter.secret.model.TSyncWrapKeyData;
import com.xdja.safecenter.secret.model.TWrapKey;
import com.xdja.safecenter.secret.model.TWrapKeyData;
import com.xdja.safecenter.secret.provider.cellgroup.IEntityProvider;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.DeviceSyncWKReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.GetDeviceAddReq;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.KekWrapKeyInfo;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.SyncedWrapKeyInfo;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.WrapKeyInfo;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetDeviciesResp;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetEntityResp;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetSyncPairResp;
import com.xdja.safecenter.secret.provider.cellgroup.bean.response.GetWrapKeysResp;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.CellGroupStruct;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.QuitInfo;
import com.xdja.safecenter.secret.struct.v2.ReqAddCellGroup;
import com.xdja.safecenter.secret.struct.v2.ReqSyncWrapKey;
import com.xdja.safecenter.secret.struct.v2.SyncPubKey;
import com.xdja.safecenter.secret.struct.v2.SyncedWrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityProviderImpl
extends AbstractProvider
implements IEntityProvider {
    private static final int GET_ALL_VERSION = -1;
    private static final int GET_LAST_VERSION = -2;
    @Resource
    private SyncedPgkDao syncedPgkDao;
    @Resource
    private WrapPgkDao wrapPgkDao;
    @Resource
    private SyncWrapKeyDao syncWrapKeyDao;
    @Resource
    private ChipAddRequestDao chipAddRequestDao;
    @Resource
    private ChipAddRequestDataDao chipAddRequestDataDao;
    @Resource
    private SyncPairDao syncPairDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private ITodoProvider todoProvider;
    @Resource
    private CellgroupDao cellgroupDao;
    @Resource
    private CellGroupDataDao cellGroupDataDao;
    @Resource
    private WrapkeyDao wrapkeyDao;
    @Resource
    private kekKeyDao kekKeyDao;
    @Resource
    private DestroyInfoDao destroyInfoDao;
    @Resource
    private TQuitInfoDao quitInfoDao;
    @Resource
    private SyncWkRequestDao syncWkRequestDao;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public HashMap<String, List<String>> getEntitiesBySnAndAppId(List<String> snList, String appID) {
        HashMap<String, List<String>> resualt = new HashMap<String, List<String>>();
        if (snList.isEmpty()) {
            return resualt;
        }
        List<TDevice> devices = this.deviceDao.getDevicesBySnList(snList, appID);
        for (TDevice dev : devices) {
            if (resualt.containsKey(dev.getSn())) {
                resualt.get(dev.getSn()).add(dev.getEntityID());
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(dev.getEntityID());
            resualt.put(dev.getSn(), list);
        }
        return resualt;
    }

    public boolean existEntity(String appID, String entityId) {
        return this.cellgroupDao.existEntity(appID, entityId);
    }

    public void doCreateEntity(SourceDataStruct cellGroup, SourceDataStruct wrapKey, KekWrapKey kekWrapKey, SourceDataStruct syncPriKey, SourceDataStruct SyncPubKey2) throws JSONException {
        long cellGroupID = RedisUtil.incr((String)"cid");
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        TCellGroupData TCellGroupData2 = (TCellGroupData)this.cellGroupDataDao.insert(new TCellGroupData(cellGroupID, cellGroup.toString()));
        TWrapKey TWrapKey2 = this.wrapkeyDao.insert(new TWrapKey(RedisUtil.incr((String)"wkdk"), cellGroupID, 0L, System.currentTimeMillis()));
        TWrapKeyData TWrapKeyData2 = this.wrapkeyDao.insert(new TWrapKeyData(TWrapKey2.getId(), wrapKey.toString()));
        this.cellgroupDao.insert(new TCellGroup(cellGroupID, cellGroupStruct.getAppID(), 0L, 0L, TWrapKeyData2.getId(), TCellGroupData2.getId(), cellGroupStruct.getCgID()));
        this.kekKeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kekWrapKey.getKekID(), TWrapKey2.getId(), kekWrapKey.toString()));
        TSyncPublicKeyData TSyncPublicKeyData2 = this.syncPairDao.insert(new TSyncPublicKeyData(RedisUtil.incr((String)"spukdk"), SyncPubKey2.toString()));
        TSyncPrivateKeyData TSyncPrivateKeyData2 = this.syncPairDao.insert(new TSyncPrivateKeyData(RedisUtil.incr((String)"sprkdk"), syncPriKey.toString()));
        SyncPubKey pubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(SyncPubKey2.getInfo(), SyncPubKey.class);
        this.syncPairDao.insert(new TSyncPair(pubKey.getSkID(), cellGroupStruct.getCreatorCID(), cellGroupStruct.getAppID(), cellGroupID, System.currentTimeMillis(), pubKey.getSkPub(), TSyncPublicKeyData2.getId(), TSyncPrivateKeyData2.getId(), cellGroupStruct.getSn()));
        this.syncPairDao.insert(new TSyncPublicKey(pubKey.getSkID(), TSyncPublicKeyData2.getId()));
        this.deviceDao.insert(new TDevice(RedisUtil.incr((String)"devidk"), cellGroupStruct.getSn(), cellGroupID, cellGroupStruct.getCreatorCID(), System.currentTimeMillis(), 0, cellGroupStruct.getSn(), -1L, -1L, -1L, -1L, cellGroupStruct.getCgID(), cellGroupStruct.getAppID()));
    }

    public Map<String, List<GetDeviciesResp>> getDevicesByEnityAndAppId(List<String> entityIDs, String appID) {
        HashMap<String, List<GetDeviciesResp>> resualt = new HashMap<String, List<GetDeviciesResp>>();
        if (entityIDs.isEmpty()) {
            return resualt;
        }
        List<TDevice> devices = this.deviceDao.getDevicesByEntityList(entityIDs, appID);
        for (TDevice dev : devices) {
            if (resualt.containsKey(dev.getEntityID())) {
                ((List)resualt.get(dev.getEntityID())).add(new GetDeviciesResp(dev.getChipID(), dev.getSn(), String.valueOf(dev.getAddTime()), String.valueOf(dev.getAddType()), dev.getConfirmDev(), String.valueOf(dev.getStartTime()), String.valueOf(dev.getEndTime())));
                continue;
            }
            ArrayList<GetDeviciesResp> resps = new ArrayList<GetDeviciesResp>();
            resps.add(new GetDeviciesResp(dev.getChipID(), dev.getSn(), String.valueOf(dev.getAddTime()), String.valueOf(dev.getAddType()), dev.getConfirmDev(), String.valueOf(dev.getStartTime()), String.valueOf(dev.getEndTime())));
            resualt.put(dev.getEntityID(), resps);
        }
        return resualt;
    }

    public boolean existDevice(String appID, String sn, String entityID) {
        return this.deviceDao.existDevice(appID, sn, entityID);
    }

    public void deleteDeviceAddRequestBySnAndEntity(String sn, String appID, String entityID) {
        this.chipAddRequestDao.clearDeviceAddRequestBySnAndEntity(sn, appID, entityID);
    }

    public long doCreateDeviceAddRequest(SourceDataStruct syncPubKey, SourceDataStruct syncPriKey, SourceDataStruct reqAddCellGroup) throws JSONException {
        ReqAddCellGroup req = (ReqAddCellGroup)JsonMapper.alwaysMapper().fromJson(reqAddCellGroup.getInfo(), ReqAddCellGroup.class);
        TChipAddRequestData data = new TChipAddRequestData(RedisUtil.incr((String)"cardk"), reqAddCellGroup.toString());
        data = (TChipAddRequestData)this.chipAddRequestDataDao.insert(data);
        TChipAddRequest TChipAddRequest2 = new TChipAddRequest(data.getId(), req.getCgID(), req.getCiD(), req.getSn(), req.getAppID(), syncPubKey.toString(), syncPriKey.toString());
        TChipAddRequest2 = (TChipAddRequest)this.chipAddRequestDao.insert(TChipAddRequest2);
        return TChipAddRequest2.getId();
    }

    public GetDeviceAddReq getRequestBeanByIndex(String request_index) {
        long id = Long.valueOf(request_index);
        TChipAddRequest req = (TChipAddRequest)this.chipAddRequestDao.fetch(id);
        TChipAddRequestData data = (TChipAddRequestData)this.chipAddRequestDataDao.fetch(id);
        if (req == null || data == null) {
            return null;
        }
        return new GetDeviceAddReq(data.getData(), req.getPublicKey(), req.getAppID());
    }

    public GetEntityResp getEntityInfos(String appID, String entityID, String sn) throws JSONException {
        TCellGroup tCellGroup = this.getCellGroup(appID, entityID);
        GetEntityResp resp = new GetEntityResp();
        resp.setCellGroup((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(((TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId())).getData(), SourceDataStruct.class));
        TDevice dev = this.deviceDao.findByEntityIdAndSN(entityID, sn, appID);
        if (dev == null) {
            return resp;
        }
        List<TWrapKey> wrapKeys = this.wrapkeyDao.getByCgIdAndStartVersion(tCellGroup.getId(), dev.getStart());
        List<Long> wrapKeyids = this.getIds(wrapKeys);
        List<TWrapKeyData> wrapKeyDatas = this.wrapkeyDao.getDataByIds(wrapKeyids);
        TKek kek = this.kekKeyDao.queryBySN(sn);
        List<Object> kekWrapKeys = new ArrayList();
        if (kek != null) {
            kekWrapKeys = this.kekKeyDao.queryKekWrapKey(wrapKeyids, kek.getId());
        }
        HashMap<Long, WrapKeyInfo> WrapKeyInfoMaps = new HashMap<Long, WrapKeyInfo>();
        for (TWrapKeyData tWrapKeyData : wrapKeyDatas) {
            if (WrapKeyInfoMaps.containsKey(tWrapKeyData.getId())) continue;
            WrapKeyInfo wrapKeyInfo = new WrapKeyInfo();
            wrapKeyInfo.setWrapKey((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(tWrapKeyData.getData(), SourceDataStruct.class));
            WrapKeyInfoMaps.put(tWrapKeyData.getId(), wrapKeyInfo);
        }
        for (TKekWrapKey tKekWrapKey : kekWrapKeys) {
            if (!WrapKeyInfoMaps.containsKey(tKekWrapKey.getWrapKeyID())) continue;
            ((WrapKeyInfo)WrapKeyInfoMaps.get(tKekWrapKey.getWrapKeyID())).setKekWrapKey((KekWrapKey)JsonMapper.alwaysMapper().fromJson(tKekWrapKey.getData(), KekWrapKey.class));
        }
        ArrayList list = new ArrayList();
        list.addAll(WrapKeyInfoMaps.values());
        resp.setWrapKeyInfos(list);
        return resp;
    }

    private List<Long> getIds(List<TWrapKey> wrapKeys) {
        ArrayList<Long> re = new ArrayList<Long>();
        for (TWrapKey wk : wrapKeys) {
            re.add(wk.getId());
        }
        return re;
    }

    public boolean checkRequestByIndex(long index, String appID, String opId) {
        TChipAddRequest req = (TChipAddRequest)this.chipAddRequestDao.fetch(index);
        return req == null || !appID.equals(req.getAppID()) || !opId.equals(req.getEntityID());
    }

    public boolean checkWrapKeyVersionIllegal(String appID, String EntityId, long maxWrapKeyVersion) {
        TCellGroup cellGroup = this.getCellGroup(appID, EntityId);
        return cellGroup == null || cellGroup.getWrapKeyVersion() < maxWrapKeyVersion;
    }

    public boolean checkEntityVersionIllegal(String appID, String EntityId, Long ver) {
        TCellGroup cellGroup = this.getCellGroup(appID, EntityId);
        return cellGroup.getVersion() + 1L != ver;
    }

    public boolean lock(String appID, String entityId) {
        TCellGroup cellGroup = this.getCellGroup(appID, entityId);
        return RedisUtil.lock((String)("lc:" + cellGroup.getId()));
    }

    public void unlock(String appID, String entityId) {
        TCellGroup cellGroup = this.getCellGroup(appID, entityId);
        RedisUtil.del((String[])new String[]{"lc:" + cellGroup.getId()});
    }

    public void doAddDevice(SourceDataStruct cellGroup, List<SyncedWrapKey> syncedWrapKeys, long index, String sn) throws JSONException {
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        TCellGroup tCellGroup = this.getCellGroup(cellGroupStruct.getAppID(), cellGroupStruct.getCgID());
        TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
        tCellGroupData.setData(cellGroup.toString());
        tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
        this.cellgroupDao.update(tCellGroup);
        this.cellGroupDataDao.update(tCellGroupData);
        TChipAddRequest TChipAddRequest2 = (TChipAddRequest)this.chipAddRequestDao.fetch(index);
        SourceDataStruct pub = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(TChipAddRequest2.getPublicKey(), SourceDataStruct.class);
        SyncPubKey pubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(pub.getInfo(), SyncPubKey.class);
        TSyncPublicKeyData TSyncPublicKeyData2 = this.syncPairDao.insert(new TSyncPublicKeyData(RedisUtil.incr((String)"spukdk"), TChipAddRequest2.getPublicKey()));
        TSyncPrivateKeyData TSyncPrivateKeyData2 = this.syncPairDao.insert(new TSyncPrivateKeyData(RedisUtil.incr((String)"sprkdk"), TChipAddRequest2.getPrivateKey()));
        TSyncPair TSyncPair2 = this.syncPairDao.insert(new TSyncPair(pubKey.getSkID(), TChipAddRequest2.getChipID(), tCellGroup.getAppID(), tCellGroup.getId(), System.currentTimeMillis(), pubKey.getSkPub(), TSyncPublicKeyData2.getId(), TSyncPrivateKeyData2.getId(), pubKey.getSn()));
        this.syncPairDao.insert(new TSyncPublicKey(pubKey.getSkID(), TSyncPublicKeyData2.getId()));
        for (SyncedWrapKey syncedWrapKey : syncedWrapKeys) {
            TSyncWrapKeyData TSyncWrapKeyData2 = this.syncWrapKeyDao.insert(new TSyncWrapKeyData(RedisUtil.incr((String)"swkdk"), tCellGroup.getId(), syncedWrapKey.toString()));
            this.syncWrapKeyDao.insert(new TSyncWrapKey(TSyncPair2.getId(), Long.valueOf(syncedWrapKey.getWkVer()), TSyncWrapKeyData2.getId()));
        }
        TDevice dev = this.deviceDao.findByEntityIdAndSN(tCellGroup.getEntityID(), sn, tCellGroup.getAppID());
        this.deviceDao.insert(new TDevice(RedisUtil.incr((String)"devidk"), TChipAddRequest2.getSn(), tCellGroup.getId(), TChipAddRequest2.getChipID(), System.currentTimeMillis(), 0, sn, dev.getStart(), -1L, dev.getStartTime(), -1L, dev.getEntityID(), dev.getAppID()));
        this.chipAddRequestDao.delete(index);
        this.chipAddRequestDataDao.delete(index);
        this.todoProvider.createWrapWrapKey(syncedWrapKeys, TChipAddRequest2.getSn(), tCellGroup.getId(), tCellGroup.getAppID(), tCellGroup.getEntityID());
    }

    public boolean checkWrapKeyVersionIllegalByUpdate(String appID, String entityID, String wkVer) {
        TCellGroup cellGroup = this.getCellGroup(appID, entityID);
        return cellGroup.getWrapKeyVersion() + 1L != Long.valueOf(wkVer);
    }

    public void doDeviceForceAdd(SourceDataStruct cellGroup, KekWrapKey kekWrapKey, SourceDataStruct wrapKey, SourceDataStruct syncPubKey, SourceDataStruct syncPriKey, List<SyncedWrapKey> syncedWrapKeys) throws JSONException {
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        TCellGroup tCellGroup = this.getCellGroup(cellGroupStruct.getAppID(), cellGroupStruct.getCgID());
        TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
        WrapKey wk = (WrapKey)JsonMapper.alwaysMapper().fromJson(wrapKey.getInfo(), WrapKey.class);
        TWrapKey tWrapKey = this.wrapkeyDao.insert(new TWrapKey(RedisUtil.incr((String)"wkdk"), tCellGroup.getId(), Long.valueOf(wk.getWkVer()), System.currentTimeMillis()));
        this.wrapkeyDao.insert(new TWrapKeyData(tWrapKey.getId(), wrapKey.toString()));
        this.kekKeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kekWrapKey.getKekID(), tWrapKey.getId(), kekWrapKey.toString()));
        tCellGroupData.setData(cellGroup.toString());
        tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
        tCellGroup.setWrapKeyID(tWrapKey.getId());
        tCellGroup.setWrapKeyVersion(tWrapKey.getVersion());
        this.cellgroupDao.update(tCellGroup);
        this.cellGroupDataDao.update(tCellGroupData);
        SyncPubKey pubKey = (SyncPubKey)JsonMapper.alwaysMapper().fromJson(syncPubKey.getInfo(), SyncPubKey.class);
        TSyncPublicKeyData TSyncPublicKeyData2 = this.syncPairDao.insert(new TSyncPublicKeyData(RedisUtil.incr((String)"spukdk"), syncPubKey.toString()));
        TSyncPrivateKeyData TSyncPrivateKeyData2 = this.syncPairDao.insert(new TSyncPrivateKeyData(RedisUtil.incr((String)"sprkdk"), syncPriKey.toString()));
        this.syncPairDao.insert(new TSyncPair(pubKey.getSkID(), pubKey.getCiD(), tCellGroup.getAppID(), tCellGroup.getId(), System.currentTimeMillis(), pubKey.getSkPub(), TSyncPublicKeyData2.getId(), TSyncPrivateKeyData2.getId(), pubKey.getSn()));
        this.syncPairDao.insert(new TSyncPublicKey(pubKey.getSkID(), TSyncPublicKeyData2.getId()));
        for (SyncedWrapKey syncedWrapKey : syncedWrapKeys) {
            TSyncWrapKeyData TSyncWrapKeyData2 = this.syncWrapKeyDao.insert(new TSyncWrapKeyData(RedisUtil.incr((String)"swkdk"), tCellGroup.getId(), syncedWrapKey.toString()));
            this.syncWrapKeyDao.insert(new TSyncWrapKey(syncedWrapKey.getSkID(), Long.valueOf(syncedWrapKey.getWkVer()), TSyncWrapKeyData2.getId()));
        }
        this.deviceDao.insert(new TDevice(RedisUtil.incr((String)"devidk"), pubKey.getSn(), tCellGroup.getId(), pubKey.getCiD(), System.currentTimeMillis(), 1, pubKey.getSn(), tWrapKey.getVersion(), -1L, tWrapKey.getCreateTime(), -1L, tCellGroup.getEntityID(), tCellGroup.getAppID()));
        this.todoProvider.createWrapWrapKeyForOldDevice(syncedWrapKeys, wrapKey, tCellGroup.getAppID(), tCellGroup.getEntityID());
        this.todoProvider.createUpdatePgk(tCellGroup.getId(), tCellGroup.getAppID());
    }

    public void deleteDevice(List<String> devices, SourceDataStruct cellGroup, KekWrapKey kekWrapKey, SourceDataStruct wrapKeyStruct, List<SyncedWrapKey> syncedWrapKeys) throws JSONException {
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        TCellGroup tCellGroup = this.getCellGroup(cellGroupStruct.getAppID(), cellGroupStruct.getCgID());
        TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
        for (String sn : devices) {
            this.doDeleteAllDeviceData(sn, tCellGroup.getId());
            this.todoProvider.deleteTodosByEntityAndSn(tCellGroup.getAppID(), tCellGroup.getEntityID(), sn);
        }
        WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(wrapKeyStruct.getInfo(), WrapKey.class);
        TWrapKey tWrapKey = this.wrapkeyDao.insert(new TWrapKey(RedisUtil.incr((String)"wkdk"), tCellGroup.getId(), Long.valueOf(wrapKey.getWkVer()), System.currentTimeMillis()));
        TWrapKeyData TWrapKeyData2 = this.wrapkeyDao.insert(new TWrapKeyData(tWrapKey.getId(), wrapKeyStruct.toString()));
        this.kekKeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kekWrapKey.getKekID(), tWrapKey.getId(), kekWrapKey.toString()));
        tCellGroupData.setData(cellGroup.toString());
        tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
        tCellGroup.setWrapKeyID(tWrapKey.getId());
        tCellGroup.setWrapKeyVersion(tWrapKey.getVersion());
        this.cellgroupDao.update(tCellGroup);
        this.cellGroupDataDao.update(tCellGroupData);
        Long wrapKeyVersion = Long.valueOf(wrapKey.getWkVer());
        tCellGroup.setWrapKeyVersion(wrapKeyVersion);
        tCellGroup.setWrapKeyID(TWrapKeyData2.getId());
        this.cellgroupDao.update(tCellGroup);
        for (SyncedWrapKey syncedWrapKey : syncedWrapKeys) {
            TSyncWrapKeyData TSyncWrapKeyData2 = this.syncWrapKeyDao.insert(new TSyncWrapKeyData(RedisUtil.incr((String)"swkdk"), tCellGroup.getId(), syncedWrapKey.toString()));
            this.syncWrapKeyDao.insert(new TSyncWrapKey(syncedWrapKey.getSkID(), Long.valueOf(syncedWrapKey.getWkVer()), TSyncWrapKeyData2.getId()));
        }
        this.todoProvider.createWrapWrapKeyForOldDevice(syncedWrapKeys, wrapKeyStruct, tCellGroup.getAppID(), tCellGroup.getEntityID());
    }

    public void doQuit(SourceDataStruct cellGroup, SourceDataStruct quitInfo) throws JSONException {
        CellGroupStruct cellGroupStruct = (CellGroupStruct)JsonMapper.alwaysMapper().fromJson(cellGroup.getInfo(), CellGroupStruct.class);
        QuitInfo qi = (QuitInfo)JsonMapper.alwaysMapper().fromJson(quitInfo.getInfo(), QuitInfo.class);
        TCellGroup tCellGroup = this.getCellGroup(cellGroupStruct.getAppID(), cellGroupStruct.getCgID());
        this.quitInfoDao.insert(new TQuitInfoData(RedisUtil.incr((String)"qidk"), quitInfo.toString()));
        TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
        tCellGroupData.setData(cellGroup.toString());
        tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
        tCellGroup.setWrapKeyVersion(tCellGroup.getWrapKeyVersion() + 1L);
        this.cellgroupDao.update(tCellGroup);
        this.cellGroupDataDao.update(tCellGroupData);
        this.doDeleteAllDeviceData(qi.getId(), tCellGroup.getId());
        this.todoProvider.deleteTodosByEntityAndSn(tCellGroup.getAppID(), tCellGroup.getEntityID(), qi.getId());
        this.todoProvider.createUpdateWrapKey(cellGroup, tCellGroup.getAppID(), tCellGroup.getEntityID(), qi.getId());
    }

    public boolean checkIsLastDevice(String appId, String opId) {
        return this.deviceDao.getDevices(opId, appId).size() == 1;
    }

    public void doDestroy(SourceDataStruct destroyInfo, String appId, String entityId, String sn) {
        TCellGroup TCellGroup2 = this.getCellGroup(appId, entityId);
        this.destroyInfoDao.insert(new TDestroyInfoData(RedisUtil.incr((String)"didk"), destroyInfo.toString()));
        TDevice device = (TDevice)this.deviceDao.fetch((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appId).and("c_entity_id", "=", (Object)entityId).and("c_sn", "=", (Object)sn));
        this.deviceDao.delete(device);
        this.doDeleteCellGroup(TCellGroup2.getId());
        this.todoProvider.deleteTodosByEntity(appId, entityId);
    }

    public GetSyncPairResp getSyncPairByEntityAndAppId(String appId, String entityId, String sn) throws JSONException {
        TCellGroup tCellGroup = this.getCellGroup(appId, entityId);
        if (tCellGroup == null) {
            return null;
        }
        TSyncPair pair = this.syncPairDao.getPairBySNCgId(sn, tCellGroup.getId());
        if (pair == null) {
            return null;
        }
        TSyncPublicKeyData pub = this.syncPairDao.query(TSyncPublicKeyData.class, pair.getPublicKeyDataID());
        TSyncPrivateKeyData pri = this.syncPairDao.query(TSyncPrivateKeyData.class, pair.getPrivateKeyDataID());
        if (pub == null || pri == null) {
            return null;
        }
        return new GetSyncPairResp((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(pub.getData(), SourceDataStruct.class), (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(pri.getData(), SourceDataStruct.class));
    }

    public List<SourceDataStruct> getEntitiesByEntityIdAndAppId(List<String> entityIds, String appID) throws JSONException {
        ArrayList<SourceDataStruct> entities = new ArrayList<SourceDataStruct>();
        for (String entityId : entityIds) {
            TCellGroup cellGroup = this.getCellGroup(appID, entityId);
            if (cellGroup == null) {
                return null;
            }
            TCellGroupData data = (TCellGroupData)this.cellGroupDataDao.fetch(cellGroup.getId());
            entities.add((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(data.getData(), SourceDataStruct.class));
        }
        return entities;
    }

    public GetWrapKeysResp getWrapKeys(String sn, String appID, String entityId, long ver) throws JSONException {
        GetWrapKeysResp resp = new GetWrapKeysResp();
        TCellGroup cellgroup = this.getCellGroup(appID, entityId);
        if (cellgroup == null) {
            this.logger.info("\u83b7\u53d6\u6240\u6709wrapKey,\u83b7\u53d6Entity\u4e0d\u5b58\u5728");
            return null;
        }
        TDevice device = (TDevice)this.deviceDao.fetch((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("n_cellgroup_id", "=", (Object)cellgroup.getId()));
        if (device == null) {
            this.logger.info("\u83b7\u53d6\u6240\u6709wrapKey,\u83b7\u53d6Device\u4e0d\u5b58\u5728");
            return null;
        }
        if (cellgroup.getWrapKeyVersion() == 0L && (ver == -1L || ver == -2L)) {
            ver = 0L;
        }
        boolean isLast = false;
        if (ver == -2L) {
            ver = cellgroup.getWrapKeyVersion();
            isLast = true;
        } else if (ver == -1L) {
            return this.getAllWrapKeys(sn, cellgroup, device, resp);
        }
        if (device.getStart() != -1L && device.getStart() > ver) {
            this.logger.info("\u83b7\u53d6\u6240\u6709wrapKey,\u8bbe\u5907\u6743\u9650\u4e0d\u5408\u6cd5,\u8bbe\u5907\u7248\u672c\u3010{}\u3011\uff0c\u83b7\u53d6\u7248\u672c\u3010{}\u3011", (Object)device.getStart(), (Object)ver);
            return null;
        }
        return this.getWrapKeyByVersion(sn, ver, cellgroup.getId(), resp, isLast);
    }

    private GetWrapKeysResp getWrapKeyByVersion(String sn, long ver, long cid, GetWrapKeysResp resp, boolean isLast) throws JSONException {
        TWrapKey wk = this.wrapkeyDao.getByCgIdAndVersion(cid, ver);
        if (wk == null) {
            if (isLast) {
                this.logger.info("\u83b7\u53d6\u6700\u65b0\u7248\u672cwrapKey,TWrapKey\u4e0d\u5b58\u5728");
                return resp;
            }
            this.logger.info("\u83b7\u53d6\u6307\u5b9a\u7248\u672cwrapKey,TWrapKey\u4e0d\u5b58\u5728");
            return null;
        }
        TWrapKeyData wkData = this.wrapkeyDao.query(TWrapKeyData.class, wk.getId());
        if (wkData == null) {
            this.logger.info("\u83b7\u53d6\u6240\u6709wrapKey,wkData\u4e0d\u5b58\u5728");
            return null;
        }
        TKek kek = this.kekKeyDao.queryBySN(sn);
        TKekWrapKey tkek = null;
        if (kek != null) {
            tkek = this.kekKeyDao.queryKekWrapKeyByKeKid(wk.getId(), kek.getId());
        }
        SourceDataStruct wrapkey = this.getStruct(wkData.getData(), SourceDataStruct.class);
        if (tkek != null) {
            resp.getKekWrapKeyInfos().add(new KekWrapKeyInfo(wrapkey, this.getStruct(tkek.getData(), KekWrapKey.class)));
        } else {
            this.logger.info("\u83b7\u53d6\u6240\u6709wrapKey,KekWrapKey\u4e0d\u5b58\u5728");
            TSyncPair pair = this.syncPairDao.getPairBySNCgId(sn, cid);
            if (pair == null) {
                return null;
            }
            TSyncWrapKey syncWrapkey = this.syncWrapKeyDao.getBySyncIdAndVersion(pair.getId(), ver);
            if (syncWrapkey == null) {
                return null;
            }
            TSyncWrapKeyData tSyncWrapKeyData = this.syncWrapKeyDao.query(TSyncWrapKeyData.class, syncWrapkey.getId());
            if (tSyncWrapKeyData == null) {
                return null;
            }
            resp.getSyncedWrapKeyInfos().add(new SyncedWrapKeyInfo(wrapkey, this.getStruct(tSyncWrapKeyData.getData(), SyncedWrapKey.class)));
        }
        return resp;
    }

    private GetWrapKeysResp getAllWrapKeys(String sn, TCellGroup cellgroup, TDevice device, GetWrapKeysResp resp) throws JSONException {
        long start = 0L;
        long end = cellgroup.getWrapKeyVersion();
        if (device.getStart() != -1L) {
            start = device.getStart();
        }
        if (device.getEnd() != -1L) {
            end = device.getEnd();
        }
        for (long i = start; i <= end; ++i) {
            this.getWrapKeyByVersion(sn, i, cellgroup.getId(), resp, false);
        }
        return resp;
    }

    private void doDeleteAllDeviceData(String sn, long cid) {
        TDevice dev = (TDevice)this.deviceDao.fetch((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("n_cellgroup_id", "=", (Object)cid));
        this.deviceDao.delete(dev);
        TSyncPair TSyncPair2 = this.syncPairDao.getPairBySNCgId(sn, cid);
        if (TSyncPair2 == null) {
            return;
        }
        this.syncedPgkDao.clearBySkID(TSyncPair2.getId());
        this.syncWrapKeyDao.clearBySkID(TSyncPair2.getId());
        this.syncPairDao.clearByPair(TSyncPair2);
        RedisUtil.del((String[])new String[]{"SYNC_" + TSyncPair2.getId()});
    }

    private TCellGroup getCellGroup(String appID, String entityID) {
        return (TCellGroup)this.cellgroupDao.fetch((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_entity_id", "=", (Object)entityID));
    }

    public Map<String, Long> querycgIDsByEntityIds(String appID, List<String> entityIDs) {
        return this.cellgroupDao.queryCgIDsByEntityIds(appID, entityIDs);
    }

    public List<String> getCellGroupDatasByEntityIDs(String appID, String ... entityIDs) {
        return this.cellgroupDao.getCellGroupDatasByEntityIDs(appID, entityIDs);
    }

    private void doDeleteCellGroup(Long cellGroupID) {
        List<TSyncPair> list = this.getSyncPairByCellGroupId(cellGroupID);
        for (TSyncPair pair : list) {
            this.syncWrapKeyDao.clearBySkID(pair.getId());
            this.syncedPgkDao.clearBySkID(pair.getId());
            this.syncPairDao.clearByPair(pair);
            RedisUtil.del((String[])new String[]{"SYNC_" + pair.getId()});
        }
        try {
            TCellGroup cellGroup = (TCellGroup)this.cellgroupDao.fetch(cellGroupID);
            TCellGroupData data = (TCellGroupData)this.cellGroupDataDao.fetch(cellGroupID);
            this.chipAddRequestDao.clearByCellGroup(cellGroup.getAppID(), cellGroup.getEntityID());
            this.wrapPgkDao.clearByCellGroup(cellGroupID);
            this.clearWrapkeyBycellGroupID(cellGroupID);
            this.cellgroupDao.delete(cellGroup);
            this.cellGroupDataDao.delete(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private List<TSyncPair> getSyncPairByCellGroupId(Long cellGroupID) {
        return this.syncPairDao.getSyncPairsByCellGroupId(cellGroupID);
    }

    private void clearWrapkeyBycellGroupID(Long cellGroupID) {
        this.wrapkeyDao.clearWrapkeyBycellGroupID(cellGroupID);
    }

    private <T> T getStruct(String jsonString, Class<T> clazz) throws JSONException {
        return (T)JsonMapper.alwaysMapper().fromJson(jsonString, clazz);
    }

    public Map<String, String> getSyncPubKeyDatas(List<String> skIDs) {
        return this.syncPairDao.getSyncPubKeyDatas(skIDs);
    }

    public boolean checkEntityWrapkeyVersionIllegal(String appID, String entityId, Long ver) {
        TCellGroup cellGroup = this.getCellGroup(appID, entityId);
        return cellGroup.getWrapKeyVersion() != ver.longValue();
    }

    public List<String> queryEntityIDs(String appID, String sn) {
        return this.cellgroupDao.queryEntityIDs(appID, sn);
    }

    public String getSnByIndex(long index) {
        TChipAddRequest req = (TChipAddRequest)this.chipAddRequestDao.fetch(index);
        return req == null ? "" : req.getSn();
    }

    public void deleteDeviceSyncWkRequestBySnAndEntity(String sn, String appID, String entityID) {
        this.syncWkRequestDao.deleteDeviceSyncWkRequest(sn, appID, entityID);
    }

    public long doCreateDeviceSyncWkRequest(SourceDataStruct req) throws JSONException {
        ReqSyncWrapKey reqSyncWrapKey = (ReqSyncWrapKey)JsonMapper.alwaysMapper().fromJson(req.getInfo(), ReqSyncWrapKey.class);
        TChipSyncWKRequestData data = new TChipSyncWKRequestData(RedisUtil.incr((String)"cswkrdk"), req.toString());
        data = this.syncWkRequestDao.insert(data);
        TChipSyncWKRequest request = new TChipSyncWKRequest(data.getId(), reqSyncWrapKey.getCgID(), reqSyncWrapKey.getCiD(), reqSyncWrapKey.getSn(), reqSyncWrapKey.getAppID());
        request = this.syncWkRequestDao.insert(request);
        return request.getId();
    }

    public String getSyncWkRequestByIndex(String request_index) {
        long id = Long.valueOf(request_index);
        TChipSyncWKRequest req = this.syncWkRequestDao.query(TChipSyncWKRequest.class, id);
        TChipSyncWKRequestData data = this.syncWkRequestDao.query(TChipSyncWKRequestData.class, id);
        if (req == null || data == null) {
            return null;
        }
        return data.getData();
    }

    public boolean verifySyncPub(ReqSyncWrapKey req) throws JSONException {
        TCellGroup tCellGroup = this.getCellGroup(req.getAppID(), req.getCgID());
        if (tCellGroup == null) {
            return false;
        }
        TSyncPair pair = this.syncPairDao.getPairBySkID(req.getSkeyID());
        if (pair == null) {
            return false;
        }
        return pair.getAppID().equals(req.getAppID()) && pair.getChipID().equals(req.getCiD()) && pair.getSN().equals(req.getSn()) && pair.getPublicKey().equals(req.getSkPub());
    }

    public boolean checkSyncWkRequestByIndex(long index, String appID, String opId) {
        TChipSyncWKRequest req = this.syncWkRequestDao.query(TChipSyncWKRequest.class, index);
        return req == null || !appID.equals(req.getAppID()) || !opId.equals(req.getEntityID());
    }

    public String getSnBySyncIndex(long index) {
        TChipSyncWKRequest req = this.syncWkRequestDao.query(TChipSyncWKRequest.class, index);
        return req == null ? "" : req.getSn();
    }

    public void doSyncWrapKey(DeviceSyncWKReq req, String appID, String sn, String syncSn) throws JSONException {
        TCellGroup tCellGroup = this.getCellGroup(appID, req.getOpId());
        if (req.getCellGroup() != null) {
            TCellGroupData tCellGroupData = (TCellGroupData)this.cellGroupDataDao.fetch(tCellGroup.getId());
            tCellGroupData.setData(req.getCellGroup().toString());
            tCellGroup.setVersion(tCellGroup.getVersion() + 1L);
            this.cellGroupDataDao.update(tCellGroupData);
            this.cellgroupDao.update(tCellGroup);
        }
        Map<Long, Long> wrapKeyVer = this.getDeviceWrapKeyVersion(tCellGroup.getId(), syncSn);
        ArrayList<SyncedWrapKey> wrapkeys = new ArrayList<SyncedWrapKey>();
        for (SyncedWrapKey syncedWrapKey : req.getSyncedWrapKey()) {
            if (wrapKeyVer.containsKey(Long.parseLong(syncedWrapKey.getWkVer()))) continue;
            wrapkeys.add(syncedWrapKey);
        }
        for (SyncedWrapKey syncedWrapKey : wrapkeys) {
            TSyncWrapKeyData TSyncWrapKeyData2 = this.syncWrapKeyDao.insert(new TSyncWrapKeyData(RedisUtil.incr((String)"swkdk"), tCellGroup.getId(), syncedWrapKey.toString()));
            this.syncWrapKeyDao.insert(new TSyncWrapKey(syncedWrapKey.getSkID(), Long.valueOf(syncedWrapKey.getWkVer()), TSyncWrapKeyData2.getId()));
        }
        TDevice dev = this.deviceDao.findByEntityIdAndSN(tCellGroup.getEntityID(), sn, appID);
        TDevice syncDev = this.deviceDao.findByEntityIdAndSN(tCellGroup.getEntityID(), syncSn, appID);
        if (dev.getStart() < syncDev.getStart()) {
            syncDev.setStart(dev.getStart());
            syncDev.setStartTime(dev.getStartTime());
        }
        syncDev.setEnd(-1L);
        syncDev.setEndTime(-1L);
        if (!wrapkeys.isEmpty()) {
            this.deviceDao.update(syncDev);
        }
        this.syncWkRequestDao.delete(TChipSyncWKRequest.class, req.getIndex());
        this.syncWkRequestDao.delete(TChipSyncWKRequestData.class, req.getIndex());
        this.todoProvider.createWrapWrapKey(wrapkeys, syncSn, tCellGroup.getId(), tCellGroup.getAppID(), tCellGroup.getEntityID());
    }

    public boolean existForceAddDevice(String appID, String sn, String entityID) {
        TDevice device = this.deviceDao.findByEntityIdAndSN(entityID, sn, appID);
        return device != null && device.getAddType() == 1;
    }

    private Map<Long, Long> getDeviceWrapKeyVersion(Long cellgroupId, String SN) {
        TSyncPair pair = this.syncPairDao.getPairBySNCgId(SN, cellgroupId);
        List<TSyncWrapKey> syncedWrapKeys = this.syncWrapKeyDao.queryWrapKeysBySkID(pair.getId());
        HashMap<Long, Long> version = new HashMap<Long, Long>();
        for (TSyncWrapKey temp : syncedWrapKeys) {
            version.put(temp.getWrapKeyVersion(), temp.getWrapKeyVersion());
        }
        TKek kek = this.kekKeyDao.queryBySN(SN);
        if (kek != null) {
            HashMap<Long, Long> versions = new HashMap<Long, Long>();
            List<TKekWrapKey> kekWrapKeys = this.kekKeyDao.queryKekWrapKeyID(kek.getId());
            for (TKekWrapKey wrapkey : kekWrapKeys) {
                versions.put(wrapkey.getWrapKeyID(), wrapkey.getWrapKeyID());
            }
            List<TWrapKey> wrapkeys = this.wrapkeyDao.getByCgId(cellgroupId);
            for (TWrapKey key : wrapkeys) {
                if (!versions.containsKey(key.getId())) continue;
                version.put(key.getVersion(), key.getVersion());
            }
        }
        return version;
    }

    public Long getLastWrapVersion(String appID, String entityID) {
        TCellGroup cellGroup = this.getCellGroup(appID, entityID);
        if (cellGroup != null) {
            return cellGroup.getWrapKeyVersion();
        }
        return -1L;
    }

    public boolean checkWrapKeyVersionExist(String appID, String EntityId, long version) {
        TCellGroup cellGroup = this.getCellGroup(appID, EntityId);
        if (cellGroup != null) {
            return this.wrapkeyDao.getByCgIdAndVersion(cellGroup.getId(), version) != null;
        }
        return false;
    }

    public String getAppIDByEntityID(String entityID) {
        return this.cellgroupDao.queryAppIDByEntityID(entityID);
    }

    public Long getLastExistWrapKeyVersion(String entityID, String appID) {
        TCellGroup cellgroup = this.getCellGroup(appID, entityID);
        if (cellgroup == null) {
            this.logger.info("\u83b7\u53d6wrapKey\u5df2\u5b58\u5728\u7684\u6700\u65b0\u7248\u672c Entity\u4e0d\u5b58\u5728");
            return null;
        }
        return this.wrapkeyDao.getLastWrapKeyVersion(cellgroup.getId());
    }
}

