/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.chipCert;

import com.xdja.cssp.ums.model.Cert;
import com.xdja.cssp.ums.service.IAccountService;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.core.verify.ALG_TYPE;
import com.xdja.safecenter.secret.provider.chipCert.IChipCertProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ChipCertProviderImpl
extends AbstractProvider
implements IChipCertProvider {
    private static final int CERT_TYPE_RSA = 1;
    private static final int CERT_TYPE_SM2 = 2;
    private static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_TAIL = "-----END CERTIFICATE-----";
    private IAccountService service = (IAccountService)DefaultServiceRefer.getServiceRefer(IAccountService.class);

    public Map<String, String> queryCertsBySN(Map<String, String> snMap) {
        List sm2Certs;
        List rsaCerts;
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> snRsa = new ArrayList<String>();
        ArrayList<String> snSm2 = new ArrayList<String>();
        String certStr = "";
        for (String sn : snMap.keySet()) {
            if (ALG_TYPE.rsa.value.equals(snMap.get(sn))) {
                certStr = RedisUtil.getHash((String)"Certs", (String)(sn + "_" + 1));
                if (StringUtils.isBlank((CharSequence)certStr)) {
                    snRsa.add(sn);
                    continue;
                }
            } else if (ALG_TYPE.sm2.value.equals(snMap.get(sn)) && StringUtils.isBlank((CharSequence)(certStr = RedisUtil.getHash((String)"Certs", (String)(sn + "_" + 2))))) {
                snSm2.add(sn);
                continue;
            }
            result.put(sn, certStr);
        }
        if (!snRsa.isEmpty() && (rsaCerts = this.service.queryHisCertBySnList(snRsa, 1)) != null && !rsaCerts.isEmpty()) {
            for (Cert cert : rsaCerts) {
                result.put(cert.getSn(), cert.getCert().replace(CERT_HEAD, "").replace(CERT_TAIL, "").replaceAll("\\\\n", "").replaceAll("\\\\r", ""));
                RedisUtil.setHash((String)"Certs", (String)(cert.getSn() + "_" + 1), (String)((String)result.get(cert.getSn())));
            }
        }
        if (!snSm2.isEmpty() && (sm2Certs = this.service.queryHisCertBySnList(snSm2, 2)) != null && !sm2Certs.isEmpty()) {
            for (Cert cert : sm2Certs) {
                result.put(cert.getSn(), cert.getCert().replaceAll(CERT_HEAD, "").replaceAll(CERT_TAIL, "").replaceAll("\\\\n", "").replaceAll("\\\\r", ""));
                RedisUtil.setHash((String)"Certs", (String)(cert.getSn() + "_" + 2), (String)((String)result.get(cert.getSn())));
            }
        }
        return result;
    }
}

