/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.ciphermeta;

import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.dao.CipherMetaDao;
import com.xdja.safecenter.secret.model.TCipherMeta;
import com.xdja.safecenter.secret.provider.ciphermeta.ICipherMetaProvider;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CipherMetaProviderImpl
extends AbstractProvider
implements ICipherMetaProvider {
    @Resource
    private CipherMetaDao cipherMetaDao;

    public long saveCipherMeta(String cipherMetaData) {
        TCipherMeta cm = new TCipherMeta();
        cm.setCreateTime(System.currentTimeMillis());
        cm.setData(cipherMetaData);
        return ((TCipherMeta)this.cipherMetaDao.insert(cm)).getId();
    }

    @Cacheable(value={"cipherMetaCache"}, key="'cipherMeta:' + #cipherMetaID")
    public String get(long cipherMetaID) {
        try {
            TCipherMeta meta = (TCipherMeta)this.cipherMetaDao.fetch(cipherMetaID);
            if (meta == null) {
                this.logger.error("\u6ca1\u6709\u627e\u5230ID={}\u5bf9\u5e94\u7684\u5bc6\u6587\u5143\u6570\u636e", (Object)cipherMetaID);
                return null;
            }
            return ((TCipherMeta)this.cipherMetaDao.fetch(cipherMetaID)).getData();
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.error("\u6ca1\u6709\u627e\u5230ID={}\u5bf9\u5e94\u7684\u5bc6\u6587\u5143\u6570\u636e", (Object)cipherMetaID);
            return null;
        }
    }
}

