/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.external;

import com.xdja.safecenter.secret.bean.BackupData;
import com.xdja.safecenter.secret.dao.BackupCardDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.provider.external.IBackupDataSyncProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BackupDataSyncProviderImpl
implements IBackupDataSyncProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private BackupCardDao backupCardDao;
    @Resource
    private kekKeyDao kekKeyDao;

    public Map<String, String> doSyncBackupData(List<BackupData> datas) {
        this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u751f\u4ea7\u5907\u4efd\u6570\u636e");
        if (!this.checkParams(datas)) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> localBKeySnList = new ArrayList<String>();
        ArrayList<String> localKekIdList = new ArrayList<String>();
        HashSet<String> localSnList = new HashSet<String>();
        HashMap<String, BackupData> normalDatas = new HashMap<String, BackupData>();
        for (BackupData item : datas) {
            if (localBKeySnList.contains(item.getbKeySn())) {
                result.put(item.getChipNo(), "\u5907\u4efd\u5361\u91cd\u590d");
                continue;
            }
            if (item.getSn().equalsIgnoreCase(item.getbKeySn())) {
                result.put(item.getChipNo(), "\u5907\u4efd\u8bbe\u5907\u4e0e\u5907\u4efdKEY\u4e0d\u80fd\u76f8\u540c");
                continue;
            }
            if (localKekIdList.contains(item.getKekId())) {
                result.put(item.getChipNo(), "kekId\u91cd\u590d");
                continue;
            }
            if (item.getKekId().toLowerCase().indexOf(item.getSn().toLowerCase()) == -1) {
                result.put(item.getChipNo(), "\u5907\u4efd\u82af\u7247SN\u4e0eKekId\u4e0d\u5339\u914d");
                continue;
            }
            localBKeySnList.add(item.getbKeySn());
            localKekIdList.add(item.getKekId());
            localSnList.add(item.getSn());
            normalDatas.put(item.getbKeySn(), item);
        }
        if (localBKeySnList.isEmpty()) {
            return result;
        }
        List<String> repeatBKeySnList = this.backupCardDao.queryExistBackupKey(localBKeySnList);
        List<String> repeatSnList = this.kekKeyDao.queryExistSn(new ArrayList<String>(localSnList));
        ArrayList<BackupData> tempDatas = new ArrayList<BackupData>(normalDatas.values());
        for (BackupData item : tempDatas) {
            if (repeatBKeySnList.contains(item.getbKeySn())) {
                normalDatas.remove(item.getbKeySn());
                result.put(item.getChipNo(), "\u5907\u4efd\u5361\u91cd\u590d");
                continue;
            }
            if (!repeatSnList.contains(item.getSn())) continue;
            normalDatas.remove(item.getbKeySn());
            result.put(item.getChipNo(), "\u5907\u4efd\u8bbe\u5907KEK\u5df2\u5b58\u5728");
        }
        if (normalDatas.isEmpty()) {
            return result;
        }
        tempDatas = new ArrayList(normalDatas.values());
        this.backupCardDao.saveBackupCardBatch(tempDatas);
        this.kekKeyDao.saveKekBatch(tempDatas);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u751f\u4ea7\u5907\u4efd\u539f\u59cb\u6570\u636e\u4e3a\uff1a{}", datas);
        }
        this.logger.info("\u4fdd\u5b58\u751f\u4ea7\u5907\u4efd\u6570\u636e\u5b8c\u6210");
        return result;
    }

    private boolean checkParams(List<BackupData> datas) {
        if (null == datas || datas.isEmpty()) {
            return false;
        }
        for (BackupData item : datas) {
            if (null != item && !StringUtils.isBlank((CharSequence)item.getChipNo()) && !StringUtils.isBlank((CharSequence)item.getSn()) && !StringUtils.isBlank((CharSequence)item.getbKeySn()) && !StringUtils.isBlank((CharSequence)item.getKekId()) && null != item.getKek() && null != item.getbKek()) continue;
            return false;
        }
        return true;
    }
}

