/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.external;

import com.xdja.safecenter.secret.bean.ChipInfo;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.provider.external.IDataCleanProvider;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataCleanProviderImpl
implements IDataCleanProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private DeviceDao deviceDao;

    public void doCleanBusinessData(ChipInfo info) {
        if (null == info || StringUtils.isBlank((CharSequence)info.getSm2SignSn())) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a {}", (Object)info);
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.deviceDao.checkDeviceExist(info.getSm2SignSn().toLowerCase())) {
            this.deviceDao.updateDeviceStatus(info.getSm2SignSn().toLowerCase(), 2);
            this.logger.info("\u6e05\u9664\u4e1a\u52a1\u6570\u636e==>\u8bbe\u5907{}\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u5df2\u6ce8\u9500\u6210\u529f {}", (Object)info.getSm2SignSn(), (Object)info);
        }
    }
}

