/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.external;

import com.xdja.safecenter.secret.bean.StatisticsInfo;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.PartyGroupDao;
import com.xdja.safecenter.secret.dao.TCellgroupPartyGroupDao;
import com.xdja.safecenter.secret.dao.WrapkeyDao;
import com.xdja.safecenter.secret.provider.external.IStatisticsProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StatisticsProviderImpl
implements IStatisticsProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    CellgroupDao cellgroupDao;
    @Resource
    TCellgroupPartyGroupDao cellgroupPartyGroupDao;
    @Resource
    WrapkeyDao wrapkeyDao;
    @Resource
    PartyGroupDao partyGroupDao;

    public List<StatisticsInfo> statistics() {
        ArrayList<StatisticsInfo> result = new ArrayList<StatisticsInfo>();
        List<String> appIds = this.cellgroupDao.queryAllAppId();
        if (null == appIds || appIds.isEmpty()) {
            return result;
        }
        for (String appId : appIds) {
            List<Long> cgIds = this.cellgroupDao.queryIdsByAppId(appId);
            if (null == cgIds || cgIds.isEmpty()) continue;
            StatisticsInfo statisticsInfo = new StatisticsInfo();
            statisticsInfo.setAppId(appId);
            statisticsInfo.setEntityNum(String.valueOf(cgIds.size()));
            statisticsInfo.setWrapKeyNum(this.wrapkeyDao.queryCountsByCgIds(cgIds));
            List<String> pgIds = this.cellgroupPartyGroupDao.queryPgIdsByCgIds(cgIds);
            if (null == pgIds || pgIds.isEmpty()) {
                result.add(statisticsInfo);
                continue;
            }
            statisticsInfo.setGroupNum(String.valueOf(pgIds.size()));
            statisticsInfo.setGroupKeyNum(this.partyGroupDao.queryPgkCountsByPgIds(pgIds));
            result.add(statisticsInfo);
        }
        return result;
    }
}

