/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.partygroup;

import com.xdja.safecenter.secret.DataNotFoundException;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.dao.EntityDao;
import com.xdja.safecenter.secret.dao.PartyGroupDao;
import com.xdja.safecenter.secret.dao.SyncedPgkDao;
import com.xdja.safecenter.secret.dao.TPgkDao;
import com.xdja.safecenter.secret.dao.WrapPgkDao;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TDevice;
import com.xdja.safecenter.secret.model.TPartyGroup;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupKeyProvider;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.SyncPGKComplex;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.WrapedPartyGroupKeyBean;
import com.xdja.safecenter.secret.struct.Constants;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;

@Component
public class PartyGroupKeyProviderImpl
extends AbstractProvider
implements IPartyGroupKeyProvider {
    @Resource
    private TPgkDao pgkDao;
    @Resource
    private WrapPgkDao wrapPgkDao;
    @Resource
    private EntityDao entityDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private PartyGroupDao partyGroupDao;
    @Resource
    private SyncedPgkDao syncedPgkDao;

    public Map<Long, WrapedPgKey> getWrapedPGKData(String partyGroupID, Long cellGroupID) {
        return this.wrapPgkDao.getWrapedPGKData(partyGroupID, cellGroupID);
    }

    public Map<Long, String> getPGKDatas(String partyGroupID) {
        return this.pgkDao.getPGKDatas(partyGroupID);
    }

    public String getLatestPGKData(String partyGroupID) throws DataNotFoundException {
        try {
            return this.pgkDao.getLatestPGKData(partyGroupID);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.error("\u672a\u627e\u5230\u5171\u4eab\u5708\u3010{}\u3011\u6700\u65b0\u7248\u672c\u7684PartyGroupKey\u5143\u6570\u636e", (Object)partyGroupID);
            throw new DataNotFoundException();
        }
    }

    public List<WrapedPartyGroupKeyBean> getWrapedPgKeyDatas(String partyGroupID, String entityID, Long partyGroupKeyVersion, String appID, String sn) throws DataNotFoundException {
        ArrayList<WrapedPartyGroupKeyBean> result = new ArrayList<WrapedPartyGroupKeyBean>();
        TCellGroup cellGroup = this.entityDao.getByEntityIDAppId(entityID, appID);
        if (cellGroup == null) {
            this.logger.error("\u672a\u627e\u5230entity\u3010{}\u3011 appID\u3010{}\u3011", (Object)entityID, (Object)appID);
            return result;
        }
        long cellGroupID = cellGroup.getId();
        TDevice device = this.deviceDao.findByEntityIdAndSN(entityID, sn, appID);
        if (device == null) {
            this.logger.error("\u672a\u627e\u5230entity\u3010{}\u3011 appID\u3010{}\u3011,\u3010{}\u3011", new Object[]{entityID, appID, sn});
            return result;
        }
        if (partyGroupKeyVersion.longValue() == Constants.TYPE_NEW_WRAPPGKEY_VERSION.longValue()) {
            WrapedPgKey wrapPgk;
            try {
                wrapPgk = this.wrapPgkDao.getLatestWrapedPGKData(partyGroupID, cellGroupID);
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.error("\u672a\u627e\u5230\u4f7f\u7528\u540c\u6b65\u5708\u3010{}\u3011\u5c01\u88c5\u5bc6\u94a5\u4fdd\u62a4\u7684\u5171\u4eab\u5708\u3010{}\u3011\u6700\u65b0\u7248\u672c\u7684PartyGroupKey\u5143\u6570\u636e", (Object)entityID, (Object)partyGroupID);
                return result;
            }
            String pgk = this.getLatestPGKData(partyGroupID);
            if (this.accessAble(wrapPgk, device)) {
                result.add(new WrapedPartyGroupKeyBean(SourceDataStruct.fromJsonStr((String)pgk), wrapPgk));
            }
        } else if (partyGroupKeyVersion.longValue() == Constants.TYPE_ALL_WRAPPGKEY_VERSION.longValue()) {
            Map<Long, WrapedPgKey> wrapPgkData = this.wrapPgkDao.getWrapedPGKData(partyGroupID, cellGroupID);
            Map<Long, String> pgkData = this.getPGKDatas(partyGroupID);
            for (Map.Entry<Long, WrapedPgKey> entry : wrapPgkData.entrySet()) {
                if (pgkData.containsKey(entry.getKey())) {
                    if (!this.accessAble(entry.getValue(), device)) continue;
                    result.add(new WrapedPartyGroupKeyBean(SourceDataStruct.fromJsonStr((String)pgkData.get(entry.getKey())), entry.getValue()));
                    continue;
                }
                this.logger.error("Not Found wrapedPgkData v{} by entity{} partygroup{}", new Object[]{entry.getKey(), entityID, partyGroupID});
            }
        } else {
            String pgk;
            WrapedPgKey wrapPgk;
            try {
                wrapPgk = this.wrapPgkDao.getWrapedPGKData(partyGroupID, cellGroupID, partyGroupKeyVersion);
                if (!this.accessAble(wrapPgk, device)) {
                    return result;
                }
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.error("\u672a\u627e\u5230\u4f7f\u7528\u540c\u6b65\u5708\u3010{}\u3011\u5c01\u88c5\u5bc6\u94a5\u4fdd\u62a4\u7684\u5171\u4eab\u5708\u3010{}\u3011\u7684\u6307\u5b9a\u7248\u672c\u3010{}\u3011\u7684PartyGroupKey\u5143\u6570\u636e", new Object[]{entityID, partyGroupID, partyGroupKeyVersion});
                return result;
            }
            try {
                pgk = this.pgkDao.getPGKDataByVersion(partyGroupID, partyGroupKeyVersion);
            }
            catch (EmptyResultDataAccessException e) {
                this.logger.error("\u672a\u627e\u5230\u5171\u4eab\u5708\u3010{}\u3011\u6307\u5b9a\u7248\u672c\u3010{}\u3011\u7248\u672c\u7684PartyGroupKey\u5143\u6570\u636e", (Object)partyGroupID, (Object)partyGroupKeyVersion);
                throw new DataNotFoundException();
            }
            result.add(new WrapedPartyGroupKeyBean(SourceDataStruct.fromJsonStr((String)pgk), wrapPgk));
        }
        return result;
    }

    private boolean accessAble(WrapedPgKey wrapPgk, TDevice device) {
        if (Long.valueOf(wrapPgk.getWkVer()) >= device.getStart() && device.getEnd() == -1L) {
            return true;
        }
        return Long.valueOf(wrapPgk.getWkVer()) >= device.getStart() && Long.valueOf(wrapPgk.getWkVer()) <= device.getEnd();
    }

    public List<SyncPGKComplex> getUnwrapedPGK(String appID, String sn, String entityID, String partyGroupID, Long partyGroupKeyVersion) {
        List<SyncPGKComplex> syncedPgKeyList = new ArrayList<SyncPGKComplex>();
        TCellGroup cellGroup = this.entityDao.getByEntityIDAppId(entityID, appID);
        if (cellGroup == null) {
            return syncedPgKeyList;
        }
        if (Objects.equals(partyGroupKeyVersion, Constants.TYPE_NEW_WRAPPGKEY_VERSION)) {
            TPartyGroup partyGroup = this.partyGroupDao.queryByPartyGroupId(partyGroupID);
            if (partyGroup == null) {
                return syncedPgKeyList;
            }
            syncedPgKeyList = this.syncedPgkDao.getUnwrapedPGK(appID, sn, cellGroup.getId(), partyGroupID, partyGroup.getPgkVersion());
        } else {
            syncedPgKeyList = this.syncedPgkDao.getUnwrapedPGK(appID, sn, cellGroup.getId(), partyGroupID, partyGroupKeyVersion);
        }
        return syncedPgKeyList;
    }

    public Long getLastedPgkVersion(String partyGroupID) {
        Map<Long, Long> pgkVerion = this.partyGroupDao.getLaestVerAndPgkVer(partyGroupID);
        Long[] versions = new Long[pgkVerion.keySet().size()];
        pgkVerion.keySet().toArray(versions);
        return versions[0];
    }
}

