/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.partygroup;

import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.DestroyInfoDao;
import com.xdja.safecenter.secret.dao.EntityDao;
import com.xdja.safecenter.secret.dao.PartyGroupDao;
import com.xdja.safecenter.secret.dao.SyncedPgkDao;
import com.xdja.safecenter.secret.dao.TCellgroupPartyGroupDao;
import com.xdja.safecenter.secret.dao.TQuitInfoDao;
import com.xdja.safecenter.secret.dao.WrapPgkDao;
import com.xdja.safecenter.secret.model.TCellGroupPartyGroupRelation;
import com.xdja.safecenter.secret.model.TDestroyInfoData;
import com.xdja.safecenter.secret.model.TPartyGroup;
import com.xdja.safecenter.secret.model.TPartyGroupData;
import com.xdja.safecenter.secret.provider.partygroup.IPartyGroupProvider;
import com.xdja.safecenter.secret.provider.partygroup.bean.request.UpdatePGKBean;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.PEntityBean;
import com.xdja.safecenter.secret.provider.partygroup.exception.IllegalVersionException;
import com.xdja.safecenter.secret.provider.partygroup.exception.IsExsitException;
import com.xdja.safecenter.secret.provider.partygroup.exception.PartyGroupException;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.EntityInfo;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import com.xdja.safecenter.secret.struct.v2.PartyGroupStruct;
import com.xdja.safecenter.secret.struct.v2.QuitInfo;
import com.xdja.safecenter.secret.struct.v2.SyncedPgKey;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PartyGroupProviderImpl
extends AbstractProvider
implements IPartyGroupProvider {
    @Resource
    private PartyGroupDao partyGroupDao;
    @Resource
    private TQuitInfoDao quitInfoDao;
    @Resource
    private WrapPgkDao wrapPgkDao;
    @Resource
    private SyncedPgkDao syncedPgkDao;
    @Resource
    private TCellgroupPartyGroupDao cellgroupPartyGroupDao;
    @Resource
    private EntityDao entityDao;
    @Resource
    private CellgroupDao cellgroupDao;
    @Resource
    private ITodoProvider todoProvider;
    @Resource
    private DestroyInfoDao destroyInfoDao;

    public void create(SourceDataStruct partyGroupSData, SourceDataStruct partyGroupKeySData, List<SyncedPgKey> syncedPgKeys, WrapedPgKey wrapedPgKey, Map<String, Long> entityIDs) throws PartyGroupException, IllegalVersionException, IsExsitException {
        PartyGroupStruct partyGroupStruct = this.parsePGStruct(partyGroupSData, 0L);
        PartyGroupKey partyGroupKey = this.parsePGKStruct(partyGroupKeySData, 0L);
        if (!"0".equals(wrapedPgKey.getPgkVer())) {
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684WrapedPgKey.pgkVer\u3010%s\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u30100\u3011", wrapedPgKey.getPgkVer()));
        }
        for (SyncedPgKey syncedPgKey : syncedPgKeys) {
            if ("0".equals(syncedPgKey.getPgkVer())) continue;
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684SyncedPgKey.pgkVer\u3010%s\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u30100\u3011", syncedPgKey.getPgkVer()));
        }
        Map<Long, Long> lastVersion = this.partyGroupDao.getLaestVerAndPgkVer(partyGroupStruct.getPgID());
        if (!lastVersion.isEmpty()) {
            throw new IsExsitException("partygroup\u5df2\u5b58\u5728");
        }
        long cellGroupID = this.entityDao.getByEntityIDAppId(wrapedPgKey.getCgID(), partyGroupStruct.getAppID()).getId();
        this.wrapPgkDao.save(wrapedPgKey, wrapedPgKey.toString(), cellGroupID);
        this.saveSyncedPgk(syncedPgKeys, entityIDs);
        TPartyGroup pg = new TPartyGroup();
        pg.setPartyGroupID(partyGroupStruct.getPgID());
        pg.setVersion(Long.parseLong(partyGroupStruct.getPgVer()));
        this.partyGroupDao.savePartyGroup(pg, partyGroupSData.toString(), partyGroupKey, partyGroupKeySData.toString());
        this.cellgroupPartyGroupDao.save(this.assembelTCellGroupPartyGroupRelation(partyGroupStruct.getPgID(), (List)partyGroupStruct.getCgIDs().get(partyGroupStruct.getAppID()), entityIDs));
        try {
            this.todoProvider.createGetLastPgk(partyGroupKeySData, wrapedPgKey, partyGroupStruct.getAppID(), partyGroupKey.getSn());
            this.todoProvider.createWrapPgk(syncedPgKeys, partyGroupKeySData);
        }
        catch (JSONException e) {
            throw new PartyGroupException("\u89e3\u6790PGK\u7ed3\u6784\u4f53\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private List<TCellGroupPartyGroupRelation> assembelTCellGroupPartyGroupRelation(String pgID, List<EntityInfo> infos, Map<String, Long> entityIDs) {
        ArrayList<TCellGroupPartyGroupRelation> list = new ArrayList<TCellGroupPartyGroupRelation>();
        for (EntityInfo bean : infos) {
            TCellGroupPartyGroupRelation relation = new TCellGroupPartyGroupRelation();
            relation.setPartyGroupID(pgID);
            relation.setAddDevID(bean.getAdID());
            relation.setCellGroupID(entityIDs.get(bean.getCgID()));
            relation.setAddTime(System.currentTimeMillis());
            list.add(relation);
        }
        return list;
    }

    public void addEntity(String partyGroupID, SourceDataStruct partyGroupSData, List<String> cellGroupIDs, List<SyncedPgKey> syncedPgKeys, Map<String, Long> entityIDs, String sn) throws PartyGroupException, IllegalVersionException, IsExsitException {
        Map<Long, Long> pgVerAndPgkVer = this.partyGroupDao.getLaestVerAndPgkVer(partyGroupID);
        long pgkVersion = pgVerAndPgkVer.keySet().iterator().next();
        PartyGroupStruct partyGroupStruct = this.parsePGStruct(partyGroupSData, pgVerAndPgkVer.get(pgkVersion) + 1L);
        List<Long> pgkVersions = this.partyGroupDao.getAllVerAndPgkVer(partyGroupID);
        for (Long l : pgkVersions) {
            pgVerAndPgkVer.put(l, l);
        }
        this.verifySyncPgkVersion(syncedPgKeys, pgVerAndPgkVer);
        this.saveSyncedPgk(syncedPgKeys, entityIDs);
        TPartyGroup pg = new TPartyGroup();
        pg.setPartyGroupID(partyGroupID);
        pg.setVersion(Long.parseLong(partyGroupStruct.getPgVer()));
        this.partyGroupDao.updatePartyGroup(pg, partyGroupSData.toString());
        for (String existEntityID : this.cellgroupPartyGroupDao.queryEntityIDs(partyGroupID)) {
            if (!cellGroupIDs.contains(existEntityID)) continue;
            throw new IsExsitException(String.format("entity\u5df2\u5728\u5171\u4eab\u5708\u5185 entityID\u3010%s\u3011 pgID\u3010%s\u3011", existEntityID, partyGroupID));
        }
        this.cellgroupPartyGroupDao.save(this.assembelTPartyGroupRelation(partyGroupID, cellGroupIDs, entityIDs, sn));
        try {
            this.todoProvider.createWrapPgk(syncedPgKeys);
        }
        catch (JSONException jSONException) {
            throw new PartyGroupException("\u89e3\u6790PGK\u7ed3\u6784\u4f53\u5143\u6570\u636e\u5931\u8d25", (Throwable)jSONException);
        }
    }

    private List<TCellGroupPartyGroupRelation> assembelTPartyGroupRelation(String pgID, List<String> cgIDs, Map<String, Long> entityIDs, String sn) {
        ArrayList<TCellGroupPartyGroupRelation> list = new ArrayList<TCellGroupPartyGroupRelation>();
        for (String cgID : cgIDs) {
            TCellGroupPartyGroupRelation relation = new TCellGroupPartyGroupRelation();
            relation.setPartyGroupID(pgID);
            relation.setAddDevID(sn);
            relation.setCellGroupID(entityIDs.get(cgID));
            relation.setAddTime(System.currentTimeMillis());
            list.add(relation);
        }
        return list;
    }

    public void removeEntity(String partyGroupID, SourceDataStruct partyGroupSData, SourceDataStruct partyGroupKeySData, List<SyncedPgKey> syncedPgKeys, WrapedPgKey wrapedPgKey, String sn, List<String> opEntities) throws PartyGroupException, IllegalVersionException {
        Map<Long, Long> pgVerAndPgkVer = this.partyGroupDao.getLaestVerAndPgkVer(partyGroupID);
        long pgkVersion = pgVerAndPgkVer.keySet().iterator().next();
        PartyGroupStruct partyGroupStruct = this.parsePGStruct(partyGroupSData, pgVerAndPgkVer.get(pgkVersion) + 1L);
        if (!wrapedPgKey.getPgkVer().equals(pgkVersion + 1L + "")) {
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684wrapPgk\u7248\u672c\u53f7\u3010%d\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u3010%d\u3011", Long.valueOf(wrapedPgKey.getPgkVer()), pgkVersion + 1L));
        }
        PartyGroupKey partyGroupKey = this.parsePGKStruct(partyGroupKeySData, null);
        long cellGroupID = this.entityDao.getByEntityIDAppId(wrapedPgKey.getCgID(), partyGroupStruct.getAppID()).getId();
        this.wrapPgkDao.save(wrapedPgKey, wrapedPgKey.toString(), cellGroupID);
        pgVerAndPgkVer.put(pgkVersion + 1L, pgVerAndPgkVer.get(pgkVersion));
        pgVerAndPgkVer.remove(pgkVersion);
        this.verifySyncPgkVersion(syncedPgKeys, pgVerAndPgkVer);
        ArrayList<String> ids = new ArrayList<String>();
        for (EntityInfo bean : (List)partyGroupStruct.getCgIDs().get(partyGroupStruct.getAppID())) {
            ids.add(bean.getCgID());
        }
        Map<String, Long> entityIDs = this.queryCgIDsByEntityIds(partyGroupStruct.getAppID(), ids);
        Map<String, Long> delIDs = this.queryCgIDsByEntityIds(partyGroupStruct.getAppID(), opEntities);
        this.saveSyncedPgk(syncedPgKeys, entityIDs);
        TPartyGroup pg = new TPartyGroup();
        pg.setPartyGroupID(partyGroupID);
        pg.setVersion(Long.parseLong(partyGroupStruct.getPgVer()));
        this.partyGroupDao.updatePartyGroup(pg, partyGroupSData.toString(), partyGroupKey, partyGroupKeySData.toString());
        this.cellgroupPartyGroupDao.delete(partyGroupID, new ArrayList<Long>(delIDs.values()));
        this.syncedPgkDao.clearByCellGroupIdsAndPgId(partyGroupID, new ArrayList<Long>(delIDs.values()));
        this.wrapPgkDao.delete(partyGroupID, new ArrayList<Long>(delIDs.values()));
        try {
            this.todoProvider.deleteTodosByEntityAndGroup(partyGroupStruct.getAppID(), partyGroupID, new HashSet<String>(opEntities), false);
            this.todoProvider.createGetLastPgk(partyGroupKeySData, wrapedPgKey, partyGroupStruct.getAppID(), sn);
            this.todoProvider.createWrapPgk(syncedPgKeys, partyGroupKeySData);
        }
        catch (JSONException e) {
            throw new PartyGroupException("\u89e3\u6790PGK\u7ed3\u6784\u4f53\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, Long> queryCgIDsByEntityIds(String appID, List<String> entityIDs) {
        return this.cellgroupDao.queryCgIDsByEntityIds(appID, entityIDs);
    }

    private PartyGroupStruct parsePGStruct(SourceDataStruct sdStruct, long expectVersion) throws PartyGroupException, IllegalVersionException {
        PartyGroupStruct partyGroupStruct;
        try {
            partyGroupStruct = (PartyGroupStruct)JsonMapper.alwaysMapper().fromJson(sdStruct.getInfo(), PartyGroupStruct.class);
            long aucualVersion = Long.parseLong(partyGroupStruct.getPgVer());
            if (aucualVersion != expectVersion) {
                throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684PartyGroup\u7248\u672c\u53f7\u3010%d\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u3010%d\u3011", aucualVersion, expectVersion));
            }
        }
        catch (JSONException e) {
            throw new PartyGroupException("\u89e3\u6790PartyGroup\u7ed3\u6784\u4f53\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return partyGroupStruct;
    }

    private void verifySyncPgkVersion(List<SyncedPgKey> syncedPgKeys, Map<Long, Long> pgVerAndPgkVer) throws IllegalVersionException {
        for (SyncedPgKey syncedPgKey : syncedPgKeys) {
            if (pgVerAndPgkVer.containsKey(Long.valueOf(syncedPgKey.getPgkVer()))) continue;
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684syncPgkVersion\u7248\u672c\u53f7\u3010%d\u3011\u65e0\u6548", Long.valueOf(syncedPgKey.getPgkVer())));
        }
    }

    private PartyGroupKey parsePGKStruct(SourceDataStruct sdStruct, Long expectVersion) throws PartyGroupException, IllegalVersionException {
        PartyGroupKey partyGroupKey;
        try {
            partyGroupKey = (PartyGroupKey)JsonMapper.alwaysMapper().fromJson(sdStruct.getInfo(), PartyGroupKey.class);
            long aucualVersion = Long.parseLong(partyGroupKey.getPgkVer());
            if (expectVersion != null && aucualVersion != expectVersion) {
                throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684PartyGroupKey\u7248\u672c\u53f7\u3010%d\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u3010%d\u3011", aucualVersion, expectVersion));
            }
        }
        catch (JSONException e) {
            throw new PartyGroupException("\u89e3\u6790PartyGroupKey\u7ed3\u6784\u4f53\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return partyGroupKey;
    }

    public void doQuit(QuitInfo info, SourceDataStruct sQuit, PartyGroupStruct partyGroup, SourceDataStruct sPartyGroup) throws IllegalVersionException, JSONException {
        String partyGroupID = info.getId();
        long cellGroupID = this.entityDao.getByEntityIDAppId(info.getCgID(), info.getAppID()).getId();
        this.quitInfoDao.save(sQuit.toString());
        Map<Long, Long> pgVerAndPgkVer = this.partyGroupDao.getLaestVerAndPgkVer(partyGroupID);
        Long pgVer = pgVerAndPgkVer.get(pgVerAndPgkVer.keySet().iterator().next());
        if (Long.parseLong(partyGroup.getPgVer()) != pgVer + 1L) {
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684partyGroup\u7248\u672c\u53f7\u3010%s\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u3010%d\u3011", partyGroup.getPgVer(), pgVer + 1L));
        }
        TPartyGroup pg = new TPartyGroup();
        pg.setPartyGroupID(partyGroupID);
        pg.setVersion(Long.parseLong(partyGroup.getPgVer()));
        this.partyGroupDao.updatePartyGroup(pg, sPartyGroup.toString());
        ArrayList<Long> cgIds = new ArrayList<Long>();
        cgIds.add(cellGroupID);
        this.syncedPgkDao.clearByCellGroupIdsAndPgId(partyGroupID, cgIds);
        this.wrapPgkDao.delete(partyGroupID, cgIds);
        this.cellgroupPartyGroupDao.delete(partyGroupID, cgIds);
        this.todoProvider.deleteTodosByEntityAndGroup(info.getAppID(), partyGroupID, Collections.singleton(info.getCgID()), true);
        this.todoProvider.createUpdatePgkForGroup(partyGroupID, info.getAppID(), cellGroupID);
    }

    public void doUpdatePGK(String appID, UpdatePGKBean updateBean, Map<String, Long> entityIDs, String sn) throws PartyGroupException, IllegalVersionException, JSONException {
        Map<Long, Long> pgVerAndPgkVer = this.partyGroupDao.getLaestVerAndPgkVer(updateBean.getWrapedPgKey().getPgID());
        long pgkVersion = pgVerAndPgkVer.keySet().iterator().next();
        if (!updateBean.getWrapedPgKey().getPgkVer().equals(pgkVersion + 1L + "")) {
            throw new IllegalVersionException(String.format("\u4e0a\u4f20\u7684wrapPgk\u7248\u672c\u53f7\u3010%d\u3011\u65e0\u6548\uff0c\u5e94\u8be5\u4e3a\u3010%d\u3011", Long.valueOf(updateBean.getWrapedPgKey().getPgkVer()), pgkVersion + 1L));
        }
        PartyGroupKey partyGroupKey = this.parsePGKStruct(updateBean.getPartyGroupKey(), pgkVersion + 1L);
        long cellGroupID = this.entityDao.getByEntityIDAppId(updateBean.getWrapedPgKey().getCgID(), appID).getId();
        this.wrapPgkDao.save(updateBean.getWrapedPgKey(), updateBean.getWrapedPgKey().toString(), cellGroupID);
        pgVerAndPgkVer.put(pgkVersion + 1L, pgVerAndPgkVer.get(pgkVersion));
        pgVerAndPgkVer.remove(pgkVersion);
        this.verifySyncPgkVersion(updateBean.getSyncedPgKey(), pgVerAndPgkVer);
        this.saveSyncedPgk(updateBean.getSyncedPgKey(), entityIDs);
        this.partyGroupDao.updatePartyGroup(partyGroupKey, updateBean.getPartyGroupKey().toString());
        this.todoProvider.createGetLastPgk(updateBean.getPartyGroupKey(), updateBean.getWrapedPgKey(), appID, sn);
        this.todoProvider.createWrapPgk(updateBean.getSyncedPgKey(), updateBean.getPartyGroupKey());
    }

    private void saveSyncedPgk(List<SyncedPgKey> syncedPgKeys, Map<String, Long> entityIDs) {
        for (SyncedPgKey syncedPgKey : syncedPgKeys) {
            this.syncedPgkDao.save(RedisUtil.incr((String)"spdk"), syncedPgKey, syncedPgKey.toString(), entityIDs.get(syncedPgKey.getCgID()));
        }
    }

    public List<String> queryEntityIDsByPartyGroupID(String partyGroupID) {
        return this.cellgroupPartyGroupDao.queryEntityIDs(partyGroupID);
    }

    public String getPartyGroupData(String partyGroupID) {
        Long pgDataID = this.partyGroupDao.getPgDataId(partyGroupID);
        if (pgDataID == null) {
            return null;
        }
        return this.partyGroupDao.query(TPartyGroupData.class, pgDataID).getData();
    }

    public void doDestroy(String partyGroupID, String destoryInfo) {
        if (!StrKit.isBlank((String)destoryInfo)) {
            this.destroyInfoDao.insert(new TDestroyInfoData(RedisUtil.incr((String)"didk"), destoryInfo));
        }
        try {
            this.syncedPgkDao.clear(partyGroupID);
            this.wrapPgkDao.clearBypartyGroupID(partyGroupID);
            this.cellgroupPartyGroupDao.clearByPartyGroupId(partyGroupID);
            this.partyGroupDao.clear(partyGroupID);
            this.todoProvider.deleteTodosByGroup(partyGroupID);
        }
        catch (Exception e) {
            this.logger.error("destroy partyGroup db operation exception", (Throwable)e);
            throw e;
        }
    }

    public boolean isExsitCellGroupPartyGroup(String entityID, String pgID) {
        List<String> entityIDs = this.cellgroupPartyGroupDao.queryEntityIDs(pgID);
        return entityIDs.contains(entityID);
    }

    public boolean lock(String partyGroupID) {
        return RedisUtil.lock((String)("lp:" + partyGroupID));
    }

    public void unlock(String partyGroupID) {
        RedisUtil.del((String[])new String[]{"lp:" + partyGroupID});
    }

    public boolean existPartyGroup(String partyGroupID) {
        return this.partyGroupDao.existPartyGroup(partyGroupID);
    }

    public Map<String, List<String>> queryPartyGroupIDsByEntityIDs(String appID, List<String> entityIDs) {
        return this.cellgroupPartyGroupDao.queryPartyGroupIDsByEntityIDs(appID, entityIDs);
    }

    public Map<String, List<PEntityBean>> queryEntitiesByPartyGroupID(String partyGroupID) {
        return this.cellgroupPartyGroupDao.queryEntitiesByPartyGroupID(partyGroupID);
    }

    public boolean lockWrapPgkVersion(String partyGroupId, String entityId, String pgkVersion) {
        String key = partyGroupId + entityId + pgkVersion;
        return RedisUtil.lock((String)key);
    }

    public void unLockWrapPgkVersion(String partyGroupId, String entityId, String pgkVersion) {
        String key = partyGroupId + entityId + pgkVersion;
        RedisUtil.del((String[])new String[]{key});
    }
}

