/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.todo;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.oauth.service.pojo.AppInfo;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.CellGroupDataDao;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.dao.EntityDao;
import com.xdja.safecenter.secret.dao.MissionDao;
import com.xdja.safecenter.secret.dao.MissionDataDao;
import com.xdja.safecenter.secret.dao.PartyGroupDao;
import com.xdja.safecenter.secret.dao.SyncPairDao;
import com.xdja.safecenter.secret.dao.SyncWrapKeyDao;
import com.xdja.safecenter.secret.dao.SyncedPgkDao;
import com.xdja.safecenter.secret.dao.TCellgroupPartyGroupDao;
import com.xdja.safecenter.secret.dao.TPgkDao;
import com.xdja.safecenter.secret.dao.WrapPgkDao;
import com.xdja.safecenter.secret.dao.WrapkeyDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TCellGroupData;
import com.xdja.safecenter.secret.model.TCellGroupPartyGroupRelation;
import com.xdja.safecenter.secret.model.TDevice;
import com.xdja.safecenter.secret.model.TKekWrapKey;
import com.xdja.safecenter.secret.model.TMission;
import com.xdja.safecenter.secret.model.TMissionData;
import com.xdja.safecenter.secret.model.TPartyGroup;
import com.xdja.safecenter.secret.model.TPgkData;
import com.xdja.safecenter.secret.model.TSyncPair;
import com.xdja.safecenter.secret.model.TSyncWrapKey;
import com.xdja.safecenter.secret.model.TSyncWrapKeyData;
import com.xdja.safecenter.secret.model.TWrapKey;
import com.xdja.safecenter.secret.model.TWrapKeyData;
import com.xdja.safecenter.secret.provider.open.IOpenServiceProvider;
import com.xdja.safecenter.secret.provider.todo.ITodoProvider;
import com.xdja.safecenter.secret.provider.todo.bean.request.KekWrapKeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdatePgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.UpdateWrapkeyReq;
import com.xdja.safecenter.secret.provider.todo.bean.request.WrapPgkReq;
import com.xdja.safecenter.secret.provider.todo.bean.struct.GetLastPgkData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.RestoreWrapKeyData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.RestoreWrapPgkData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.TodoStruct;
import com.xdja.safecenter.secret.provider.todo.bean.struct.TodoStructRestore;
import com.xdja.safecenter.secret.provider.todo.bean.struct.UpdatePgkData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.WrapKeyData;
import com.xdja.safecenter.secret.provider.todo.bean.struct.WrapPgkData;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import com.xdja.safecenter.secret.struct.v2.PartyGroupKey;
import com.xdja.safecenter.secret.struct.v2.SyncedPgKey;
import com.xdja.safecenter.secret.struct.v2.SyncedWrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapKey;
import com.xdja.safecenter.secret.struct.v2.WrapedPgKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;

@Component
public class TodoProviderImpl
extends AbstractProvider
implements ITodoProvider {
    public static final String CELL_GROUP = "cellGroup";
    @Resource
    private IOpenServiceProvider openServiceProvider;
    @Resource
    private MissionDao missionDao;
    @Resource
    private MissionDataDao missionDataDao;
    @Resource
    private TPgkDao pgkDao;
    @Resource
    private PartyGroupDao partyGroupDao;
    @Resource
    private WrapPgkDao wrapPgkDao;
    @Resource
    private SyncedPgkDao syncedPgkDao;
    @Resource
    private EntityDao entityDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private SyncPairDao syncPairDao;
    @Resource
    private WrapkeyDao wrapkeyDao;
    @Resource
    private TCellgroupPartyGroupDao cellgroupPartyGroupDao;
    @Resource
    private CellgroupDao cellgroupDao;
    @Resource
    private SyncWrapKeyDao syncWrapKeyDao;
    @Resource
    private CellGroupDataDao cellGroupDataDao;
    @Resource
    private kekKeyDao kekKeyDao;
    private static Logger logger = LoggerFactory.getLogger(TodoProviderImpl.class);

    public List<TodoStruct> getMissionsByDevice(String sn, String appID, String entityId, String type) {
        List<TMission> missions = StringUtils.isNotEmpty((CharSequence)entityId) && StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)appID) ? this.missionDao.getMissionsByEntityAndType(sn, appID, entityId, type) : this.missionDao.getMissionsBySns(sn, appID);
        return this.getTodoDatas(missions, false);
    }

    private List<TodoStruct> getTodoDatas(List<TMission> missions, boolean isRestore) {
        ArrayList<TodoStruct> re = new ArrayList<TodoStruct>();
        for (TMission mission : missions) {
            String data = RedisUtil.get((String)("mdata_" + mission.getMid()));
            if (StringUtils.isBlank((CharSequence)data)) {
                TMissionData missionData = this.missionDataDao.query(TMissionData.class, mission.getMid());
                if (missionData != null) {
                    data = missionData.getData();
                } else {
                    logger.error("missionData not found id:" + mission.getMid() + " missionId:" + mission.getId());
                }
            }
            if (!isRestore) {
                re.add(new TodoStruct(mission.getMid(), mission.getType(), mission.getAppID(), this.convertByType(mission.getType(), data, mission.getEntityId())));
                continue;
            }
            AppInfo appInfo = (AppInfo)this.openServiceProvider.getAppInfo(new String[]{mission.getAppID()}).get(mission.getAppID());
            if (appInfo == null) {
                logger.error("\u8c03\u7528\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u672a\u67e5\u8be2\u5230\u4ee3\u529e\u4e8b\u9879mid\u3010{}\u3011\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f,\u5e94\u7528id\u3010{}\u3011", (Object)mission.getMid(), (Object)mission.getAppID());
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u4ee3\u529e\u4e8b\u9879\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f");
            }
            re.add((TodoStruct)new TodoStructRestore(mission.getMid(), mission.getType(), mission.getAppID(), this.convertByType(mission.getType(), data, mission.getEntityId()), ((AppInfo)this.openServiceProvider.getAppInfo(new String[]{mission.getAppID()}).get(mission.getAppID())).getSuit()));
        }
        return re;
    }

    public void doCompleteMissions(List<String> mids) {
        this.missionDao.deleteByMids(mids);
    }

    public void createWrapWrapKey(List<SyncedWrapKey> syncedWrapKeys, String sn, long cid, String appID, String entityId) throws JSONException {
        for (SyncedWrapKey wrapKey : syncedWrapKeys) {
            WrapKeyData wkData = new WrapKeyData();
            TWrapKey wk = this.wrapkeyDao.getByCgIdAndVersion(cid, Long.parseLong(wrapKey.getWkVer()));
            if (wk == null) {
                logger.error("SyncedWrapKey \u65e0\u6cd5\u5339\u914d\u67e5\u8be2\u5230 WrapKey,cId[{}],Ver[{}]", (Object)cid, (Object)wrapKey.getWkVer());
                continue;
            }
            TWrapKeyData data = this.wrapkeyDao.query(TWrapKeyData.class, wk.getId());
            if (data == null) {
                logger.error("WrapKey \u65e0\u6cd5\u5339\u914d\u67e5\u8be2\u5230 WrapKeyData");
                continue;
            }
            wkData.setWrapKey((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(data.getData(), SourceDataStruct.class));
            wkData.setSyncedWrapKey(wrapKey);
            this.saveTodo(appID, 4, wkData, sn, entityId, null, null);
        }
    }

    public void createWrapWrapKeyForOldDevice(List<SyncedWrapKey> syncedWrapKeys, SourceDataStruct wrapKey, String appID, String entityId) throws JSONException {
        for (SyncedWrapKey syncedWrapKey : syncedWrapKeys) {
            WrapKeyData wkData = new WrapKeyData();
            wkData.setWrapKey(wrapKey);
            wkData.setSyncedWrapKey(syncedWrapKey);
            TSyncPair syncPair = this.syncPairDao.getPairBySkID(syncedWrapKey.getSkID());
            if (syncPair == null) {
                logger.error("SyncedWrapKey \u65e0\u6cd5\u5339\u914d\u67e5\u8be2\u5230 syncPair");
                continue;
            }
            this.cleanGetLastWrapKey(appID, syncPair.getSN(), entityId);
            this.saveTodo(appID, 4, wkData, syncPair.getSN(), entityId, null, null);
        }
    }

    private void cleanGetLastWrapKey(String appID, String sn, String entityId) {
        List<TMission> missions = this.missionDao.getMissionsByEntityAndType(sn, appID, entityId, String.valueOf(1));
        this.deleteMissions(missions);
    }

    public void createUpdatePgk(long cid, String appId) throws JSONException {
        List relations = this.cellgroupPartyGroupDao.query((Condition)Cnd.where((String)"n_cellgroup_id", (String)"=", (Object)cid));
        for (TCellGroupPartyGroupRelation relation : relations) {
            this.deleteUpdatePgkTodos(appId, relation.getPartyGroupID());
            this.createUpdatePgkByGroupID(appId, relation.getPartyGroupID(), null);
        }
    }

    private void createUpdatePgkByGroupID(String appId, String gid, Long cellGroupID) throws JSONException {
        List cellGroups = this.cellgroupPartyGroupDao.query((Condition)Cnd.where((String)"c_partygroup_id", (String)"=", (Object)gid));
        Long mid = RedisUtil.incr((String)"todo:i:");
        for (TCellGroupPartyGroupRelation cell : cellGroups) {
            if (cellGroupID != null && cellGroupID.longValue() == cell.getCellGroupID()) continue;
            List<String> sns = this.deviceDao.getDeviceSNByCgID(cell.getCellGroupID());
            TCellGroup cellGroup = (TCellGroup)this.cellgroupDao.fetch(cell.getCellGroupID());
            for (String sn : sns) {
                this.saveTodo(appId, 2, new UpdatePgkData(gid, cellGroup.getEntityID()), sn, cellGroup.getEntityID(), gid, mid);
            }
        }
    }

    public void deleteTodosByEntityAndSn(String appID, String entityID, String sn) {
        List missions = this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_entity_id", "=", (Object)entityID).and("c_sn", "=", (Object)sn));
        this.deleteMissionsWithoutData(missions);
    }

    public void createUpdateWrapKey(SourceDataStruct cellGroupStruct, String appId, String entityId, String sn) throws JSONException {
        List<TDevice> deviceList = this.deviceDao.getDevices(entityId, appId);
        Long mid = RedisUtil.incr((String)"todo:i:");
        for (TDevice t : deviceList) {
            if (t.getSn().equals(sn)) continue;
            HashMap<String, SourceDataStruct> map = new HashMap<String, SourceDataStruct>();
            map.put(CELL_GROUP, cellGroupStruct);
            this.saveTodo(appId, 0, map, t.getSn(), entityId, null, mid);
        }
    }

    public void deleteTodosByEntity(String appId, String entityId) {
        List missions = this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appId).and("c_entity_id", "=", (Object)entityId));
        if (missions.size() > 0) {
            this.deleteMissionsWithoutData(missions);
        }
    }

    public void createWrapPgk(List<SyncedPgKey> syncedPgKeys) throws JSONException {
        for (SyncedPgKey syncedPgKey : syncedPgKeys) {
            WrapPgkData wrapPgkData = new WrapPgkData();
            wrapPgkData.setSyncedPgKey(syncedPgKey);
            TSyncPair pair = this.syncPairDao.getPairBySkID(syncedPgKey.getSkID());
            String pgkData = this.pgkDao.getPGKDataByVersion(syncedPgKey.getPgID(), Long.valueOf(syncedPgKey.getPgkVer()));
            wrapPgkData.setPartyGroupKey((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(pgkData, SourceDataStruct.class));
            this.saveTodo(pair.getAppID(), 5, wrapPgkData, pair.getSN(), syncedPgKey.getCgID(), syncedPgKey.getPgID(), RedisUtil.incr((String)"todo:i:"));
        }
    }

    public void createWrapPgk(List<SyncedPgKey> syncedPgKeys, SourceDataStruct PgKey) throws JSONException {
        for (SyncedPgKey syncedPgKey : syncedPgKeys) {
            WrapPgkData wrapPgkData = new WrapPgkData();
            wrapPgkData.setSyncedPgKey(syncedPgKey);
            TSyncPair pair = this.syncPairDao.getPairBySkID(syncedPgKey.getSkID());
            wrapPgkData.setPartyGroupKey(PgKey);
            GetLastPgkData data = new GetLastPgkData();
            data.setPartyGroupKey(PgKey);
            data.setSyncedPgKey(syncedPgKey);
            this.deleteMissions(this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)pair.getAppID()).and("c_partygroup_id", "=", (Object)syncedPgKey.getPgID()).and("c_sn", "=", (Object)pair.getSN()).and("n_type", "=", (Object)3)));
            this.saveTodo(pair.getAppID(), 5, wrapPgkData, pair.getSN(), syncedPgKey.getCgID(), syncedPgKey.getPgID(), RedisUtil.incr((String)"todo:i:"));
        }
    }

    public void deleteTodosByEntityAndGroup(String appID, String partyGroupId, Set<String> entities, boolean flag) {
        ArrayList<TMission> missions = new ArrayList<TMission>();
        missions.addAll(this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_partygroup_id", "=", (Object)partyGroupId).and("c_entity_id", "in", entities)));
        if (flag) {
            missions.addAll(this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_partygroup_id", "=", (Object)partyGroupId).and("n_type", "=", (Object)2)));
        }
        this.deleteMissions(missions);
    }

    private void createGetLastPgkMission(SourceDataStruct partyGroupKeySData, WrapedPgKey wrapedPgKey, String sn, String appId) throws JSONException {
        this.deleteMissions(this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appId).and("c_partygroup_id", "=", (Object)wrapedPgKey.getPgID()).and("c_sn", "=", (Object)sn).and("n_type", "=", (Object)3)));
        GetLastPgkData data = new GetLastPgkData();
        data.setPartyGroupKey(partyGroupKeySData);
        data.setWrapedPgKey(wrapedPgKey);
        this.saveTodo(appId, 3, data, sn, wrapedPgKey.getCgID(), wrapedPgKey.getPgID(), null);
    }

    public void createUpdatePgkForGroup(String partyGroupID, String appID, long cellGroupID) throws JSONException {
        this.createUpdatePgkByGroupID(appID, partyGroupID, cellGroupID);
    }

    public void deleteTodosByGroup(String partyGroupID) {
        this.deleteMissions(this.missionDao.query((Condition)Cnd.where((String)"c_partygroup_id", (String)"=", (Object)partyGroupID)));
    }

    public List<TodoStruct> getMissionsByGetEntity(String sn, String appID, String entityID, boolean wrapPgkFlag) {
        List<TMission> missions = this.missionDao.getMissionsByGetEntity(sn, appID, entityID, wrapPgkFlag);
        return this.getTodoDatas(missions, false);
    }

    private void deleteMissions(List<TMission> missions) {
        Map<String, List<Long>> Ids = this.getIds(missions);
        this.missionDao.deleteMissions(Ids.get("mid"));
        this.missionDataDao.deleteMissions(Ids.get("did"));
        if (Ids.get("did") != null && !Ids.get("did").isEmpty()) {
            String[] mids = new String[Ids.get("did").size()];
            int i = 0;
            for (Long id : Ids.get("did")) {
                mids[i++] = id.toString();
            }
            this.clearMissionCacheData(mids);
        }
    }

    private void deleteMissionsWithoutData(List<TMission> missions) {
        Map<String, List<Long>> Ids = this.getIds(missions);
        this.missionDao.deleteMissions(Ids.get("mid"));
    }

    private Map<String, List<Long>> getIds(List<TMission> missions) {
        HashMap<String, List<Long>> ids = new HashMap<String, List<Long>>();
        for (TMission m : missions) {
            ArrayList<Long> list;
            if (ids.containsKey("mid")) {
                ((List)ids.get("mid")).add(m.getId());
            } else {
                list = new ArrayList<Long>();
                list.add(m.getId());
                ids.put("mid", list);
            }
            if (ids.containsKey("did")) {
                ((List)ids.get("did")).add(m.getMid());
                continue;
            }
            list = new ArrayList();
            list.add(m.getMid());
            ids.put("did", list);
        }
        return ids;
    }

    private void saveTodo(String appId, int type, Object data, String sn, String entityId, String groupId, Long mid) throws JSONException {
        if (mid == null) {
            mid = RedisUtil.incr((String)"todo:i:");
        }
        TMission mission = new TMission();
        mission.setAppID(appId);
        mission.setType(type);
        mission.setMid(mid);
        mission.setSn(sn);
        mission.setCreateTime(System.currentTimeMillis());
        mission.setEntityId(StringUtils.isEmpty((CharSequence)entityId) ? "" : entityId);
        mission.setPartyGroupId(StringUtils.isEmpty((CharSequence)groupId) ? "" : groupId);
        this.missionDao.insert(mission);
        TMissionData mData = new TMissionData();
        mData.setId(mid);
        mData.setData(JsonMapper.alwaysMapper().toJson(data));
        if (this.missionDataDao.query(TMissionData.class, mid) == null) {
            this.daoTemplate.insert((Object)mData);
        }
        if (StringUtils.isBlank((CharSequence)RedisUtil.get((String)("mdata_" + mid)))) {
            RedisUtil.set((String)("mdata_" + mid), (String)JsonMapper.alwaysMapper().toJson(data));
        }
    }

    private Object convertByType(int type, String data, String entityId) {
        try {
            switch (type) {
                case 0: {
                    return JsonMapper.alwaysMapper().fromJson(data, HashMap.class);
                }
                case 1: {
                    return JsonMapper.alwaysMapper().fromJson(data, WrapKeyData.class);
                }
                case 2: {
                    UpdatePgkData updatePgkData = this.wrapUpdatePgkData((UpdatePgkData)JsonMapper.alwaysMapper().fromJson(data, UpdatePgkData.class));
                    updatePgkData.setEntityId(entityId);
                    return updatePgkData;
                }
                case 3: {
                    return JsonMapper.alwaysMapper().fromJson(data, GetLastPgkData.class);
                }
                case 4: {
                    return JsonMapper.alwaysMapper().fromJson(data, WrapKeyData.class);
                }
                case 5: {
                    return JsonMapper.alwaysMapper().fromJson(data, WrapPgkData.class);
                }
                case 6: {
                    return JsonMapper.alwaysMapper().fromJson(data, RestoreWrapKeyData.class);
                }
                case 7: {
                    return JsonMapper.alwaysMapper().fromJson(data, RestoreWrapPgkData.class);
                }
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private UpdatePgkData wrapUpdatePgkData(UpdatePgkData up) throws JSONException {
        List<Long> dIds = this.cellgroupPartyGroupDao.queryCgIdsByPartyGroupId(up.getGroupId());
        if (dIds.size() > 0) {
            List datas = this.cellGroupDataDao.query((Condition)Cnd.where((String)"n_id", (String)"in", dIds));
            up.setCellGroups(this.convertCellGroup(datas));
            TPartyGroup partyGroup = this.partyGroupDao.queryByPartyGroupId(up.getGroupId());
            TPgkData pgkData = this.partyGroupDao.query(TPgkData.class, partyGroup.getPgkDataID());
            up.setPartyGroupKey((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(pgkData.getData(), SourceDataStruct.class));
        } else {
            logger.error("\u66f4\u65b0PGK\u4f7f\u7528\u6700\u65b0\u7ed3\u6784\u4f53\u5931\u8d25\uff1a\u83b7\u53d6\u4e0d\u5230\u6307\u5b9aGroup\u3010{}\u3011\u76f8\u5173\u7684Entity\u6570\u636e", (Object)up.getGroupId());
        }
        return up;
    }

    private List<SourceDataStruct> convertCellGroup(List<TCellGroupData> datas) {
        ArrayList<SourceDataStruct> re = new ArrayList<SourceDataStruct>();
        for (TCellGroupData data : datas) {
            try {
                re.add((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(data.getData(), SourceDataStruct.class));
            }
            catch (JSONException e) {
                logger.error("\u89e3\u6790CellGroup\u7ed3\u6784\u4f53\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return re;
    }

    public boolean checkMission(String mid, int type, String sn) {
        return !this.missionDao.query((Condition)Cnd.where((String)"n_mid", (String)"=", (Object)Long.valueOf(mid)).and("n_type", "=", (Object)type).and("c_sn", "=", (Object)sn)).isEmpty();
    }

    public boolean existMission(String mid) {
        return !this.missionDao.query((Condition)Cnd.where((String)"n_mid", (String)"=", (Object)Long.valueOf(mid))).isEmpty();
    }

    public void doUploadUpdatePgk(String appId, UpdatePgkReq reqBean) throws JSONException {
        this.partyGroupDao.updatePartyGroup((PartyGroupKey)JsonMapper.alwaysMapper().fromJson(reqBean.getPartyGroupKey().getInfo(), PartyGroupKey.class), reqBean.getPartyGroupKey().toString());
        ArrayList<String> entityIds = new ArrayList<String>();
        ArrayList<String> skIds = new ArrayList<String>();
        entityIds.add(reqBean.getWrapedPgKey().getCgID());
        for (Object syncedPgKey : reqBean.getSyncedPgKey()) {
            entityIds.add(syncedPgKey.getCgID());
            skIds.add(syncedPgKey.getSkID());
        }
        Map<String, Long> cgIds = this.cellgroupDao.queryCgIDsByEntityIds(appId, entityIds);
        this.wrapPgkDao.save(reqBean.getWrapedPgKey(), JsonMapper.alwaysMapper().toJson((Object)reqBean.getWrapedPgKey()), cgIds.get(reqBean.getWrapedPgKey().getCgID()));
        for (SyncedPgKey syncedPgKey : reqBean.getSyncedPgKey()) {
            this.syncedPgkDao.save(RedisUtil.incr((String)"spdk"), syncedPgKey, syncedPgKey.toString(), cgIds.get(syncedPgKey.getCgID()));
        }
        this.createWrapPgk(reqBean.getSyncedPgKey(), reqBean.getPartyGroupKey());
        String entityId = reqBean.getWrapedPgKey().getCgID();
        this.creatGetLastPgk(appId, reqBean.getPartyGroupKey(), reqBean.getWrapedPgKey(), entityId);
        this.clearMissionByID(reqBean.getMid());
    }

    private void creatGetLastPgk(String appId, SourceDataStruct partyGroupKey, WrapedPgKey wrapPgk, String entityId) throws JSONException {
        List<TDevice> devs = this.deviceDao.getDevices(entityId, appId);
        for (TDevice dev : devs) {
            if (dev.getStart() > Long.valueOf(wrapPgk.getWkVer())) continue;
            this.createGetLastPgkMission(partyGroupKey, wrapPgk, dev.getSn(), appId);
        }
    }

    public void doUploadWrapPgk(String appId, WrapPgkReq wrapPgkReq) throws JSONException {
        WrapedPgKey wrapPgk = (WrapedPgKey)wrapPgkReq.getWrapedPgKey().get(0);
        String entityID = wrapPgk.getCgID();
        Map<String, Long> cgIds = this.cellgroupDao.queryCgIDsByEntityIds(appId, Collections.singletonList(entityID));
        SourceDataStruct partyGroupKey = this.pgkDao.getPGKStructByVersion(wrapPgk.getPgID(), Long.valueOf(wrapPgk.getPgkVer()));
        for (WrapedPgKey pgKey : wrapPgkReq.getWrapedPgKey()) {
            boolean exist = true;
            try {
                this.wrapPgkDao.getWrapedPGKData(pgKey.getPgID(), cgIds.get(entityID), Long.valueOf(pgKey.getPgkVer()));
            }
            catch (EmptyResultDataAccessException e) {
                exist = false;
            }
            if (exist) continue;
            this.wrapPgkDao.save(pgKey, JsonMapper.alwaysMapper().toJson((Object)pgKey), cgIds.get(entityID));
            this.syncedPgkDao.clearByCgIDAndPgkeyVerion(pgKey.getPgID(), cgIds.get(entityID), Long.valueOf(pgKey.getPgkVer()));
            this.creatGetLastPgk(appId, partyGroupKey, wrapPgk, entityID);
        }
        this.clearMissionByID(wrapPgkReq.getMid());
    }

    private void clearMissionByID(String mid) {
        this.missionDao.deleteByMids(Collections.singletonList(mid));
    }

    private void clearMissionCacheData(String ... mids) {
        if (mids != null && mids.length > 0) {
            for (int i = 0; i < mids.length; ++i) {
                mids[i] = "mdata_" + mids[i];
            }
            RedisUtil.del((String[])mids);
        }
    }

    public void doUploadWrapWrapKey(String appId, KekWrapKeyReq kekWrapKey) {
        ArrayList<String> entityIds = new ArrayList<String>();
        entityIds.add(((KekWrapKey)kekWrapKey.getKekWrapKey().get(0)).getCgID());
        Map<String, Long> cgIds = this.cellgroupDao.queryCgIDsEntityIds(appId, entityIds);
        for (KekWrapKey kek : kekWrapKey.getKekWrapKey()) {
            TWrapKey wrapKey = this.wrapkeyDao.getByCgIdAndVersion(cgIds.get(kek.getCgID()), Long.parseLong(kek.getWkVer()));
            if (wrapKey != null) {
                TKekWrapKey k = this.kekKeyDao.queryKekWrapKeyByKeKid(wrapKey.getId(), kek.getKekID());
                if (k != null) continue;
                this.wrapkeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), kek.getKekID(), wrapKey.getId(), kek.toString()));
                continue;
            }
            logger.error("DoUploadWrapWrapKey But wrapKey NOT EXIST ! cid[{}] version[{}]", (Object)cgIds.get(kek.getCgID()), (Object)kek.getWkVer());
        }
        this.clearMissionByID(kekWrapKey.getMid());
    }

    public void doUploadUpdateWrapKey(String appId, UpdateWrapkeyReq updateWrapkeyReq) throws JSONException {
        WrapKey wrapKey = (WrapKey)JsonMapper.alwaysMapper().fromJson(updateWrapkeyReq.getWrapKey().getInfo(), WrapKey.class);
        TCellGroup tCellGroup = this.entityDao.getByEntityIDAppId(wrapKey.getCgID(), appId);
        Long wrapKeyVersion = Long.valueOf(wrapKey.getWkVer());
        TWrapKey tWrapKey = this.wrapkeyDao.insert(new TWrapKey(RedisUtil.incr((String)"wkdk"), tCellGroup.getId(), Long.valueOf(wrapKey.getWkVer()), System.currentTimeMillis()));
        TWrapKeyData TWrapKeyData2 = this.wrapkeyDao.insert(new TWrapKeyData(tWrapKey.getId(), updateWrapkeyReq.getWrapKey().toString()));
        this.wrapkeyDao.insert(new TKekWrapKey(RedisUtil.incr((String)"kwdk"), updateWrapkeyReq.getKekWrapKey().getKekID(), tWrapKey.getId(), updateWrapkeyReq.getKekWrapKey().toString()));
        if (tCellGroup.getWrapKeyVersion() == wrapKeyVersion.longValue()) {
            tCellGroup.setWrapKeyID(TWrapKeyData2.getId());
        }
        this.cellgroupDao.update(tCellGroup);
        for (SyncedWrapKey syncedWrapKey : updateWrapkeyReq.getSyncedWrapKey()) {
            TSyncWrapKeyData TSyncWrapKeyData2 = this.syncWrapKeyDao.insert(new TSyncWrapKeyData(RedisUtil.incr((String)"swkdk"), tCellGroup.getId(), syncedWrapKey.toString()));
            this.syncWrapKeyDao.insert(new TSyncWrapKey(syncedWrapKey.getSkID(), Long.valueOf(syncedWrapKey.getWkVer()), TSyncWrapKeyData2.getId()));
        }
        this.createWrapWrapKeyForOldDevice(updateWrapkeyReq.getSyncedWrapKey(), updateWrapkeyReq.getWrapKey(), appId, tCellGroup.getEntityID());
        this.clearMissionByID(updateWrapkeyReq.getMid());
    }

    public void createGetLastPgk(SourceDataStruct partyGroupKeySData, WrapedPgKey wrapedPgKey, String appID, String currentSN) throws JSONException {
        List<TDevice> devs = this.deviceDao.getDevices(wrapedPgKey.getCgID(), appID);
        for (TDevice dev : devs) {
            if (dev.getStart() > Long.valueOf(wrapedPgKey.getWkVer()) || Objects.equals(currentSN, dev.getSn())) continue;
            this.createGetLastPgkMission(partyGroupKeySData, wrapedPgKey, dev.getSn(), appID);
        }
    }

    public void deleteUpdatePgkTodos(String appID, String pgID) {
        ArrayList<TMission> missions = new ArrayList<TMission>();
        missions.addAll(this.missionDao.query((Condition)Cnd.where((String)"c_app_id", (String)"=", (Object)appID).and("c_partygroup_id", "=", (Object)pgID).and("n_type", "=", (Object)2)));
        this.deleteMissions(missions);
    }

    public List<TodoStruct> getRestoreMissionsByDevice(String sn, String appID, String entityId, String type) {
        List<TMission> missions = StringUtils.isNotEmpty((CharSequence)entityId) && StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)appID) ? this.missionDao.getMissionsByEntityAndType(sn, appID, entityId, type) : this.missionDao.getMissionsBySns(sn, appID);
        return this.getTodoDatas(missions, true);
    }
}

