/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.verify;

import com.xdja.cssp.ums.model.Cert;
import com.xdja.cssp.ums.service.IAccountService;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.safecenter.secret.core.CommonSetting;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.core.verify.ALG_TYPE;
import com.xdja.safecenter.secret.core.verify.CertUtil;
import com.xdja.safecenter.secret.core.verify.SignUtils;
import com.xdja.safecenter.secret.model.TSyncPair;
import com.xdja.safecenter.secret.provider.localkey.exception.CertNotExistException;
import com.xdja.safecenter.secret.provider.verfiy.IVerifyProvider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VerifyProviderImpl
extends AbstractProvider
implements IVerifyProvider {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int CERT_TYPE_RSA = 1;
    private static final int CERT_TYPE_SM2 = 2;
    private static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_TAIL = "-----END CERTIFICATE-----";
    private IAccountService certService = (IAccountService)DefaultServiceRefer.getServiceRefer(IAccountService.class);

    public boolean verifyWithSN(String info, String signedData, String alg, String sn) {
        if (CommonSetting.VERIFY_TRIGGER) {
            int certAlg = 1;
            if (ALG_TYPE.sm2.value.equals(alg)) {
                certAlg = 2;
            }
            String certStr = "";
            try {
                certStr = this.queryCertBySN(sn, certAlg);
            }
            catch (CertNotExistException e) {
                this.logger.error("SN\u4e3a\u3010{}\u3011\uff0c\u7b97\u6cd5\u7c7b\u578b\u4e3a\u3010{}\u3011\u7684\u8bc1\u4e66\u4e0d\u5b58\u5728", (Object)sn, (Object)alg);
                return false;
            }
            if (StringUtils.isBlank((CharSequence)certStr)) {
                this.logger.error("\u67e5\u8be2SN\u4e3a\u3010{}\u3011\uff0c\u7b97\u6cd5\u7c7b\u578b\u4e3a\u3010{}\u3011\u7684\u8bc1\u4e66\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a ", (Object)sn, (Object)alg);
                return false;
            }
            X509Certificate cert = CertUtil.getCertFromStr((String)certStr);
            if (cert == null) {
                this.logger.error("\u89e3\u6790\u8bc1\u4e66\u3010{}\u3011\u5f02\u5e38", (Object)certStr);
                return false;
            }
            return SignUtils.verifySignByKey((String)alg, (PublicKey)cert.getPublicKey(), (byte[])info.getBytes(), (byte[])Base64.decode((String)signedData));
        }
        return true;
    }

    private String queryCertBySN(String sn, int alg) throws CertNotExistException {
        String certStr = RedisUtil.getHash((String)"Certs", (String)(sn + "_" + alg));
        if (StringUtils.isBlank((CharSequence)certStr)) {
            List certs = this.certService.queryHisCertBySnList(Arrays.asList(sn), alg);
            if (certs == null || certs.isEmpty()) {
                throw new CertNotExistException("\u672a\u67e5\u8be2\u5230SN:" + sn);
            }
            certStr = ((Cert)certs.get(0)).getCert();
            RedisUtil.setHash((String)"Certs", (String)(sn + "_" + alg), (String)certStr.replace(CERT_HEAD, "").replace(CERT_TAIL, "").replaceAll("\\\\n", "").replaceAll("\\\\r", ""));
        }
        return certStr;
    }

    public boolean verifyWithSyncPK(String info, String signedData, String alg, String syncKeyID, String appID, String sn) {
        if (CommonSetting.VERIFY_TRIGGER) {
            if (!syncKeyID.contains(sn + "_")) {
                this.logger.error("\u4f7f\u7528\u540c\u6b65\u516c\u94a5\u9a8c\u6b63\u7b7e\u540d\u5931\u8d25\uff0c\u540c\u6b65\u5bc6\u94a5\u3010{}\u3011\u4e0e\u8bbe\u5907SN\u3010{}\u3011\u4e0d\u5339\u914d", (Object)syncKeyID, (Object)sn);
                return false;
            }
            String syncPubkey = RedisUtil.get((String)("SYNC_" + syncKeyID));
            if (StringUtils.isBlank((CharSequence)syncPubkey)) {
                TSyncPair pair = (TSyncPair)this.daoTemplate.fetch(TSyncPair.class, (Condition)Cnd.where((String)"n_id", (String)"=", (Object)syncKeyID).and("c_sn", "=", (Object)sn));
                if (pair == null) {
                    this.logger.error("\u4f7f\u7528\u540c\u6b65\u516c\u94a5\u9a8c\u6b63\u7b7e\u540d\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230SKID\u3010{}\u3011\u8bbe\u5907SN\u3010{}\u3011\u5bf9\u5e94\u7684\u540c\u6b65\u5bc6\u94a5\uff0c", (Object)syncKeyID, (Object)sn);
                    return false;
                }
                syncPubkey = pair.getPublicKey();
                RedisUtil.set((String)("SYNC_" + syncKeyID), (String)pair.getPublicKey());
            }
            return SignUtils.verifySignByKeyData((String)alg, (String)syncPubkey, (byte[])info.getBytes(), (byte[])Base64.decode((String)signedData));
        }
        return true;
    }

    public boolean verifyWithSyncPKData(String info, String signedData, String alg, String syncPubKey) {
        return !CommonSetting.VERIFY_TRIGGER || SignUtils.verifySignByKeyData((String)alg, (String)syncPubKey, (byte[])info.getBytes(), (byte[])Base64.decode((String)signedData));
    }
}

