/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.model.TChipAddRequest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ChipAddRequestDao
extends BaseDao<TChipAddRequest> {
    private static final String SN = "sn";
    private static final String N_ID = "n_id";
    private static final String C_ID = "cId";
    private static final String IDS = "ids";
    private static final String ID = "id";
    private static final String SELECT_N_ID_N_CHIP_ADD_REQUEST_DATA_ID_FROM_T_CHIP_ADD_REQUEST_WHERE_N_CELLGROUP_ID_C_ID = "SELECT n_id FROM t_chip_add_request WHERE n_cellgroup_id = :cId";
    private static final String DELETE_FROM_T_CHIP_ADD_REQUEST_DATA_WHERE_N_ID_IN_IDS = "DELETE FROM t_chip_add_request_data WHERE n_id IN (:ids)";
    private static final String DELETE_FROM_T_CHIP_ADD_REQUEST_WHERE_N_ID_IN_IDS = "DELETE FROM t_chip_add_request WHERE n_id IN (:ids)";
    private static final String DELETE_FROM_T_CHIP_ADD_REQUEST_DATA_WHERE_N_ID_ID = "DELETE FROM t_chip_add_request_data WHERE n_id = :id";
    private static final String DELETE_FROM_T_CHIP_ADD_REQUEST_WHERE_N_ID_ID = "DELETE FROM t_chip_add_request WHERE n_id =:id";

    public void clearByCellGroup(String appId, String entityId) {
        String sql = "SELECT n_id FROM t_chip_add_request WHERE c_app_id = :appId AND c_entity_id = :entityId";
        final ArrayList<Long> iDs = new ArrayList<Long>();
        this.queryForList(sql, (SqlParameterSource)new MapSqlParameterSource("appId", (Object)appId).addValue("entityId", (Object)entityId), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                iDs.add(resultSet.getLong(ChipAddRequestDao.N_ID));
                return null;
            }
        });
        this.clearByIds(iDs);
    }

    private void clearByIds(List<Long> iDs) {
        if (!iDs.isEmpty()) {
            this.deleteBySql(DELETE_FROM_T_CHIP_ADD_REQUEST_WHERE_N_ID_IN_IDS, (SqlParameterSource)new MapSqlParameterSource(IDS, iDs));
            this.deleteBySql(DELETE_FROM_T_CHIP_ADD_REQUEST_DATA_WHERE_N_ID_IN_IDS, (SqlParameterSource)new MapSqlParameterSource(IDS, iDs));
        }
    }

    public void clearByChipIdAndCellGroup(String sn, String appId, String entityId) {
        String sql = "SELECT n_id FROM t_chip_add_request WHERE c_app_id = :appId AND c_entity_id=:entityId AND c_sn=:sn";
        List iDs = this.queryColumnLongForList(sql, (SqlParameterSource)new MapSqlParameterSource("appId", (Object)appId).addValue("entityId", (Object)entityId).addValue(SN, (Object)sn), N_ID);
        this.clearByIds(iDs);
    }

    public void clearRequestAndDataByIds(Long dataID, Long ID) {
        if (dataID != null) {
            this.deleteBySql(DELETE_FROM_T_CHIP_ADD_REQUEST_DATA_WHERE_N_ID_ID, (SqlParameterSource)new MapSqlParameterSource(ID, (Object)dataID));
        }
        if (ID != null) {
            this.deleteBySql(DELETE_FROM_T_CHIP_ADD_REQUEST_WHERE_N_ID_ID, (SqlParameterSource)new MapSqlParameterSource(ID, (Object)ID));
        }
    }

    public void clearDeviceAddRequestBySnAndEntity(String sn, String appID, String entityID) {
        String querySql = "SELECT n_id FROM t_chip_add_request WHERE c_sn = :sn AND c_entity_id = :eid AND c_app_id = :aid";
        List dIds = this.queryColumnLongForList(querySql, (SqlParameterSource)new MapSqlParameterSource(SN, (Object)sn).addValue("eid", (Object)entityID).addValue("aid", (Object)appID), N_ID);
        if (!dIds.isEmpty()) {
            MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(IDS, (Object)dIds);
            String deleteSql = "DELETE FROM t_chip_add_request WHERE  n_id IN(:ids)";
            this.deleteBySql(deleteSql, (SqlParameterSource)mapSqlParameterSource);
            String deleteDataSql = "DELETE FROM t_chip_add_request_data WHERE  n_id IN(:ids)";
            this.deleteBySql(deleteDataSql, (SqlParameterSource)mapSqlParameterSource);
        }
    }
}

