/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TRegionKek;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RegionKekDao
extends BaseDao {
    public TRegionKek saveRegionKek(String rSn, String backNo, String bSn, String kek) {
        TRegionKek bean = new TRegionKek();
        bean.setId(RedisUtil.incr((String)"regkk"));
        bean.setRestoreSn(rSn);
        bean.setBackNo(backNo);
        bean.setBackSn(bSn);
        bean.setKek(kek);
        bean.setTime(System.currentTimeMillis());
        return this.insert(bean);
    }

    public TRegionKek getRegionKek(String sn, String backNo) {
        return (TRegionKek)this.daoTemplate.fetch(TRegionKek.class, (Condition)Cnd.where((String)"c_restore_sn", (String)"=", (Object)sn).and("c_back_no", "=", (Object)backNo));
    }

    public Map<String, TRegionKek> queryRegionKek(String sn, Set<String> backNoList) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_restore_sn, c_back_no, c_back_sn, c_kek, n_time");
        sql.append(" FROM t_region_kek WHERE c_restore_sn = :rSn AND c_back_no IN (:backNoList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("rSn", (Object)sn);
        params.addValue("backNoList", backNoList);
        final HashMap<String, TRegionKek> result = new HashMap<String, TRegionKek>();
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                TRegionKek regionKek = null;
                do {
                    regionKek = new TRegionKek();
                    regionKek.setId(rs.getLong("n_id"));
                    regionKek.setRestoreSn(rs.getString("c_restore_sn"));
                    regionKek.setBackNo(rs.getString("c_back_no"));
                    regionKek.setBackSn(rs.getString("c_back_sn"));
                    regionKek.setKek(rs.getString("c_kek"));
                    regionKek.setTime(rs.getLong("n_time"));
                    result.put(regionKek.getBackNo(), regionKek);
                } while (rs.next());
                return null;
            }
        });
        return result;
    }
}

