/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TSyncPair;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SyncPairDao
extends BaseDao {
    public static final String ID = "id";
    public static final String PID = "pid";
    public static final String DELETE_SYNC_PRIVATE_KEY_DATA = "DELETE FROM t_sync_private_key_data WHERE n_id = :id";
    public static final String DELETE_SYNC_PAIR = "DELETE FROM t_sync_pair WHERE n_id = :pid";

    public void clearByPair(TSyncPair syncPair) {
        MapSqlParameterSource ps = new MapSqlParameterSource(ID, (Object)syncPair.getPrivateKeyDataID());
        this.deleteBySql(DELETE_SYNC_PRIVATE_KEY_DATA, (SqlParameterSource)ps);
        MapSqlParameterSource ps1 = new MapSqlParameterSource(PID, (Object)syncPair.getId());
        this.deleteBySql(DELETE_SYNC_PAIR, (SqlParameterSource)ps1);
    }

    public TSyncPair getPairBySNCgId(String sn, Long cid) {
        return (TSyncPair)this.daoTemplate.fetch(TSyncPair.class, (Condition)Cnd.where((String)"c_sn", (String)"=", (Object)sn).and("n_cellgroup_id", "=", (Object)cid));
    }

    public TSyncPair getPairBySkID(String skID) {
        return (TSyncPair)this.daoTemplate.fetch(TSyncPair.class, (Condition)Cnd.where((String)"n_id", (String)"=", (Object)skID));
    }

    public List<TSyncPair> getSyncPairsByCellGroupId(Long cellGroupID) {
        String sql = "SELECT n_id, n_private_key_data_id FROM t_sync_pair WHERE n_cellgroup_id = :cid";
        MapSqlParameterSource params = new MapSqlParameterSource("cid", (Object)cellGroupID);
        final ArrayList<TSyncPair> list = new ArrayList<TSyncPair>();
        this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                TSyncPair pair = new TSyncPair();
                pair.setId(rs.getString("n_id"));
                pair.setPrivateKeyDataID(rs.getLong("n_private_key_data_id"));
                list.add(pair);
                return null;
            }
        });
        return list;
    }

    public Map<String, String> getSyncPubKeyDatas(List<String> skIDs) {
        final HashMap<String, String> result = new HashMap<String, String>();
        MapSqlParameterSource Params = new MapSqlParameterSource();
        Params.addValue("skids", skIDs);
        this.daoTemplate.queryForList("SELECT pubkey.n_id,data.c_data FROM t_sync_public_key pubkey,t_sync_public_key_data data WHERE pubkey.n_id IN (:skids) AND pubkey.n_public_key_data_id = data.n_id", (SqlParameterSource)Params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                result.put(resultSet.getString("n_id"), resultSet.getString("c_data"));
                return null;
            }
        });
        return result;
    }
}

