/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.model.TCellGroupPartyGroupRelation;
import com.xdja.safecenter.secret.provider.partygroup.bean.response.PEntityBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TCellgroupPartyGroupDao
extends BaseDao<TCellGroupPartyGroupRelation> {
    private static final String IDS = "ids";
    private static final String N_ID = "n_id";
    private static final String PG_ID = "pgId";
    private static final String APPID = "appId";
    private static final String PARTY_GROUP_ID = "partyGroupID";
    private static final String OP = "=";
    private static final String N_CELLGROUP_ID = "n_cellgroup_id";
    private static final String C_ENTITY_ID = "c_entity_id";
    private static final String CG_ID = "cgID";
    private static final String C_PARTYGROUP_ID = "c_partygroup_id";
    private static final String ADD_TIME = "n_add_time";
    private static final String ADD_DEVICE_ID = "c_add_dev_id";
    private static final String APP_ID = "c_app_id";
    private static final String SELECT_CELLGROUP_PARTYGROUP_BY_PARTYGROUP_ID = "SELECT n_id FROM t_cellgroup_partygroup WHERE c_partygroup_id=:pgId";
    private static final String DELETE_CELLGROUP_PARTYGROUP = "DELETE FROM t_cellgroup_partygroup WHERE n_id IN(:ids)";
    private static final String SELECT_CELLGROUP_PARTYGROUP = "SELECT n_id FROM t_cellgroup_partygroup WHERE c_partygroup_id = :pgId and n_cellgroup_id IN(:ids)";
    private static final String SELECT_ENTITYID_PARTYGROUP_BY_PARTYGROUP_ID_ORDER = "SELECT cg.c_entity_id FROM t_cellgroup cg INNER JOIN  t_cellgroup_partygroup cp ON cg.n_id = cp.n_cellgroup_id WHERE cp.c_partygroup_id=:pgId ORDER BY cg.n_id";
    private static final String SELECT_CELLGROUP_PARTYGROUP_BY_CELLGROUP_ID = "SELECT c_partygroup_id FROM t_cellgroup_partygroup WHERE n_cellgroup_id=:cgID ORDER BY n_id";
    private static final String SELECT_ENTITY_BY_PARTYGROUP_ID = "SELECT cg.c_entity_id, cg.n_id, cp.n_add_time,cp.c_add_dev_id, cg.c_app_id FROM t_cellgroup cg INNER JOIN  t_cellgroup_partygroup cp ON cg.n_id = cp.n_cellgroup_id WHERE cp.c_partygroup_id=:pgId ORDER BY cg.n_id";
    private static final String SELECT_PARTYGROUP_ID_BY_ENTITY = "SELECT cg.c_entity_id, cp.c_partygroup_id FROM t_cellgroup cg INNER JOIN t_cellgroup_partygroup cp ON cg.n_id = cp.n_cellgroup_id WHERE cg.c_app_id=:appId AND cg.c_entity_id IN(:ids)";
    private static final String SELECT_CELLGROUP_ID_BY_PARTYGROUP_ID = "SELECT n_cellgroup_id FROM t_cellgroup_partygroup WHERE c_partygroup_id=:pgId";

    public void save(String partyGroupID, Long cellGroupID) {
        TCellGroupPartyGroupRelation relation = new TCellGroupPartyGroupRelation();
        relation.setPartyGroupID(partyGroupID);
        relation.setCellGroupID(cellGroupID);
        this.insert(relation);
    }

    public void save(List<TCellGroupPartyGroupRelation> list) {
        for (TCellGroupPartyGroupRelation relation : list) {
            this.insert(relation);
        }
    }

    public void delete(String partyGroupID, List<Long> cellGroupIDs) {
        List ids = this.queryColumnLongForList(SELECT_CELLGROUP_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID).addValue(IDS, cellGroupIDs), N_ID);
        if (ids != null && !ids.isEmpty()) {
            this.deleteBySql(DELETE_CELLGROUP_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(IDS, (Object)ids));
        }
    }

    public List<String> queryEntityIDs(String partyGroupID) {
        return this.queryColumnForList(SELECT_ENTITYID_PARTYGROUP_BY_PARTYGROUP_ID_ORDER, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), C_ENTITY_ID);
    }

    public List<String> queryPartyGroupIDs(Long cellGroupID) {
        return this.queryColumnForList(SELECT_CELLGROUP_PARTYGROUP_BY_CELLGROUP_ID, (SqlParameterSource)new MapSqlParameterSource(CG_ID, (Object)cellGroupID), C_PARTYGROUP_ID);
    }

    public void clearByPartyGroupId(String partyGroupID) {
        List ids = this.queryColumnLongForList(SELECT_CELLGROUP_PARTYGROUP_BY_PARTYGROUP_ID, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupID), N_ID);
        if (ids != null && !ids.isEmpty()) {
            this.deleteBySql(DELETE_CELLGROUP_PARTYGROUP, (SqlParameterSource)new MapSqlParameterSource(IDS, (Object)ids));
        }
    }

    public Map<String, List<PEntityBean>> queryEntitiesByPartyGroupID(String pgID) {
        final HashMap<String, List<PEntityBean>> result = new HashMap<String, List<PEntityBean>>();
        this.queryForList(SELECT_ENTITY_BY_PARTYGROUP_ID, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)pgID), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                if (!result.containsKey(rs.getString(TCellgroupPartyGroupDao.APP_ID))) {
                    ArrayList<PEntityBean> list = new ArrayList<PEntityBean>();
                    result.put(rs.getString(TCellgroupPartyGroupDao.APP_ID), list);
                    list.add(new PEntityBean(rs.getString(TCellgroupPartyGroupDao.C_ENTITY_ID), Long.valueOf(rs.getLong(TCellgroupPartyGroupDao.ADD_TIME)), rs.getString(TCellgroupPartyGroupDao.ADD_DEVICE_ID)));
                } else {
                    ((List)result.get(rs.getString(TCellgroupPartyGroupDao.APP_ID))).add(new PEntityBean(rs.getString(TCellgroupPartyGroupDao.C_ENTITY_ID), Long.valueOf(rs.getLong(TCellgroupPartyGroupDao.ADD_TIME)), rs.getString(TCellgroupPartyGroupDao.ADD_DEVICE_ID)));
                }
                return null;
            }
        });
        return result;
    }

    public Map<String, List<String>> queryPartyGroupIDsByEntityIDs(String appID, List<String> entityIDs) {
        final HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.queryForList(SELECT_PARTYGROUP_ID_BY_ENTITY, (SqlParameterSource)new MapSqlParameterSource(APPID, (Object)appID).addValue(IDS, entityIDs), (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                if (!result.containsKey(rs.getString(TCellgroupPartyGroupDao.C_ENTITY_ID))) {
                    ArrayList<String> list = new ArrayList<String>();
                    result.put(rs.getString(TCellgroupPartyGroupDao.C_ENTITY_ID), list);
                    list.add(rs.getString(TCellgroupPartyGroupDao.C_PARTYGROUP_ID));
                } else {
                    ((List)result.get(rs.getString(TCellgroupPartyGroupDao.C_ENTITY_ID))).add(rs.getString(TCellgroupPartyGroupDao.C_PARTYGROUP_ID));
                }
                return null;
            }
        });
        return result;
    }

    public List<Long> queryCgIdsByPartyGroupId(String partyGroupId) {
        return this.queryColumnLongForList(SELECT_CELLGROUP_ID_BY_PARTYGROUP_ID, (SqlParameterSource)new MapSqlParameterSource(PG_ID, (Object)partyGroupId), N_CELLGROUP_ID);
    }

    public List<String> queryPgIdsByCgIds(List<Long> cgIds) {
        String sql = "select c_partygroup_id from t_cellgroup_partygroup where n_cellgroup_id in(:cgIds)";
        MapSqlParameterSource params = new MapSqlParameterSource("cgIds", cgIds);
        return super.queryColumnForList(sql, (SqlParameterSource)params, C_PARTYGROUP_ID);
    }
}

