/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.core.datasource.dao.BaseDao;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TPgkDao
extends BaseDao<TPgkDao> {
    private static final String PG_ID = "pgID";
    private static final String N_PGK_VERSION = "n_pgk_version";
    private static final String C_DATA = "c_data";
    private static final String sql_pgk_data = "SELECT c_data FROM t_pgk_data WHERE c_partygroup_id=:pgID AND n_pgk_version=:version";
    private static final String sql_pgk_data_version = "SELECT n_pgk_version, c_data FROM t_pgk_data WHERE c_partygroup_id=:pgID";
    private static final String sql_pgk_last_data = "SELECT pgkdata.c_data FROM t_partygroup pg, t_pgk_data pgkdata WHERE pg.c_partygroup_id=:pgID AND pg.n_pgk_data_id = pgkdata.n_id";

    public String getPGKDataByVersion(String partyGroupID, Long version) throws EmptyResultDataAccessException {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        params.addValue("version", (Object)version);
        return this.queryForString(sql_pgk_data, (SqlParameterSource)params);
    }

    public Map<Long, String> getPGKDatas(String partyGroupID) {
        MapSqlParameterSource params = new MapSqlParameterSource(PG_ID, (Object)partyGroupID);
        final HashMap<Long, String> pgkDataMap = new HashMap<Long, String>();
        this.queryForList(sql_pgk_data_version, (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                pgkDataMap.put(rs.getLong(TPgkDao.N_PGK_VERSION), rs.getString(TPgkDao.C_DATA));
                return null;
            }
        });
        return pgkDataMap;
    }

    public String getLatestPGKData(String partyGroupID) throws EmptyResultDataAccessException {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(PG_ID, (Object)partyGroupID);
        return this.queryForString(sql_pgk_last_data, (SqlParameterSource)params);
    }

    public SourceDataStruct getPGKStructByVersion(String pgID, Long version) {
        SourceDataStruct re = null;
        String data = this.getPGKDataByVersion(pgID, version);
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            try {
                re = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(data, SourceDataStruct.class);
            }
            catch (JSONException e) {
                this.logger.error("getPGKStructByVersion Json ERROR [{}]", (Object)data);
            }
        } else {
            this.logger.error("getPGKStructByVersion Not found data pgID[{}],version[{}]", (Object)pgID, (Object)version);
        }
        return re;
    }
}

