/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.dao;

import com.xdja.safecenter.secret.dao.BaseDao;
import com.xdja.safecenter.secret.model.TWrapKey;
import com.xdja.safecenter.secret.model.TWrapKeyData;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WrapkeyDao
extends BaseDao {
    public List<TWrapKey> getByCgIdAndStartVersion(Long cgId, Long start) {
        return this.daoTemplate.query(TWrapKey.class, (Condition)Cnd.where((String)"n_cellgroup_id", (String)"=", (Object)cgId).and("n_version", ">=", (Object)(start == -1L ? 0L : start)));
    }

    public List<TWrapKeyData> getDataByIds(List<Long> wrapKeyids) {
        return this.daoTemplate.query(TWrapKeyData.class, (Condition)Cnd.where((String)"n_id", (String)"in", wrapKeyids).and("c_data", "<>", (Object)""));
    }

    public TWrapKey getByCgIdAndVersion(Long cgId, Long version) {
        return (TWrapKey)this.daoTemplate.fetch(TWrapKey.class, (Condition)Cnd.where((String)"n_cellgroup_id", (String)"=", (Object)cgId).and("n_version", "=", (Object)version));
    }

    public void clearWrapkeyBycellGroupID(Long cellGroupID) {
        String querySql = "SELECT n_id FROM t_wrapkey WHERE n_cellgroup_id = :CID";
        List dataIds = this.daoTemplate.queryColumnLongForList(querySql, (SqlParameterSource)new MapSqlParameterSource("CID", (Object)cellGroupID), "n_id");
        if (!dataIds.isEmpty()) {
            String deleteSql = "DELETE FROM t_wrapkey WHERE  n_id IN(:ids)";
            this.daoTemplate.deleteBySql(deleteSql, (SqlParameterSource)new MapSqlParameterSource("ids", (Object)dataIds));
            String deleteDataSql = "DELETE FROM t_wrapkey_data WHERE  n_id IN(:ids)";
            this.daoTemplate.deleteBySql(deleteDataSql, (SqlParameterSource)new MapSqlParameterSource("ids", (Object)dataIds));
            String deleteKekWrapKeySql = "DELETE FROM t_kek_wrapkey WHERE  n_wrapkey_id IN(:ids)";
            this.daoTemplate.deleteBySql(deleteKekWrapKeySql, (SqlParameterSource)new MapSqlParameterSource("ids", (Object)dataIds));
        }
    }

    public List<TWrapKey> getByCgId(Long cgId) {
        return this.daoTemplate.query(TWrapKey.class, (Condition)Cnd.where((String)"n_cellgroup_id", (String)"=", (Object)cgId));
    }

    public Long getLastWrapKeyVersion(Long cgId) {
        String sql = " SELECT MAX(n_version) FROM t_wrapkey WHERE n_cellgroup_id = :cgID";
        return this.daoTemplate.queryForLong(sql, (SqlParameterSource)new MapSqlParameterSource("cgID", (Object)cgId));
    }

    public String queryCountsByCgIds(List<Long> cgIds) {
        String sql = "select count(1) from t_wrapkey where n_cellgroup_id in(:cgIds)";
        return super.queryForString(sql, (SqlParameterSource)new MapSqlParameterSource("cgIds", cgIds));
    }
}

