/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.kek;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.dao.DeviceDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TKek;
import com.xdja.safecenter.secret.provider.kek.IKekProvider;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.Kek;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class KekProviderImpl
extends AbstractProvider
implements IKekProvider {
    @Resource
    private kekKeyDao kekKeyDao;
    @Resource
    private DeviceDao deviceDao;

    public SourceDataStruct getKekBySn(String sn) throws JSONException {
        if (this.deviceDao.checkDeviceStatus(sn)) {
            return null;
        }
        TKek kek = this.kekKeyDao.queryBySN(sn);
        if (kek == null) {
            return null;
        }
        return (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(kek.getData(), SourceDataStruct.class);
    }

    public boolean existKek(String sn) {
        TKek kek = this.kekKeyDao.queryBySN(sn);
        return kek != null && !StringUtils.isBlank((CharSequence)kek.getId());
    }

    public void saveKek(SourceDataStruct kek) throws JSONException {
        Kek k = (Kek)JsonMapper.alwaysMapper().fromJson(kek.getInfo(), Kek.class);
        this.kekKeyDao.insert(new TKek(k.getKekID(), k.getCiD(), k.getSn(), kek.toString()));
    }
}

