/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.localkey;

import com.xdja.cssp.sm2cipher.sm2.cipher.ConvertUtil;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2CipherImpl;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM3Digest;
import com.xdja.safecenter.secret.core.datasource.AbstractProvider;
import com.xdja.safecenter.secret.core.util.RandomUtil;
import com.xdja.safecenter.secret.core.util.Sm4;
import com.xdja.safecenter.secret.core.verify.CertUtil;
import com.xdja.safecenter.secret.provider.localkey.ILocalKeyProvider;
import com.xdja.safecenter.secret.provider.localkey.exception.CertParseException;
import com.xdja.safecenter.secret.provider.localkey.exception.KeyFileNotExistException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.stereotype.Component;

@Component
public class LocalKeyProviderImpl
extends AbstractProvider
implements ILocalKeyProvider {
    private String localKeyStr;
    private String localKeyHash;

    private String readKeyFile() throws KeyFileNotExistException {
        try {
            return new String(Files.readAllBytes(Paths.get("/home/xdja/conf/ckms/local.key", "")));
        }
        catch (Exception e) {
            throw new KeyFileNotExistException("load local key fail /home/xdja/conf/ckms/local.key", (Throwable)e);
        }
    }

    private String hashKey(String key) {
        SM3Digest digest = new SM3Digest();
        digest.update(key.getBytes());
        byte[] hashData = digest.doFinal();
        return new String(Base64.encode((byte[])hashData));
    }

    public String getLocalKeyHash() throws KeyFileNotExistException {
        if (StringUtils.isBlank((CharSequence)this.localKeyStr)) {
            this.localKeyStr = this.readKeyFile();
        }
        if (StringUtils.isBlank((CharSequence)this.localKeyHash)) {
            this.localKeyHash = this.hashKey(this.localKeyStr);
        }
        return this.localKeyHash;
    }

    public String[] getCipherLocalKey(String base64Cert) throws KeyFileNotExistException, CertParseException {
        X509Certificate cert;
        String[] result = new String[2];
        if (StringUtils.isBlank((CharSequence)this.localKeyStr)) {
            this.localKeyStr = this.readKeyFile();
        }
        if ((cert = CertUtil.getCertFromB64((String)base64Cert)) == null) {
            throw new CertParseException("\u89e3\u6790\u52a0\u5bc6\u8bc1\u4e66\u65f6\u51fa\u73b0\u5f02\u5e38 \u8bc1\u4e66\u4fe1\u606f\uff1a" + base64Cert);
        }
        byte[] bytes = new byte[65];
        bytes[0] = 4;
        ECPoint W = ((ECPublicKey)cert.getPublicKey()).getW();
        byte[] xdata = ConvertUtil.hexStringToBytes((String)W.getAffineX().toString(16));
        byte[] ydata = ConvertUtil.hexStringToBytes((String)W.getAffineY().toString(16));
        System.arraycopy(xdata, 0, bytes, 33 - xdata.length, xdata.length);
        System.arraycopy(ydata, 0, bytes, 65 - ydata.length, ydata.length);
        SM2CipherImpl cipher = new SM2CipherImpl();
        byte[] sm4key = RandomUtil.getRandomByteArray((int)16);
        byte[] encSm4Key = cipher.encrypt_gb(new String(Base64.encode((byte[])bytes)), sm4key);
        byte[] encKeydata = Sm4.sm4_encrypt_ecb((byte[])sm4key, (byte[])this.localKeyStr.getBytes());
        result[0] = new String(Base64.encode((byte[])encSm4Key));
        result[1] = new String(Base64.encode((byte[])encKeydata));
        return result;
    }
}

