/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.open;

import com.xdja.cssp.open.system.entity.OpenApp;
import com.xdja.cssp.open.system.service.IOpenAppInfoService;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.safecenter.oauth.service.IAuthService;
import com.xdja.safecenter.oauth.service.pojo.AppInfo;
import com.xdja.safecenter.secret.core.CommonSetting;
import com.xdja.safecenter.secret.provider.open.IOpenServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IOpenServiceProviderImpl
implements IOpenServiceProvider {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAuthService service = (IAuthService)DefaultServiceRefer.getServiceRefer(IAuthService.class);
    private IOpenAppInfoService openService = (IOpenAppInfoService)DefaultServiceRefer.getServiceRefer(IOpenAppInfoService.class);

    public boolean verifySign(String appID, String sourceData, String signData) {
        if (!CommonSetting.VERIFY_TRIGGER) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)appID) || StringUtils.isBlank((CharSequence)sourceData) || StringUtils.isBlank((CharSequence)signData)) {
            this.logger.error("verifyAppSign error appID,sourceData,signDate can not be null");
            return false;
        }
        if (this.service.verifySign(appID, sourceData, signData)) {
            return true;
        }
        this.logger.error("verifyAppSign Remote Error, appID [{}],sourceData[{}],signData[{}]", new Object[]{appID, sourceData, signData});
        return false;
    }

    public Map<String, AppInfo> getAppInfo(String ... appIds) {
        if (CommonSetting.USE_OPEN) {
            HashMap<String, AppInfo> result = new HashMap<String, AppInfo>();
            Map openResult = this.openService.queryAppInfo(appIds);
            OpenApp openApp = null;
            AppInfo info = null;
            for (Map.Entry item : openResult.entrySet()) {
                openApp = (OpenApp)item.getValue();
                info = new AppInfo();
                info.setAppId(openApp.getAppId());
                info.setName(openApp.getName());
                info.setSecretKey(openApp.getSecretKey());
                info.setPkgName(openApp.getPkgName());
                info.setPkgSign(openApp.getPkgSign());
                info.setSuit(openApp.getSuit());
                info.setType(openApp.getType());
                info.setTime(openApp.getTime());
                result.put((String)item.getKey(), info);
            }
            return result;
        }
        return this.service.getAppInfoBatch(appIds);
    }
}

