/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.region;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.secret.dao.BackupCardDao;
import com.xdja.safecenter.secret.dao.RegionDao;
import com.xdja.safecenter.secret.dao.RegionDeviceDao;
import com.xdja.safecenter.secret.dao.RegionKekDao;
import com.xdja.safecenter.secret.dao.RegionRestoreRecordDao;
import com.xdja.safecenter.secret.dao.RegionUsedBackupCardDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TBackupCard;
import com.xdja.safecenter.secret.model.TKek;
import com.xdja.safecenter.secret.model.TRegion;
import com.xdja.safecenter.secret.model.TRegionKek;
import com.xdja.safecenter.secret.model.TRegionRestoreRecord;
import com.xdja.safecenter.secret.provider.backup.BaseProvider;
import com.xdja.safecenter.secret.provider.backup.bean.BackupCardStatus;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.provider.region.IRegionProvider;
import com.xdja.safecenter.secret.provider.region.bean.RegionBean;
import com.xdja.safecenter.secret.provider.region.bean.RestoreResult;
import com.xdja.safecenter.secret.provider.restore.RestoreProvider;
import com.xdja.safecenter.secret.provider.restore.bean.EntityInfo;
import com.xdja.safecenter.secret.provider.restore.bean.UploadRestoreKeyReq;
import com.xdja.safecenter.secret.provider.restore.bean.UploadSecretkeyInfo;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.Kek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RegionProviderImpl
extends BaseProvider
implements IRegionProvider {
    @Resource
    private RegionDao regionDao;
    @Resource
    private RegionDeviceDao regionDeviceDao;
    @Resource
    private RegionKekDao regionKekDao;
    @Resource
    private RegionRestoreRecordDao regionRestoreRecordDao;
    @Resource
    private RegionUsedBackupCardDao regionUsedBackupCardDao;
    @Resource
    private BackupCardDao backupCardDao;
    @Resource
    private kekKeyDao kekKeyDao;
    @Resource
    private RestoreProvider restoreProvider;

    public void doReportRegion(RegionBean region, String sn) {
        TRegion regionInfo = this.regionDao.getRegion(region.getPkName());
        if (null == regionInfo) {
            regionInfo = this.regionDao.saveRegion(region);
        }
        if (!this.regionDeviceDao.isRegionDeviceExist(sn, regionInfo.getId())) {
            this.regionDeviceDao.saveRegionDevice(sn, regionInfo.getId());
        }
    }

    public int doUploadDeviceEncKek(String bSn, String backNo, String rSn, String rChipNo, UploadRestoreKeyReq req) throws JSONException {
        if (bSn.equals(rSn)) {
            return 6;
        }
        TBackupCard backupCard = this.backupCardDao.getBackupCard(backNo);
        if (null == backupCard || backupCard.getStatus() != BackupCardStatus.USED.value) {
            return 5;
        }
        if (!backupCard.getChipSn().equals(bSn)) {
            return 2;
        }
        TKek kekInfo = this.kekKeyDao.queryBySN(rSn);
        if (null == kekInfo) {
            return 3;
        }
        if (!kekInfo.getId().equals(req.getEncKekId())) {
            return 4;
        }
        TRegionKek regionKek = this.regionKekDao.saveRegionKek(rSn, backNo, bSn, req.getEncKek());
        this.saveRestoreRecord(backNo, rChipNo, rSn, bSn, regionKek.getTime());
        this.saveSecretKeys(bSn, rSn, req);
        backupCard.setStatus(BackupCardStatus.INVALID.value);
        this.backupCardDao.update(backupCard);
        this.sendUpdateBackupCardStatusMsg(backNo, BackupCardStatus.INVALID);
        return 1;
    }

    public int doReportRestoreResult(List<RestoreResult> req, String sn) {
        HashMap<String, List<Long>> successRegionIds = new HashMap<String, List<Long>>();
        HashSet<Long> stayRegionIds = new HashSet<Long>();
        int count = 0;
        for (RestoreResult res : req) {
            Map<String, Map<Long, Integer>> regionIds = this.regionRestoreRecordDao.queryRecordRegionIds(res.getBackNo(), sn);
            if (regionIds.isEmpty()) {
                return 2;
            }
            if (!regionIds.containsKey(res.getBackSn())) {
                return 3;
            }
            Map<Long, Integer> regionIdStatus = regionIds.get(res.getBackSn());
            if (regionIdStatus.isEmpty() || !regionIdStatus.keySet().containsAll(res.getRegionIds())) {
                return 4;
            }
            ArrayList<Long> regionIdList = new ArrayList<Long>();
            for (Long regionId : res.getRegionIds()) {
                if (regionIdStatus.get(regionId) != 1) continue;
                regionIdList.add(regionId);
            }
            if (!regionIdList.isEmpty()) {
                successRegionIds.put(res.getBackNo(), regionIdList);
                count += regionIdList.size();
            }
            List<Long> resDevRegionIds = this.regionDeviceDao.queryRegionIdBySn(sn);
            ArrayList tmpList = new ArrayList(regionIdList);
            tmpList.removeAll(resDevRegionIds);
            stayRegionIds.addAll(tmpList);
        }
        if (!successRegionIds.isEmpty()) {
            this.regionRestoreRecordDao.updateRecordStatusBatch(successRegionIds, sn, count);
        }
        if (!stayRegionIds.isEmpty()) {
            this.regionDeviceDao.saveRegionDeviceBatch(sn, stayRegionIds);
        }
        return 1;
    }

    public ResultBean getStayRestoreRegion(String sn, String backNo) {
        ResultBean result = new ResultBean();
        result.setCode(1);
        TRegionKek regionKek = this.regionKekDao.getRegionKek(sn, backNo);
        if (null == regionKek) {
            result.setCode(3);
            return result;
        }
        List<Long> regionIds = this.regionRestoreRecordDao.queryStaryRestoreRegionIds(backNo, sn);
        if (null == regionIds || regionIds.isEmpty()) {
            result.setCode(2);
            return result;
        }
        List<TRegion> regions = this.regionDao.queryRegions(regionIds);
        result.setInfo(this.buildRegionData(regions, sn, regionKek.getKek()));
        return result;
    }

    public List<Map<String, Object>> queryRestorerecord(String sn) throws JSONException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Object[] data = this.regionRestoreRecordDao.queryRestoreRecord(sn);
        Map records = (Map)data[0];
        Set regionIds = (Set)data[1];
        if (records.isEmpty()) {
            return result;
        }
        Map<String, TRegionKek> regionKeks = this.regionKekDao.queryRegionKek(sn, records.keySet());
        Map<Long, TRegion> regions = this.regionDao.queryRegions(regionIds);
        TKek kek = this.kekKeyDao.queryBySN(sn);
        ArrayList tmpBackNoList = new ArrayList();
        ArrayList<RegionBean> regionList = null;
        HashMap<String, Object> item = null;
        TRegionKek regionKek = null;
        RegionBean region = null;
        TRegion regionInfo = null;
        TKek tmpKek = null;
        Kek kekInfo = null;
        SourceDataStruct kekSource = null;
        for (Map.Entry record : records.entrySet()) {
            item = new HashMap<String, Object>();
            item.put("backNo", record.getKey());
            regionKek = regionKeks.get(record.getKey());
            item.put("encKek", regionKek.getKek());
            item.put("encKekId", kek.getId());
            item.put("time", regionKek.getTime());
            regionList = new ArrayList<RegionBean>();
            item.put("regions", regionList);
            for (TRegionRestoreRecord restoreRecord : (List)record.getValue()) {
                if (!tmpBackNoList.contains(record.getKey())) {
                    item.put("restoreChipNo", restoreRecord.getRestoreChipNo());
                    item.put("backChipNo", restoreRecord.getBackChipNo());
                    item.put("backSn", restoreRecord.getBackSn());
                    tmpKek = this.kekKeyDao.queryBySN(restoreRecord.getBackSn());
                    item.put("backKekId", tmpKek.getId());
                    kekSource = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(tmpKek.getData(), SourceDataStruct.class);
                    kekInfo = (Kek)JsonMapper.alwaysMapper().fromJson(kekSource.getInfo(), Kek.class);
                    item.put("backKekAlg", kekInfo.getEncAlg());
                    tmpBackNoList.add(record.getKey());
                }
                if (null == (regionInfo = regions.get(restoreRecord.getRegionId()))) continue;
                region = new RegionBean();
                region.setId(regionInfo.getId());
                region.setName(regionInfo.getName());
                region.setAppName(regionInfo.getAppName());
                region.setPkName(regionInfo.getPkName());
                region.setInterfaceId(regionInfo.getInterfaceId());
                region.setDesc(regionInfo.getDesc());
                region.setStatus(restoreRecord.getStatus());
                region.setTime(restoreRecord.getTime());
                regionList.add(region);
            }
            result.add(item);
        }
        return result;
    }

    public boolean isRestoreSuccess(String sn, String backNo) {
        return this.regionUsedBackupCardDao.isBackupCardExist(sn, backNo);
    }

    public int doUploadRegionSecretKey(String bSn, String backNo, String rSn, String rChipNo, UploadRestoreKeyReq req) throws JSONException {
        if (bSn.equals(rSn)) {
            return 2;
        }
        TKek kekInfo = this.kekKeyDao.queryBySN(rSn);
        if (null == kekInfo) {
            return 3;
        }
        if (!kekInfo.getId().equals(req.getEncKekId())) {
            return 4;
        }
        this.saveSecretKeys(bSn, rSn, req);
        this.regionUsedBackupCardDao.saveBackupCard(rSn, backNo);
        return 1;
    }

    public ResultBean queryBackDevRegions(String chipSn, String backNo) {
        ResultBean result = new ResultBean();
        result.setCode(1);
        TBackupCard backupCard = this.backupCardDao.getBackupCard(backNo);
        if (null == backupCard || backupCard.getStatus() != BackupCardStatus.USED.value) {
            result.setCode(2);
            return result;
        }
        if (!backupCard.getChipSn().equals(chipSn)) {
            result.setCode(3);
            return result;
        }
        ArrayList<Map<String, Object>> info = new ArrayList<Map<String, Object>>();
        result.setInfo(info);
        List<Long> regionIds = this.regionDeviceDao.queryRegionIdBySn(chipSn);
        if (null == regionIds || regionIds.isEmpty()) {
            return result;
        }
        List<TRegion> regions = this.regionDao.queryRegions(regionIds);
        if (null == regions || regions.isEmpty()) {
            return result;
        }
        this.constructRegionInfo(regions, info);
        return result;
    }

    private Map<String, Object> buildRegionData(List<TRegion> regions, String sn, String encKek) {
        ArrayList<Map<String, Object>> regionList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("encKek", encKek);
        info.put("encKekId", this.kekKeyDao.queryBySN(sn).getId());
        info.put("regions", regionList);
        this.constructRegionInfo(regions, regionList);
        return info;
    }

    private void constructRegionInfo(List<TRegion> regions, List<Map<String, Object>> result) {
        HashMap<String, Object> data = null;
        for (TRegion region : regions) {
            data = new HashMap<String, Object>();
            data.put("id", region.getId());
            data.put("name", region.getName());
            data.put("appName", region.getAppName());
            data.put("pkName", region.getPkName());
            data.put("interfaceId", region.getInterfaceId());
            data.put("desc", region.getDesc());
            result.add(data);
        }
    }

    private void saveRestoreRecord(String backNo, String rChipNo, String rSn, String bSn, long time) {
        List<Long> regionIds = this.regionDeviceDao.queryRegionIdBySn(bSn);
        TRegionRestoreRecord record = new TRegionRestoreRecord();
        record.setBackNo(backNo);
        record.setRestoreChipNo(rChipNo.toLowerCase());
        record.setRestoreSn(rSn);
        record.setBackChipNo(this.kekKeyDao.queryBySN(bSn).getChipID().toLowerCase());
        record.setBackSn(bSn);
        record.setTime(time);
        this.regionRestoreRecordDao.saveRestoreRecord(record, regionIds);
    }

    private void saveSecretKeys(String bSn, String rSn, UploadRestoreKeyReq req) throws JSONException {
        List secretKeys = req.getSecretKeys();
        if (null != secretKeys && !secretKeys.isEmpty()) {
            for (UploadSecretkeyInfo info : secretKeys) {
                for (EntityInfo entityInfo : info.getEntities()) {
                    this.saveEntityInfo(entityInfo, rSn, bSn);
                }
            }
        }
        this.copyTodos2RestoreDevice(bSn, rSn, req.getEncKekId(), req.getEncKek());
    }
}

