/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.secret.provider.restore;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.safecenter.oauth.service.pojo.AppInfo;
import com.xdja.safecenter.secret.core.redis.RedisUtil;
import com.xdja.safecenter.secret.dao.BackupCardDao;
import com.xdja.safecenter.secret.dao.BackupDataDao;
import com.xdja.safecenter.secret.dao.BackupRestoreDao;
import com.xdja.safecenter.secret.dao.CellgroupDao;
import com.xdja.safecenter.secret.dao.WrapkeyDao;
import com.xdja.safecenter.secret.dao.kekKeyDao;
import com.xdja.safecenter.secret.model.TBackupCard;
import com.xdja.safecenter.secret.model.TBackupData;
import com.xdja.safecenter.secret.model.TBackupRecord;
import com.xdja.safecenter.secret.model.TCellGroup;
import com.xdja.safecenter.secret.model.TDevice;
import com.xdja.safecenter.secret.model.TKek;
import com.xdja.safecenter.secret.model.TKekWrapKey;
import com.xdja.safecenter.secret.model.TWrapKey;
import com.xdja.safecenter.secret.model.TWrapKeyData;
import com.xdja.safecenter.secret.provider.backup.BackupCardInfo;
import com.xdja.safecenter.secret.provider.backup.BaseProvider;
import com.xdja.safecenter.secret.provider.backup.bean.BackupCardStatus;
import com.xdja.safecenter.secret.provider.backup.bean.BackupType;
import com.xdja.safecenter.secret.provider.backup.bean.ResultBean;
import com.xdja.safecenter.secret.provider.cellgroup.bean.request.KekWrapKeyInfo;
import com.xdja.safecenter.secret.provider.open.IOpenServiceProvider;
import com.xdja.safecenter.secret.provider.restore.RestoreProvider;
import com.xdja.safecenter.secret.provider.restore.bean.Entity;
import com.xdja.safecenter.secret.provider.restore.bean.EntityInfo;
import com.xdja.safecenter.secret.provider.restore.bean.GetRestoreRecordResp;
import com.xdja.safecenter.secret.provider.restore.bean.SecretKey;
import com.xdja.safecenter.secret.provider.restore.bean.UploadRestoreKeyReq;
import com.xdja.safecenter.secret.provider.restore.bean.UploadSecretkeyInfo;
import com.xdja.safecenter.secret.struct.SourceDataStruct;
import com.xdja.safecenter.secret.struct.v2.KekWrapKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RestoreProviderImpl
extends BaseProvider
implements RestoreProvider {
    @Autowired
    private BackupCardDao backupCardDao;
    @Autowired
    private BackupDataDao backupDataDao;
    @Autowired
    private BackupRestoreDao backupRestoreDao;
    @Autowired
    private CellgroupDao cellgroupDao;
    @Autowired
    private kekKeyDao kekKeyDao;
    @Autowired
    private WrapkeyDao wrapkeyDao;
    @Autowired
    private IOpenServiceProvider openProvider;

    public ResultBean checkBackupCardCode(String chipSn, String bSn, String rCode) throws JSONException {
        ResultBean result = new ResultBean();
        result.setCode(1);
        BackupCardInfo remoteCard = this.getCardInfo(bSn);
        if (null == remoteCard) {
            result.setCode(2);
            return result;
        }
        TBackupCard localCard = this.backupCardDao.getBackupCard(bSn);
        if (null == localCard) {
            result.setCode(6);
            return result;
        }
        if (localCard.getStatus() != BackupCardStatus.USED.value) {
            result.setCode(3);
            return result;
        }
        if (localCard.getChipSn().equals(chipSn)) {
            result.setCode(8);
            return result;
        }
        if (!remoteCard.getrCode().equalsIgnoreCase(rCode)) {
            result.setCode(5);
            return result;
        }
        TBackupData backData = (TBackupData)this.backupDataDao.fetch(localCard.getId());
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("priKey", remoteCard.getPriKey());
        info.put("prAlg", String.valueOf(remoteCard.getPrAlg()));
        info.put("baKek", JsonMapper.alwaysMapper().fromJson(backData.getData(), SourceDataStruct.class));
        result.setInfo(info);
        return result;
    }

    public List<SecretKey> querySecretKeys(String chipSn) throws JSONException {
        Map<TDevice, Map<TCellGroup, String>> info = this.cellgroupDao.queryCellGroupAndDeviceBySn(chipSn);
        if (null == info || info.isEmpty()) {
            return null;
        }
        HashMap<String, SecretKey> result = new HashMap<String, SecretKey>();
        SecretKey secretKey = null;
        Map<TCellGroup, String> cellGroups = null;
        ArrayList<Entity> entities = null;
        TCellGroup cellGroup = null;
        String data = null;
        for (TDevice device : info.keySet()) {
            cellGroups = info.get(device);
            Iterator<TCellGroup> iterator = cellGroups.keySet().iterator();
            if (iterator.hasNext()) {
                TCellGroup item;
                cellGroup = item = iterator.next();
                data = cellGroups.get(item);
            }
            if (null == (secretKey = (SecretKey)result.get(device.getAppID()))) {
                secretKey = new SecretKey();
                secretKey.setAppId(device.getAppID());
                result.put(device.getAppID(), secretKey);
            }
            if (null == (entities = secretKey.getEntities())) {
                entities = new ArrayList<Entity>();
                secretKey.setEntities(entities);
            }
            entities.add(this.getEntity(chipSn, device, cellGroup, data));
        }
        Map infos = this.openProvider.getAppInfo(result.keySet().toArray(new String[result.size()]));
        for (Map.Entry item : infos.entrySet()) {
            secretKey = (SecretKey)result.get(item.getKey());
            if (null == secretKey) continue;
            secretKey.setSuit(((AppInfo)item.getValue()).getSuit());
        }
        return new ArrayList<SecretKey>(result.values());
    }

    private Entity getEntity(String chipSn, TDevice device, TCellGroup cellGroup, String cellGroupData) throws JSONException {
        Entity entity = new Entity();
        entity.setCellGroup((SourceDataStruct)JsonMapper.alwaysMapper().fromJson(cellGroupData, SourceDataStruct.class));
        entity.setKekWrapKeyInfos(this.getKekWrapKeyInfo(chipSn, device, cellGroup));
        return entity;
    }

    private List<KekWrapKeyInfo> getKekWrapKeyInfo(String chipSn, TDevice device, TCellGroup cellGroup) throws JSONException {
        ArrayList<KekWrapKeyInfo> result = new ArrayList<KekWrapKeyInfo>();
        long start = device.getStart() != -1L ? device.getStart() : 0L;
        long end = device.getEnd() != -1L ? device.getEnd() : cellGroup.getWrapKeyVersion();
        for (long i = start; i <= end; ++i) {
            TWrapKey wk = this.wrapkeyDao.getByCgIdAndVersion(cellGroup.getId(), i);
            TWrapKeyData wkData = this.wrapkeyDao.query(TWrapKeyData.class, wk.getId());
            TKek kek = this.kekKeyDao.queryBySN(chipSn);
            TKekWrapKey tkek = this.kekKeyDao.queryKekWrapKeyByKeKid(wk.getId(), kek.getId());
            SourceDataStruct wrapkey = (SourceDataStruct)JsonMapper.alwaysMapper().fromJson(wkData.getData(), SourceDataStruct.class);
            KekWrapKey kekWrapKey = (KekWrapKey)JsonMapper.alwaysMapper().fromJson(tkek.getData(), KekWrapKey.class);
            result.add(new KekWrapKeyInfo(wrapkey, kekWrapKey));
        }
        return result;
    }

    public List<GetRestoreRecordResp> getRestoreRecords(String chipSN) {
        ArrayList<GetRestoreRecordResp> result = new ArrayList<GetRestoreRecordResp>();
        List<TBackupRecord> records = this.backupRestoreDao.queryBackupRecord(chipSN);
        if (!records.isEmpty()) {
            for (TBackupRecord record : records) {
                result.add(new GetRestoreRecordResp(record.getBackupChipNo(), record.getRestoreChipNo(), record.getSn(), Long.valueOf(record.getTime())));
            }
        }
        return result;
    }

    public void doUploadRestoreSecretKey(String chipSN, String sn, String rChipID, UploadRestoreKeyReq req) throws JSONException {
        List secretKeys = req.getSecretKeys();
        if (req.getSecretKeys() != null && !req.getSecretKeys().isEmpty()) {
            for (UploadSecretkeyInfo info : secretKeys) {
                for (EntityInfo entityInfo : info.getEntities()) {
                    this.saveEntityInfo(entityInfo, sn, chipSN);
                }
            }
        }
        this.copyTodos2RestoreDevice(chipSN, sn, req.getEncKekId(), req.getEncKek());
        List<String> backCardSns = this.backupCardDao.querySnList(chipSN, BackupCardStatus.USED.value);
        TBackupCard backupCard = (TBackupCard)this.backupCardDao.fetch((Condition)Cnd.where((String)"c_sn", (String)"=", (Object)backCardSns.get(0)));
        backupCard.setStatus(BackupCardStatus.INVALID.value);
        this.backupCardDao.update(backupCard);
        TKek kek = this.kekKeyDao.queryBySN(chipSN);
        TBackupRecord record = new TBackupRecord();
        record.setId(RedisUtil.incr((String)"bark"));
        record.setBackupChipNo(kek.getChipID());
        record.setBackupChipSn(chipSN);
        record.setRestoreChipNo(rChipID.toUpperCase());
        record.setRestoreChipSn(sn);
        record.setSn(backCardSns.get(0));
        record.setTime(System.currentTimeMillis());
        this.backupRestoreDao.insert(record);
        if (backupCard.getType() == BackupType.CARD.value) {
            this.sendUpdateBackupCardStatusMsg(backCardSns.get(0), BackupCardStatus.INVALID);
        }
    }

    public Map<String, Integer> queryAppSuits(String chipSn) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List<String> appIds = this.backupCardDao.queryDeviceAppIds(chipSn);
        if (!appIds.isEmpty()) {
            Map infos = this.openProvider.getAppInfo(appIds.toArray(new String[appIds.size()]));
            for (Map.Entry item : infos.entrySet()) {
                result.put((String)item.getKey(), ((AppInfo)item.getValue()).getSuit());
            }
        }
        return result;
    }

    public ResultBean getBackupKey(String chipSn, String bKeySn) throws JSONException {
        ResultBean result = this.checkBackupKeyStatus(bKeySn, chipSn);
        if (result.getCode() != 1) {
            return result;
        }
        TBackupData backData = (TBackupData)this.backupDataDao.fetch(((TBackupCard)result.getInfo()).getId());
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("baKek", JsonMapper.alwaysMapper().fromJson(backData.getData(), SourceDataStruct.class));
        result.setInfo(info);
        return result;
    }

    public ResultBean checkBackupKey(String bKeySn, String chipSn) {
        ResultBean result = this.checkBackupKeyStatus(bKeySn, chipSn);
        if (result.getCode() != 1) {
            return result;
        }
        result.setInfo((Object)((TBackupCard)result.getInfo()).getChipSn());
        return result;
    }

    private ResultBean checkBackupKeyStatus(String bKeySn, String chipSn) {
        ResultBean result = new ResultBean();
        result.setCode(1);
        if (!this.isBackupKey(bKeySn)) {
            result.setCode(2);
            return result;
        }
        TBackupCard localCard = this.backupCardDao.getBackupCard(bKeySn, BackupType.KEY.value);
        if (null == localCard) {
            result.setCode(6);
            return result;
        }
        if (localCard.getStatus() != BackupCardStatus.USED.value) {
            result.setCode(3);
            return result;
        }
        if (localCard.getChipSn().equals(chipSn)) {
            result.setCode(8);
            return result;
        }
        result.setInfo((Object)localCard);
        return result;
    }
}

