/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safecenter.soc.controller;

import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.safecenter.soc.controller.ErrorMessage;
import com.xdja.safecenter.soc.controller.HttpError;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class AbstractController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected HttpSession session;

    @ModelAttribute
    public void setModelAttribute(HttpServletRequest request, HttpServletResponse response, @RequestHeader String cardId, @RequestHeader String sn) {
        this.session = request.getSession();
    }

    protected final void renderError(HttpServletResponse response, HttpError error) {
        ErrorMessage msg = error.handle(response);
        try {
            this.logger.error(JsonMapper.alwaysMapper().toJson((Object)msg));
            response.getWriter().println(JsonMapper.alwaysMapper().toJson((Object)msg));
        }
        catch (IOException e) {
            this.logger.error("\u6253\u5f00HttpServletResponse\u7684writer\u5931\u8d25\uff0c\u53ef\u80fd\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed", (Throwable)e);
        }
        catch (JSONException e) {
            this.logger.error("\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\u4e3ajson\u4e32\u65f6\u5931\u8d25", (Throwable)e);
        }
    }

    protected String getChipID(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("cardId").toLowerCase();
    }

    protected String getSN(HttpServletRequest request) {
        return request == null ? "" : request.getHeader("sn").toLowerCase();
    }

    protected boolean checkMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return false;
        }
        Prop sysProp = PropKit.use((String)"config.properties");
        String regexMobile = sysProp.get("regex.mobile", "^1[34578]{1}\\d{9}$");
        return Pattern.matches(regexMobile, mobile);
    }
}

